/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.RequestScoped;
import jakarta.interceptor.Interceptors;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.Animal;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.AnimalInterceptor;

@Interceptors(value={AnimalInterceptor.class})
@RequestScoped
class Cow
extends Animal {
    protected static final String COW = "Cow";
    private static boolean postConstructInterceptorCalled = false;
    private static boolean preDestroyInterceptorCalled = false;

    Cow() {
    }

    @PostConstruct
    public void postConstruct() {
        postConstructInterceptorCalled = true;
    }

    public String echo(String message) {
        return message;
    }

    @PreDestroy
    public void preDestroy() {
        preDestroyInterceptorCalled = true;
    }

    public static boolean isPostConstructInterceptorCalled() {
        return postConstructInterceptorCalled;
    }

    public static boolean isPreDestroyInterceptorCalled() {
        return preDestroyInterceptorCalled;
    }

    @Override
    public String getAnimalType() {
        return COW;
    }
}

