/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation.determination;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class ConversationDeterminationTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ConversationDeterminationTest.class)).build();
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertions(value={@SpecAssertion(section="conversation_context_ee", id="da"), @SpecAssertion(section="conversation_context_ee", id="db"), @SpecAssertion(section="conversation_context_ee", id="dc"), @SpecAssertion(section="conversation_context_ee", id="dd")})
    public void testConversationDetermination() throws Exception {
        WebClient webClient = new WebClient();
        TextPage cidPage = (TextPage)webClient.getPage(this.contextPath + "foo?action=begin");
        String cid = cidPage.getContent().substring(cidPage.getContent().indexOf("cid: [") + 6, cidPage.getContent().indexOf("]"));
        Assert.assertTrue((boolean)cidPage.getContent().contains("transient: false"));
        TextPage resultPage = (TextPage)webClient.getPage(this.getContextPath(this.contextPath, "foo", "test", cid));
        Assert.assertTrue((boolean)resultPage.getContent().contains("testServlet=true"));
        Assert.assertTrue((boolean)resultPage.getContent().contains("testFilter=true"));
        Assert.assertTrue((boolean)resultPage.getContent().contains("testListener=true"));
        webClient.getPage(this.getContextPath(this.contextPath, "foo-async", "complete", cid));
        TextPage results = (TextPage)webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onComplete: true"));
        webClient.getPage(this.getContextPath(this.contextPath, "foo-async", "timeout", cid));
        results = (TextPage)webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onTimeout: true"));
        webClient.getPage(this.getContextPath(this.contextPath, "foo-async", "error", cid));
        results = (TextPage)webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onError: true"));
        webClient.getPage(this.getContextPath(this.contextPath, "foo-async", "loop", cid));
        results = (TextPage)webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onStartAsync: true"));
    }

    private String getContextPath(URL contextPath, String servlet, String param, String cid) {
        return contextPath + servlet + "?action=" + param + "&cid=" + cid.trim();
    }
}

