/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.interceptors.tests.contract.method;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.interceptors.tests.contract.method.Dog;
import org.jboss.cdi.tck.tests.full.interceptors.tests.contract.method.Fish;
import org.jboss.cdi.tck.tests.full.interceptors.tests.contract.method.FishInterceptor;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="interceptors", version="1.2")
public class MethodLevelInterceptorTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(MethodLevelInterceptorTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constructor_and_method_level_int", id="d"), @SpecAssertion(section="associating_int_using_interceptors_annotation", id="a"), @SpecAssertion(section="constructor_and_method_level_int", id="e")})
    public void testInterceptorCanBeAppliedToMoreThanOneMethod() {
        Fish fish = this.getContextualReference(Fish.class, new Annotation[0]);
        Assert.assertEquals((String)fish.foo(), (String)"Intercepted bar");
        Assert.assertEquals((String)fish.ping(), (String)"Intercepted pong");
        Assert.assertEquals((String)fish.getName(), (String)"Salmon");
        Assert.assertEquals((int)FishInterceptor.getInstanceCount(), (int)1);
    }

    @SpecAssertion(section="excluding_interceptors", id="b")
    public void testExcludeClassInterceptors() {
        Assert.assertEquals((String)this.getContextualReference(Dog.class, new Annotation[0]).foo(), (String)"Intercepted bar");
        Assert.assertEquals((String)this.getContextualReference(Dog.class, new Annotation[0]).ping(), (String)"pong");
    }
}

