/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.util.annotated;

import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;

public class AnnotatedTypes {
    private static boolean compareAnnotated(Annotated a1, Annotated a2) {
        return a1.getAnnotations().equals(a2.getAnnotations());
    }

    public static boolean compareAnnotatedField(AnnotatedField<?> f1, AnnotatedField<?> f2) {
        if (!f1.getJavaMember().equals(f2.getJavaMember())) {
            return false;
        }
        return AnnotatedTypes.compareAnnotated(f1, f2);
    }

    public static boolean compareAnnotatedCallable(AnnotatedCallable<?> m1, AnnotatedCallable<?> m2) {
        if (!m1.getJavaMember().equals(m2.getJavaMember())) {
            return false;
        }
        if (!AnnotatedTypes.compareAnnotated(m1, m2)) {
            return false;
        }
        return AnnotatedTypes.compareAnnotatedParameters(m1.getParameters(), m2.getParameters());
    }

    public static boolean compareAnnotatedParameters(List<? extends AnnotatedParameter<?>> p1, List<? extends AnnotatedParameter<?>> p2) {
        if (p1.size() != p2.size()) {
            return false;
        }
        for (int i = 0; i < p1.size(); ++i) {
            if (AnnotatedTypes.compareAnnotated((Annotated)p1.get(i), (Annotated)p2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean compareAnnotatedTypes(AnnotatedType<?> t1, AnnotatedType<?> t2) {
        if (!t1.getJavaClass().equals(t2.getJavaClass())) {
            return false;
        }
        if (!AnnotatedTypes.compareAnnotated(t1, t2)) {
            return false;
        }
        if (t1.getFields().size() != t2.getFields().size()) {
            return false;
        }
        HashMap<Field, AnnotatedField> fields = new HashMap<Field, AnnotatedField>();
        for (Object f : t2.getFields()) {
            fields.put(f.getJavaMember(), (AnnotatedField)f);
        }
        for (Object f : t1.getFields()) {
            if (fields.containsKey(f.getJavaMember())) {
                if (AnnotatedTypes.compareAnnotatedField(f, (AnnotatedField)fields.get(f.getJavaMember()))) continue;
                return false;
            }
            return false;
        }
        if (t1.getMethods().size() != t2.getMethods().size()) {
            return false;
        }
        HashMap<Method, AnnotatedMethod> methods = new HashMap<Method, AnnotatedMethod>();
        for (AnnotatedMethod f : t2.getMethods()) {
            methods.put(f.getJavaMember(), f);
        }
        for (AnnotatedMethod f : t1.getMethods()) {
            if (methods.containsKey(f.getJavaMember())) {
                if (AnnotatedTypes.compareAnnotatedCallable(f, (AnnotatedCallable)methods.get(f.getJavaMember()))) continue;
                return false;
            }
            return false;
        }
        if (t1.getConstructors().size() != t2.getConstructors().size()) {
            return false;
        }
        HashMap<Constructor, AnnotatedConstructor> constructors = new HashMap<Constructor, AnnotatedConstructor>();
        for (AnnotatedConstructor f : t2.getConstructors()) {
            constructors.put(f.getJavaMember(), f);
        }
        for (AnnotatedConstructor f : t1.getConstructors()) {
            if (constructors.containsKey(f.getJavaMember())) {
                if (AnnotatedTypes.compareAnnotatedCallable(f, (AnnotatedCallable)constructors.get(f.getJavaMember()))) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

