/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.Animal;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.Fish;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.InvalidBeanType;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.Landmark;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.Mountain;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.Natural;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.TundraStereotype;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.Wild;
import org.jboss.cdi.tck.util.annotated.AnnotatedTypeWrapper;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class CreateBeanAttributesTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(CreateBeanAttributesTest.class)).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL))).build();
    }

    @Test
    @SpecAssertion(section="bm_obtain_beanattributes", id="a")
    public void testBeanAttributesForManagedBean() {
        AnnotatedType type = this.getCurrentManager().createAnnotatedType(Mountain.class);
        BeanAttributes attributes = this.getCurrentManager().createBeanAttributes(type);
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Landmark.class, Object.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getStereotypes(), new Type[]{TundraStereotype.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), Natural.class, Any.class));
        Assert.assertEquals((Object)attributes.getScope(), ApplicationScoped.class);
        Assert.assertEquals((String)attributes.getName(), (String)"mountain");
        Assert.assertTrue((boolean)attributes.isAlternative());
    }

    @Test
    @SpecAssertion(section="bm_obtain_beanattributes", id="a")
    public void testBeanAttributesForManagedBeanWithModifiedAnnotatedType() {
        AnnotatedType type = this.getCurrentManager().createAnnotatedType(Mountain.class);
        AnnotatedTypeWrapper wrappedType = new AnnotatedTypeWrapper(type, false, new Annotation[]{NamedLiteral.of((String)"Mount Blanc")});
        BeanAttributes attributes = this.getCurrentManager().createBeanAttributes(wrappedType);
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Mountain.class, Landmark.class, Object.class}));
        Assert.assertTrue((boolean)attributes.getStereotypes().isEmpty());
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), Named.class, Any.class, Default.class));
        Assert.assertEquals((Object)attributes.getScope(), Dependent.class);
        Assert.assertEquals((String)attributes.getName(), (String)"Mount Blanc");
        Assert.assertFalse((boolean)attributes.isAlternative());
    }

    private void verifyLakeFish(BeanAttributes<?> attributes) {
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Fish.class, Object.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getStereotypes(), new Type[]{TundraStereotype.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), Natural.class, Any.class, Named.class));
        Assert.assertEquals((Object)attributes.getScope(), ApplicationScoped.class);
        Assert.assertEquals((String)attributes.getName(), (String)"fish");
        Assert.assertTrue((boolean)attributes.isAlternative());
    }

    private void verifyDamFish(BeanAttributes<?> attributes) {
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Fish.class, Animal.class, Object.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), Wild.class, Any.class));
        Assert.assertTrue((boolean)attributes.getStereotypes().isEmpty());
        Assert.assertEquals((Object)attributes.getScope(), Dependent.class);
        Assert.assertNull((Object)attributes.getName());
        Assert.assertFalse((boolean)attributes.isAlternative());
    }

    private void verifyVolume(BeanAttributes<?> attributes) {
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Long.TYPE, Object.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), Any.class, Default.class, Named.class));
        Assert.assertTrue((boolean)attributes.getStereotypes().isEmpty());
        Assert.assertEquals((Object)attributes.getScope(), Dependent.class);
        Assert.assertEquals((String)attributes.getName(), (String)"volume");
        Assert.assertFalse((boolean)attributes.isAlternative());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_obtain_beanattributes", id="c")
    public void testInvalidMember() {
        AnnotatedConstructor constructor = (AnnotatedConstructor)this.getCurrentManager().createAnnotatedType(InvalidBeanType.class).getConstructors().iterator().next();
        this.getCurrentManager().createBeanAttributes((AnnotatedMember)constructor);
    }
}

