/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.lang.model.tck;

import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.AnnotationMember;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.cdi.lang.model.tck.AnnRepeatable;
import org.jboss.cdi.lang.model.tck.AnnRepeatableContainer;
import org.jboss.cdi.lang.model.tck.AnnRepeatableMissing;
import org.jboss.cdi.lang.model.tck.InheritedRepeatableAnnotations;
import org.jboss.cdi.lang.model.tck.LangModelUtils;
import org.jboss.cdi.lang.model.tck.MissingAnnotation;
import org.jboss.cdi.lang.model.tck.MixedRepeatableAnnotations;
import org.jboss.cdi.lang.model.tck.SingleRepeatableAnnotation;
import org.jboss.cdi.lang.model.tck.SuperClassWithRepeatableAnnotation;

public class RepeatableAnnotations
extends SuperClassWithRepeatableAnnotation {
    InheritedRepeatableAnnotations inheritedRepeatableAnnotations;
    SingleRepeatableAnnotation singleRepeatableAnnotation;
    MixedRepeatableAnnotations mixedRepeatableAnnotations;

    public static void verify(ClassInfo clazz) {
        ClassInfo inheritedClass = LangModelUtils.classOfField(clazz, "inheritedRepeatableAnnotations");
        RepeatableAnnotations.verifyInheritedRepeatableAnnotations(inheritedClass);
        RepeatableAnnotations.verifyInheritedRepeatableAnnotations(inheritedClass.superClassDeclaration());
        RepeatableAnnotations.verifyInheritedRepeatableAnnotationsSuperSuperClass(inheritedClass.superClassDeclaration().superClassDeclaration());
        RepeatableAnnotations.verifyInheritedRepeatableAnnotationsSuperSuperSuperClass(inheritedClass.superClassDeclaration().superClassDeclaration().superClassDeclaration());
        RepeatableAnnotations.verifySingleRepeatableAnnotation(LangModelUtils.classOfField(clazz, "singleRepeatableAnnotation"));
        RepeatableAnnotations.verifyMixedRepeatableAnnotations(LangModelUtils.classOfField(clazz, "mixedRepeatableAnnotations"));
    }

    private static void verifyInheritedRepeatableAnnotations(ClassInfo clazz) {
        assert (clazz.annotations().size() == 2);
        assert (clazz.hasAnnotation(AnnRepeatableContainer.class));
        assert (clazz.hasAnnotation(AnnRepeatable.class));
        assert (clazz.hasAnnotation(it -> it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnRepeatableContainer")));
        assert (clazz.hasAnnotation(it -> it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnRepeatable")));
        assert (clazz.annotation(AnnRepeatableContainer.class) != null);
        assert (clazz.annotation(AnnRepeatableContainer.class).value().isArray());
        assert (clazz.annotation(AnnRepeatableContainer.class).value().asArray().size() == 3);
        assert (((AnnotationMember)clazz.annotation(AnnRepeatableContainer.class).value().asArray().get(0)).asNestedAnnotation().value().asString().equals("qux"));
        assert (((AnnotationMember)clazz.annotation(AnnRepeatableContainer.class).value().asArray().get(1)).asNestedAnnotation().value().asString().equals("quux"));
        assert (((AnnotationMember)clazz.annotation(AnnRepeatableContainer.class).value().asArray().get(2)).asNestedAnnotation().value().asString().equals("quuz"));
        assert (clazz.annotation(AnnRepeatable.class) != null);
        assert (clazz.annotation(AnnRepeatable.class).value().isString());
        assert (clazz.annotation(AnnRepeatable.class).value().asString().equals("baz"));
        Collection anns = clazz.repeatableAnnotation(AnnRepeatable.class);
        assert (anns.size() == 3);
        Set annValues = anns.stream().map(it -> it.value().asString()).collect(Collectors.toSet());
        assert (annValues.size() == 3);
        assert (annValues.contains("qux"));
        assert (annValues.contains("quux"));
        assert (annValues.contains("quuz"));
        assert (clazz.annotation(AnnRepeatableMissing.class) == null);
        assert (clazz.repeatableAnnotation(AnnRepeatableMissing.class).isEmpty());
        assert (clazz.annotation(MissingAnnotation.class) == null);
        assert (clazz.repeatableAnnotation(MissingAnnotation.class).isEmpty());
    }

    private static void verifyInheritedRepeatableAnnotationsSuperSuperClass(ClassInfo clazz) {
        assert (clazz.annotations().size() == 2);
        assert (clazz.hasAnnotation(AnnRepeatableContainer.class));
        assert (clazz.hasAnnotation(AnnRepeatable.class));
        assert (clazz.hasAnnotation(it -> it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnRepeatableContainer")));
        assert (clazz.hasAnnotation(it -> it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnRepeatable")));
        assert (clazz.annotation(AnnRepeatableContainer.class) != null);
        assert (clazz.annotation(AnnRepeatableContainer.class).value().isArray());
        assert (clazz.annotation(AnnRepeatableContainer.class).value().asArray().size() == 2);
        assert (((AnnotationMember)clazz.annotation(AnnRepeatableContainer.class).value().asArray().get(0)).asNestedAnnotation().value().asString().equals("foo"));
        assert (((AnnotationMember)clazz.annotation(AnnRepeatableContainer.class).value().asArray().get(1)).asNestedAnnotation().value().asString().equals("bar"));
        assert (clazz.annotation(AnnRepeatable.class) != null);
        assert (clazz.annotation(AnnRepeatable.class).value().isString());
        assert (clazz.annotation(AnnRepeatable.class).value().asString().equals("baz"));
        Collection anns = clazz.repeatableAnnotation(AnnRepeatable.class);
        assert (anns.size() == 1);
        Set annValues = anns.stream().map(it -> it.value().asString()).collect(Collectors.toSet());
        assert (annValues.size() == 1);
        assert (annValues.contains("baz"));
        assert (clazz.annotation(AnnRepeatableMissing.class) == null);
        assert (clazz.repeatableAnnotation(AnnRepeatableMissing.class).isEmpty());
        assert (clazz.annotation(MissingAnnotation.class) == null);
        assert (clazz.repeatableAnnotation(MissingAnnotation.class).isEmpty());
    }

    private static void verifyInheritedRepeatableAnnotationsSuperSuperSuperClass(ClassInfo clazz) {
        assert (clazz.annotations().size() == 1);
        assert (clazz.hasAnnotation(AnnRepeatableContainer.class));
        assert (!clazz.hasAnnotation(AnnRepeatable.class));
        assert (clazz.hasAnnotation(it -> it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnRepeatableContainer")));
        assert (!clazz.hasAnnotation(it -> it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnRepeatable")));
        assert (clazz.annotation(AnnRepeatableContainer.class) != null);
        assert (clazz.annotation(AnnRepeatableContainer.class).value().isArray());
        assert (clazz.annotation(AnnRepeatableContainer.class).value().asArray().size() == 2);
        assert (((AnnotationMember)clazz.annotation(AnnRepeatableContainer.class).value().asArray().get(0)).asNestedAnnotation().value().asString().equals("foo"));
        assert (((AnnotationMember)clazz.annotation(AnnRepeatableContainer.class).value().asArray().get(1)).asNestedAnnotation().value().asString().equals("bar"));
        assert (clazz.annotation(AnnRepeatable.class) == null);
        Collection anns = clazz.repeatableAnnotation(AnnRepeatable.class);
        assert (anns.size() == 2);
        Set annValues = anns.stream().map(it -> it.value().asString()).collect(Collectors.toSet());
        assert (annValues.size() == 2);
        assert (annValues.contains("foo"));
        assert (annValues.contains("bar"));
        assert (clazz.annotation(AnnRepeatableMissing.class) == null);
        assert (clazz.repeatableAnnotation(AnnRepeatableMissing.class).isEmpty());
        assert (clazz.annotation(MissingAnnotation.class) == null);
        assert (clazz.repeatableAnnotation(MissingAnnotation.class).isEmpty());
    }

    private static void verifySingleRepeatableAnnotation(ClassInfo clazz) {
        assert (clazz.annotations().size() == 1);
        assert (!clazz.hasAnnotation(AnnRepeatableContainer.class));
        assert (clazz.hasAnnotation(AnnRepeatable.class));
        assert (!clazz.hasAnnotation(it -> it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnRepeatableContainer")));
        assert (clazz.hasAnnotation(it -> it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnRepeatable")));
        assert (clazz.annotation(AnnRepeatableContainer.class) == null);
        assert (clazz.annotation(AnnRepeatable.class) != null);
        assert (clazz.annotation(AnnRepeatable.class).value().isString());
        assert (clazz.annotation(AnnRepeatable.class).value().asString().equals("single"));
        Collection anns = clazz.repeatableAnnotation(AnnRepeatable.class);
        assert (anns.size() == 1);
        assert (((AnnotationInfo)anns.iterator().next()).value().asString().equals("single"));
        assert (clazz.annotation(AnnRepeatableMissing.class) == null);
        assert (clazz.repeatableAnnotation(AnnRepeatableMissing.class).isEmpty());
        assert (clazz.annotation(MissingAnnotation.class) == null);
        assert (clazz.repeatableAnnotation(MissingAnnotation.class).isEmpty());
    }

    private static void verifyMixedRepeatableAnnotations(ClassInfo clazz) {
        assert (clazz.annotations().size() == 2);
        assert (clazz.hasAnnotation(AnnRepeatableContainer.class));
        assert (clazz.hasAnnotation(AnnRepeatable.class));
        assert (clazz.hasAnnotation(it -> it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnRepeatableContainer")));
        assert (clazz.hasAnnotation(it -> it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnRepeatable")));
        assert (clazz.annotation(AnnRepeatableContainer.class) != null);
        assert (clazz.annotation(AnnRepeatableContainer.class).value().isArray());
        assert (clazz.annotation(AnnRepeatableContainer.class).value().asArray().size() == 2);
        assert (((AnnotationMember)clazz.annotation(AnnRepeatableContainer.class).value().asArray().get(0)).asNestedAnnotation().value().asString().equals("b"));
        assert (((AnnotationMember)clazz.annotation(AnnRepeatableContainer.class).value().asArray().get(1)).asNestedAnnotation().value().asString().equals("c"));
        assert (clazz.annotation(AnnRepeatable.class) != null);
        assert (clazz.annotation(AnnRepeatable.class).value().isString());
        assert (clazz.annotation(AnnRepeatable.class).value().asString().equals("a"));
        Collection anns = clazz.repeatableAnnotation(AnnRepeatable.class);
        assert (anns.size() == 3);
        Set annValues = anns.stream().map(it -> it.value().asString()).collect(Collectors.toSet());
        assert (annValues.size() == 3);
        assert (annValues.contains("a"));
        assert (annValues.contains("b"));
        assert (annValues.contains("c"));
        assert (clazz.annotation(AnnRepeatableMissing.class) == null);
        assert (clazz.repeatableAnnotation(AnnRepeatableMissing.class).isEmpty());
        assert (clazz.annotation(MissingAnnotation.class) == null);
        assert (clazz.repeatableAnnotation(MissingAnnotation.class).isEmpty());
    }
}

