/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.AlmightyLifecycleInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.Animal;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.AnimalInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.Cat;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.CatInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.Chicken;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.Cow;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.Dog;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.Goat;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.Hen;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.PackagePrivateLifecycleInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.PrivateLifecycleInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.ProtectedLifecycleInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.PublicLifecycleInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.Sheep;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.SheepInterceptor;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="interceptors", version="1.2")
public class LifecycleCallbackInterceptorTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(LifecycleCallbackInterceptorTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="def_of_interceptor_classes_and_interceptor_methods", id="ab"), @SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="b")})
    public void testPostConstructInterceptor() {
        this.getContextualReference(Goat.class, new Annotation[0]);
        Assert.assertTrue((boolean)Goat.isPostConstructInterceptorCalled());
        Assert.assertTrue((boolean)AnimalInterceptor.isPostConstructInterceptorCalled("Goat"));
        this.getContextualReference(Hen.class, new Annotation[0]).toString();
        Assert.assertTrue((boolean)Hen.isPostConstructInterceptorCalled());
        Assert.assertTrue((boolean)AnimalInterceptor.isPostConstructInterceptorCalled("Hen"));
        this.getContextualReference(Cow.class, new Annotation[0]).toString();
        Assert.assertTrue((boolean)Cow.isPostConstructInterceptorCalled());
        Assert.assertTrue((boolean)AnimalInterceptor.isPostConstructInterceptorCalled("Cow"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="def_of_interceptor_classes_and_interceptor_methods", id="ab"), @SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="c")})
    public void testPreDestroyInterceptor() {
        this.createAndDestroyInstance(Goat.class);
        Assert.assertTrue((boolean)Goat.isPreDestroyInterceptorCalled());
        Assert.assertTrue((boolean)AnimalInterceptor.isPreDestroyInterceptorCalled("Goat"));
        this.createAndDestroyInstance(Hen.class);
        Assert.assertTrue((boolean)Hen.isPreDestroyInterceptorCalled());
        Assert.assertTrue((boolean)AnimalInterceptor.isPreDestroyInterceptorCalled("Hen"));
        this.createAndDestroyInstance(Cow.class);
        Assert.assertTrue((boolean)Cow.isPreDestroyInterceptorCalled());
        Assert.assertTrue((boolean)AnimalInterceptor.isPreDestroyInterceptorCalled("Cow"));
    }

    @Test
    @SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="f")
    public void testSingleMethodInterposingMultipleLifecycleCallbackEvents() {
        AlmightyLifecycleInterceptor.reset();
        Dog.reset();
        this.createAndDestroyInstance(Dog.class);
        Assert.assertEquals((int)AlmightyLifecycleInterceptor.getNumberOfInterceptions(), (int)3);
        Assert.assertEquals((int)Dog.getNumberOfInterceptions(), (int)2);
    }

    private <T extends Animal> void createAndDestroyInstance(Class<T> clazz) {
        Bean<T> bean = this.getUniqueBean(clazz, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Animal instance = (Animal)this.getCurrentManager().getReference(bean, clazz, ctx);
        instance.foo();
        bean.destroy((Object)instance, ctx);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="def_of_interceptor_classes_and_interceptor_methods", id="ab"), @SpecAssertion(section="def_of_interceptor_classes_and_interceptor_methods", id="d")})
    public void testAroundInvokeAndLifeCycleCallbackInterceptorsCanBeDefinedOnTheSameClass() {
        Assert.assertEquals((String)this.getContextualReference(Goat.class, new Annotation[0]).echo("foo"), (String)"foofoo");
    }

    @Test
    @SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="ja")
    public void testPublicLifecycleInterceptorMethod() {
        this.getContextualReference(Chicken.class, new Annotation[0]);
        Assert.assertTrue((boolean)PublicLifecycleInterceptor.isIntercepted());
    }

    @Test
    @SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="jc")
    public void testProtectedLifecycleInterceptorMethod() {
        this.getContextualReference(Chicken.class, new Annotation[0]);
        Assert.assertTrue((boolean)ProtectedLifecycleInterceptor.isIntercepted());
    }

    @Test
    @SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="jb")
    public void testPrivateLifecycleInterceptorMethod() {
        this.getContextualReference(Chicken.class, new Annotation[0]);
        Assert.assertTrue((boolean)PrivateLifecycleInterceptor.isIntercepted());
    }

    @Test
    @SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="jd")
    public void testPackagePrivateLifecycleInterceptorMethod() {
        this.getContextualReference(Chicken.class, new Annotation[0]);
        Assert.assertTrue((boolean)PackagePrivateLifecycleInterceptor.isIntercepted());
    }

    @Test
    @SpecAssertion(section="constructor_and_method_level_int", id="b")
    public void testLifeCycleCallbackInterceptorNotInvokedForMethodLevelInterceptor() {
        Assert.assertEquals((String)this.getContextualReference(Sheep.class, new Annotation[0]).foo(), (String)"bar");
        Assert.assertTrue((boolean)SheepInterceptor.isAroundInvokeCalled());
        Assert.assertFalse((boolean)SheepInterceptor.isPostConstructCalled());
    }

    @Test(groups={"javaee-full"})
    @SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="h")
    public void testLifecycleCallbackInterceptorTransactionContext() {
        this.createAndDestroyInstance(Cat.class);
        Assert.assertTrue((boolean)CatInterceptor.pcCalled);
        Assert.assertTrue((boolean)CatInterceptor.pdCalled);
    }
}

