/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSessionListener;
import jakarta.servlet.jsp.tagext.JspTag;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.ApplicationEnvironment;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.cdi.CDILoggerInfo;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.web.deployment.descriptor.AppListenerDescriptorImpl;
import org.glassfish.web.deployment.descriptor.ServletFilterDescriptor;
import org.glassfish.web.deployment.descriptor.ServletFilterMappingDescriptor;
import org.glassfish.weld.BeanDeploymentArchiveImpl;
import org.glassfish.weld.DeploymentImpl;
import org.glassfish.weld.ResourceLoaderImpl;
import org.glassfish.weld.RootBeanDeploymentArchive;
import org.glassfish.weld.WeldApplicationContainer;
import org.glassfish.weld.WeldContainer;
import org.glassfish.weld.connector.WeldUtils;
import org.glassfish.weld.services.EjbServicesImpl;
import org.glassfish.weld.services.InjectionServicesImpl;
import org.glassfish.weld.services.NonModuleInjectionServices;
import org.glassfish.weld.services.ProxyServicesImpl;
import org.glassfish.weld.services.SecurityServicesImpl;
import org.glassfish.weld.services.TransactionServicesImpl;
import org.glassfish.weld.util.Util;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.EEModuleDescriptor;
import org.jboss.weld.bootstrap.spi.helpers.EEModuleDescriptorImpl;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jvnet.hk2.annotations.Service;

@Service
public class WeldDeployer
extends SimpleDeployer<WeldContainer, WeldApplicationContainer>
implements PostConstruct,
EventListener {
    private Logger logger = CDILoggerInfo.getLogger();
    public static final String WELD_EXTENSION = "org.glassfish.weld";
    public static final String WELD_DEPLOYMENT = "org.glassfish.weld.WeldDeployment";
    static final String WELD_BOOTSTRAP = "org.glassfish.weld.WeldBootstrap";
    private static final String WELD_CONTEXT_LISTENER = "org.glassfish.weld.WeldContextListener";
    private static final String WELD_LISTENER = "org.jboss.weld.module.web.servlet.WeldListener";
    private static final String WELD_TERMINATION_LISTENER = "org.jboss.weld.module.web.servlet.WeldTerminalListener";
    private static final String WELD_SHUTDOWN = "weld_shutdown";
    private static final String WELD_BOOTSTRAP_SHUTDOWN = "weld_bootstrap_shutdown";
    private static final String WELD_CONVERSATION_FILTER_CLASS = "org.jboss.weld.module.web.servlet.ConversationFilter";
    private static final String WELD_CONVERSATION_FILTER_NAME = "CDI Conversation Filter";
    @Inject
    private Events events;
    @Inject
    private ServiceLocator services;
    @Inject
    private ApplicationRegistry applicationRegistry;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    ArchiveFactory archiveFactory;
    private Map<Application, WeldBootstrap> appToBootstrap = new HashMap<Application, WeldBootstrap>();
    private Map<BundleDescriptor, BeanDeploymentArchive> bundleToBeanDeploymentArchive = new HashMap<BundleDescriptor, BeanDeploymentArchive>();
    private static final Class<?>[] NON_CONTEXT_CLASSES = new Class[]{Servlet.class, ServletContextListener.class, Filter.class, HttpSessionListener.class, ServletRequestListener.class, JspTag.class};

    public MetaData getMetaData() {
        return new MetaData(true, null, new Class[]{Application.class});
    }

    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(EventListener.Event event) {
        if (event.is(org.glassfish.internal.deployment.Deployment.APPLICATION_LOADED)) {
            ApplicationInfo appInfo = (ApplicationInfo)event.hook();
            WeldBootstrap bootstrap = (WeldBootstrap)appInfo.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
            if (bootstrap != null) {
                DeploymentImpl deploymentImpl = (DeploymentImpl)appInfo.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class);
                deploymentImpl.buildDeploymentGraph();
                Collection archives = deploymentImpl.getBeanDeploymentArchives();
                for (BeanDeploymentArchive archive : archives) {
                    ResourceLoaderImpl loader = new ResourceLoaderImpl(((BeanDeploymentArchiveImpl)archive).getModuleClassLoaderForBDA());
                    archive.getServices().add(ResourceLoader.class, (org.jboss.weld.bootstrap.api.Service)loader);
                }
                this.addCdiServicesToNonModuleBdas(deploymentImpl.getLibJarRootBdas(), (InjectionManager)this.services.getService(InjectionManager.class, new Annotation[0]));
                this.addCdiServicesToNonModuleBdas(deploymentImpl.getRarRootBdas(), (InjectionManager)this.services.getService(InjectionManager.class, new Annotation[0]));
                ClassLoader oldTCL = Thread.currentThread().getContextClassLoader();
                final String fAppName = appInfo.getName();
                this.invocationManager.pushAppEnvironment(new ApplicationEnvironment(){

                    public String getName() {
                        return fAppName;
                    }
                });
                try {
                    bootstrap.startExtensions(deploymentImpl.getExtensions());
                    bootstrap.startContainer(fAppName, (Environment)Environments.SERVLET, (Deployment)deploymentImpl);
                    bootstrap.startInitialization();
                    this.fireProcessInjectionTargetEvents(bootstrap, deploymentImpl);
                    bootstrap.deployBeans();
                    bootstrap.validateBeans();
                    bootstrap.endInitialization();
                }
                catch (Throwable t) {
                    this.doBootstrapShutdown(appInfo);
                    String msgPrefix = this.getDeploymentErrorMsgPrefix(t);
                    DeploymentException de = new DeploymentException(msgPrefix + t.getMessage());
                    de.initCause(t);
                    throw de;
                }
                finally {
                    this.invocationManager.popAppEnvironment();
                    Thread.currentThread().setContextClassLoader(oldTCL);
                    this.deploymentComplete(deploymentImpl);
                }
            }
        } else if (event.is(org.glassfish.internal.deployment.Deployment.APPLICATION_STOPPED) || event.is(org.glassfish.internal.deployment.Deployment.APPLICATION_UNLOADED) || event.is(org.glassfish.internal.deployment.Deployment.APPLICATION_DISABLED)) {
            DeploymentImpl deploymentImpl;
            ApplicationInfo appInfo;
            block22: {
                String shutdown;
                appInfo = (ApplicationInfo)event.hook();
                Application app = (Application)appInfo.getMetaData(Application.class);
                if (app != null) {
                    for (BundleDescriptor next : app.getBundleDescriptors()) {
                        if (!(next instanceof EjbBundleDescriptor) && !(next instanceof WebBundleDescriptor)) continue;
                        this.bundleToBeanDeploymentArchive.remove(next);
                    }
                    this.appToBootstrap.remove(app);
                }
                if (Boolean.valueOf(shutdown = (String)appInfo.getTransientAppMetaData(WELD_SHUTDOWN, String.class)).equals(Boolean.TRUE)) {
                    return;
                }
                ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(appInfo.getAppClassLoader());
                try {
                    WeldBootstrap bootstrap = (WeldBootstrap)appInfo.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
                    if (bootstrap == null) break block22;
                    final String fAppName = appInfo.getName();
                    this.invocationManager.pushAppEnvironment(new ApplicationEnvironment(){

                        public String getName() {
                            return fAppName;
                        }
                    });
                    try {
                        this.doBootstrapShutdown(appInfo);
                    }
                    catch (Exception e) {
                        this.logger.log(Level.WARNING, "AS-CDI-00036", new Object[]{e});
                    }
                    finally {
                        this.invocationManager.popAppEnvironment();
                    }
                    appInfo.addTransientAppMetaData(WELD_SHUTDOWN, (Object)"true");
                }
                finally {
                    Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                }
            }
            if ((deploymentImpl = (DeploymentImpl)appInfo.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class)) != null) {
                deploymentImpl.cleanup();
            }
        }
    }

    private void deploymentComplete(DeploymentImpl deploymentImpl) {
        for (BeanDeploymentArchive oneBda : deploymentImpl.getBeanDeploymentArchives()) {
            ((BeanDeploymentArchiveImpl)oneBda).setDeploymentComplete(true);
        }
    }

    private void doBootstrapShutdown(ApplicationInfo appInfo) {
        WeldBootstrap bootstrap = (WeldBootstrap)appInfo.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
        String bootstrapShutdown = (String)appInfo.getTransientAppMetaData(WELD_BOOTSTRAP_SHUTDOWN, String.class);
        if (bootstrapShutdown == null || Boolean.valueOf(bootstrapShutdown).equals(Boolean.FALSE)) {
            bootstrap.shutdown();
            appInfo.addTransientAppMetaData(WELD_BOOTSTRAP_SHUTDOWN, (Object)"true");
        }
    }

    private String getDeploymentErrorMsgPrefix(Throwable t) {
        if (t instanceof DefinitionException) {
            return "CDI definition failure:";
        }
        if (t instanceof jakarta.enterprise.inject.spi.DeploymentException) {
            return "CDI deployment failure:";
        }
        Throwable cause = t.getCause();
        if (cause == t || cause == null) {
            return "CDI deployment failure:";
        }
        return this.getDeploymentErrorMsgPrefix(cause);
    }

    private void fireProcessInjectionTargetEvents(WeldBootstrap bootstrap, DeploymentImpl impl) {
        Collection bdaList = impl.getBeanDeploymentArchives();
        boolean isFullProfile = false;
        Class<?> messageListenerClass = null;
        try {
            messageListenerClass = Thread.currentThread().getContextClassLoader().loadClass("jakarta.jms.MessageListener");
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "AS-CDI-00037");
            }
            isFullProfile = true;
        }
        catch (ClassNotFoundException cnfe) {
            isFullProfile = false;
        }
        for (BeanDeploymentArchive bda : bdaList) {
            Collection<Class<?>> bdaClasses = ((BeanDeploymentArchiveImpl)bda).getBeanClassObjects();
            for (Class<?> bdaClazz : bdaClasses) {
                for (Class<?> nonClazz : NON_CONTEXT_CLASSES) {
                    if (!nonClazz.isAssignableFrom(bdaClazz)) continue;
                    this.firePITEvent(bootstrap, bda, bdaClazz);
                }
                if (!isFullProfile || !messageListenerClass.isAssignableFrom(bdaClazz)) continue;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "AS-CDI-00038", new Object[]{bdaClazz});
                }
                this.firePITEvent(bootstrap, bda, bdaClazz);
            }
        }
    }

    private void firePITEvent(WeldBootstrap bootstrap, BeanDeploymentArchive bda, Class<?> bdaClazz) {
        if (bdaClazz.isInterface()) {
            return;
        }
        AnnotatedType at = bootstrap.getManager(bda).createAnnotatedType(bdaClazz);
        InjectionTarget it = bootstrap.getManager(bda).fireProcessInjectionTarget(at);
        ((BeanDeploymentArchiveImpl)bda).putInjectionTarget(at, it);
    }

    public BeanDeploymentArchive getBeanDeploymentArchiveForBundle(BundleDescriptor bundle) {
        return this.bundleToBeanDeploymentArchive.get(bundle);
    }

    public boolean is299Enabled(BundleDescriptor bundle) {
        return this.bundleToBeanDeploymentArchive.containsKey(bundle);
    }

    public WeldBootstrap getBootstrapForApp(Application app) {
        return this.appToBootstrap.get(app);
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    public WeldApplicationContainer load(WeldContainer container, DeploymentContext context) {
        BeanDeploymentArchive bda;
        DeploymentImpl deploymentImpl;
        DeployCommandParameters deployParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        ApplicationInfo appInfo = this.applicationRegistry.get(deployParams.name);
        ReadableArchive archive = context.getSource();
        WeldBootstrap bootstrap = (WeldBootstrap)context.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
        if (bootstrap == null) {
            bootstrap = new WeldBootstrap();
            Application app = (Application)context.getModuleMetaData(Application.class);
            this.appToBootstrap.put(app, bootstrap);
            context.addTransientAppMetaData(WELD_BOOTSTRAP, (Object)bootstrap);
            appInfo.addTransientAppMetaData(WELD_BOOTSTRAP, (Object)bootstrap);
            appInfo.addTransientAppMetaData(WELD_BOOTSTRAP_SHUTDOWN, (Object)"false");
        }
        EjbBundleDescriptor ejbBundle = this.getEjbBundleFromContext(context);
        EjbServicesImpl ejbServices = null;
        HashSet<EjbDescriptor> ejbs = new HashSet<EjbDescriptor>();
        if (ejbBundle != null) {
            ejbs.addAll(ejbBundle.getEjbs());
            ejbServices = new EjbServicesImpl(this.services);
        }
        if ((deploymentImpl = (DeploymentImpl)context.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class)) == null) {
            deploymentImpl = new DeploymentImpl(archive, ejbs, context, this.archiveFactory);
            TransactionServicesImpl transactionServices = new TransactionServicesImpl(this.services);
            deploymentImpl.getServices().add(TransactionServices.class, (org.jboss.weld.bootstrap.api.Service)transactionServices);
            SecurityServicesImpl securityServices = new SecurityServicesImpl();
            deploymentImpl.getServices().add(SecurityServices.class, (org.jboss.weld.bootstrap.api.Service)securityServices);
            ProxyServicesImpl proxyServices = new ProxyServicesImpl(this.services);
            deploymentImpl.getServices().add(ProxyServices.class, (org.jboss.weld.bootstrap.api.Service)proxyServices);
            this.addWeldListenerToAllWars(context);
        } else {
            deploymentImpl.scanArchive(archive, ejbs, context);
        }
        deploymentImpl.addDeployedEjbs(ejbs);
        if (ejbBundle != null && !deploymentImpl.getServices().contains(EjbServices.class)) {
            deploymentImpl.getServices().add(EjbServices.class, (org.jboss.weld.bootstrap.api.Service)ejbServices);
        }
        if ((bda = deploymentImpl.getBeanDeploymentArchiveForArchive(archive.getName())) != null && !bda.getBeansXml().getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE)) {
            WebBundleDescriptor bundle;
            WebBundleDescriptor wDesc = (WebBundleDescriptor)context.getModuleMetaData(WebBundleDescriptor.class);
            if (wDesc != null) {
                wDesc.setExtensionProperty(WELD_EXTENSION, "true");
                wDesc.addAppListenerDescriptorToFirst((AppListenerDescriptor)new AppListenerDescriptorImpl(WELD_LISTENER));
                wDesc.addAppListenerDescriptor((AppListenerDescriptor)new AppListenerDescriptorImpl(WELD_CONTEXT_LISTENER));
                wDesc.addAppListenerDescriptor((AppListenerDescriptor)new AppListenerDescriptorImpl(WELD_TERMINATION_LISTENER));
                for (ServletFilterMapping sfMapping : wDesc.getServletFilterMappings()) {
                    String displayName = ((ServletFilterMappingDescriptor)sfMapping).getDisplayName();
                    if (!WELD_CONVERSATION_FILTER_NAME.equals(displayName)) continue;
                    ServletFilterDescriptor ref = new ServletFilterDescriptor();
                    ref.setClassName(WELD_CONVERSATION_FILTER_CLASS);
                    ref.setName(WELD_CONVERSATION_FILTER_NAME);
                    wDesc.addServletFilter((ServletFilter)ref);
                    break;
                }
            }
            Object object = bundle = wDesc != null ? wDesc : ejbBundle;
            if (bundle != null) {
                if (!bda.getBeansXml().getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE)) {
                    InjectionManager injectionMgr = (InjectionManager)this.services.getService(InjectionManager.class, new Annotation[0]);
                    InjectionServicesImpl injectionServices = new InjectionServicesImpl(injectionMgr, (BundleDescriptor)bundle, deploymentImpl);
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "AS-CDI-00039", new Object[]{injectionServices, bda.getId()});
                    }
                    bda.getServices().add(InjectionServices.class, (org.jboss.weld.bootstrap.api.Service)injectionServices);
                    EEModuleDescriptor eeModuleDescriptor = this.getEEModuleDescriptor(bda);
                    if (eeModuleDescriptor != null) {
                        bda.getServices().add(EEModuleDescriptor.class, (org.jboss.weld.bootstrap.api.Service)eeModuleDescriptor);
                    }
                    for (BeanDeploymentArchive subBda : bda.getBeanDeploymentArchives()) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.log(Level.FINE, "AS-CDI-00039", new Object[]{injectionServices, subBda.getId()});
                        }
                        subBda.getServices().add(InjectionServices.class, (org.jboss.weld.bootstrap.api.Service)injectionServices);
                        eeModuleDescriptor = this.getEEModuleDescriptor(bda);
                        if (eeModuleDescriptor == null) continue;
                        bda.getServices().add(EEModuleDescriptor.class, (org.jboss.weld.bootstrap.api.Service)eeModuleDescriptor);
                    }
                }
                this.bundleToBeanDeploymentArchive.put((BundleDescriptor)bundle, bda);
            }
        }
        WeldApplicationContainer wbApp = new WeldApplicationContainer();
        context.addTransientAppMetaData(WELD_DEPLOYMENT, (Object)deploymentImpl);
        appInfo.addTransientAppMetaData(WELD_DEPLOYMENT, (Object)deploymentImpl);
        return wbApp;
    }

    private EEModuleDescriptor getEEModuleDescriptor(BeanDeploymentArchive beanDeploymentArchive) {
        EEModuleDescriptorImpl eeModuleDescriptor = null;
        if (beanDeploymentArchive instanceof BeanDeploymentArchiveImpl) {
            WeldUtils.BDAType bdaType = ((BeanDeploymentArchiveImpl)beanDeploymentArchive).getBDAType();
            if (bdaType.equals((Object)WeldUtils.BDAType.JAR)) {
                eeModuleDescriptor = new EEModuleDescriptorImpl(beanDeploymentArchive.getId(), EEModuleDescriptor.ModuleType.EJB_JAR);
            } else if (bdaType.equals((Object)WeldUtils.BDAType.WAR)) {
                eeModuleDescriptor = new EEModuleDescriptorImpl(beanDeploymentArchive.getId(), EEModuleDescriptor.ModuleType.WEB);
            } else if (bdaType.equals((Object)WeldUtils.BDAType.RAR)) {
                eeModuleDescriptor = new EEModuleDescriptorImpl(beanDeploymentArchive.getId(), EEModuleDescriptor.ModuleType.CONNECTOR);
            }
        }
        return eeModuleDescriptor;
    }

    private void addWeldListenerToAllWars(DeploymentContext context) {
        ApplicationHolder applicationHolder = (ApplicationHolder)context.getModuleMetaData(ApplicationHolder.class);
        if (applicationHolder != null && applicationHolder.app.getBundleDescriptors(EjbBundleDescriptor.class).size() > 0) {
            Set webBundleDescriptors = applicationHolder.app.getBundleDescriptors(WebBundleDescriptor.class);
            for (WebBundleDescriptor oneWebBundleDescriptor : webBundleDescriptors) {
                oneWebBundleDescriptor.addAppListenerDescriptorToFirst((AppListenerDescriptor)new AppListenerDescriptorImpl(WELD_LISTENER));
                oneWebBundleDescriptor.addAppListenerDescriptor((AppListenerDescriptor)new AppListenerDescriptorImpl(WELD_TERMINATION_LISTENER));
            }
        }
    }

    private EjbBundleDescriptor getEjbBundleFromContext(DeploymentContext context) {
        Collection ejbBundles;
        WebBundleDescriptor wDesc;
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)context.getModuleMetaData(EjbBundleDescriptor.class);
        if (ejbBundle == null && (wDesc = (WebBundleDescriptor)context.getModuleMetaData(WebBundleDescriptor.class)) != null && (ejbBundles = wDesc.getExtensionsDescriptors(EjbBundleDescriptor.class)).iterator().hasNext()) {
            ejbBundle = (EjbBundleDescriptor)ejbBundles.iterator().next();
        }
        return ejbBundle;
    }

    private void addCdiServicesToNonModuleBdas(Iterator<RootBeanDeploymentArchive> rootBdas, InjectionManager injectionMgr) {
        if (injectionMgr != null && rootBdas != null) {
            while (rootBdas.hasNext()) {
                RootBeanDeploymentArchive oneRootBda = rootBdas.next();
                this.addCdiServicesToBda(injectionMgr, oneRootBda);
                this.addCdiServicesToBda(injectionMgr, oneRootBda.getModuleBda());
            }
        }
    }

    private void addCdiServicesToBda(InjectionManager injectionMgr, BeanDeploymentArchive bda) {
        NonModuleInjectionServices injectionServices = new NonModuleInjectionServices(injectionMgr);
        bda.getServices().add(InjectionServices.class, (org.jboss.weld.bootstrap.api.Service)injectionServices);
    }

    static {
        try {
            Util.initializeWeldSingletonProvider();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

