/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Writer;
import java.nio.channels.InterruptedByTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Session;
import org.apache.catalina.connector.AsyncContextImpl;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.RequestUtil;
import org.glassfish.common.util.InputValidationUtil;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.http.io.OutputBuffer;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.Constants;

public class OutputBuffer
extends Writer
implements ByteChunk.ByteOutputChannel {
    private static final Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    private static final String SET_COOKIE_HEADER = "Set-Cookie";
    public static final String DEFAULT_ENCODING = Constants.DEFAULT_HTTP_CHARACTER_ENCODING;
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    static final int debug = 0;
    private int bytesWritten = 0;
    private int charsWritten = 0;
    private Response response;
    private org.glassfish.grizzly.http.server.Response grizzlyResponse;
    private org.glassfish.grizzly.http.io.OutputBuffer grizzlyOutputBuffer;
    private WriteHandler writeHandler = null;
    private boolean prevIsReady = true;
    private static final ThreadLocal<Boolean> CAN_WRITE_SCOPE = new ThreadLocal();
    private boolean suspended = false;
    private int size;
    private OutputBuffer.LifeCycleListener sessionCookieChecker = new SessionCookieChecker();

    public OutputBuffer() {
        this(8192);
    }

    public OutputBuffer(int size) {
        this.size = size;
    }

    public void setCoyoteResponse(Response coyoteResponse) {
        this.response = coyoteResponse;
        this.grizzlyResponse = coyoteResponse.getCoyoteResponse();
        this.grizzlyOutputBuffer = this.grizzlyResponse.getOutputBuffer();
        this.grizzlyOutputBuffer.setBufferSize(this.size);
        this.grizzlyOutputBuffer.registerLifeCycleListener(this.sessionCookieChecker);
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public void recycle() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "recycle()");
        }
        this.bytesWritten = 0;
        this.charsWritten = 0;
        this.suspended = false;
        this.grizzlyResponse = null;
        this.grizzlyOutputBuffer = null;
        this.writeHandler = null;
        this.prevIsReady = true;
        this.response = null;
    }

    @Override
    public void close() throws IOException {
        if (this.suspended) {
            return;
        }
        this.grizzlyOutputBuffer.close();
    }

    @Override
    public void flush() throws IOException {
        this.doFlush(true);
    }

    protected void doFlush(boolean realFlush) throws IOException {
        if (this.suspended) {
            return;
        }
        if (realFlush || !this.grizzlyResponse.isCommitted()) {
            this.grizzlyOutputBuffer.flush();
        }
    }

    public void realWriteBytes(byte[] buf, int off, int cnt) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "realWrite(b, " + off + ", " + cnt + ") " + this.grizzlyResponse);
        }
        if (this.grizzlyResponse == null) {
            return;
        }
        if (this.grizzlyOutputBuffer.isClosed()) {
            return;
        }
        if (cnt > 0) {
            try {
                this.grizzlyOutputBuffer.write(buf, off, cnt);
            }
            catch (IOException e) {
                throw new ClientAbortException(e);
            }
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.writeBytes(b, off, len);
    }

    private void writeBytes(byte[] b, int off, int len) throws IOException {
        if (this.grizzlyOutputBuffer.isClosed()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "write(b,off,len)");
        }
        this.grizzlyOutputBuffer.write(b, off, len);
        this.bytesWritten += len;
    }

    public void writeByte(int b) throws IOException {
        if (this.suspended) {
            return;
        }
        this.grizzlyOutputBuffer.writeByte(b);
        ++this.bytesWritten;
    }

    @Override
    public void write(int c) throws IOException {
        if (this.suspended) {
            return;
        }
        this.grizzlyOutputBuffer.writeChar(c);
        ++this.charsWritten;
    }

    @Override
    public void write(char[] c) throws IOException {
        if (this.suspended) {
            return;
        }
        this.write(c, 0, c.length);
    }

    @Override
    public void write(char[] c, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.grizzlyOutputBuffer.write(c, off, len);
        this.charsWritten += len;
    }

    @Override
    public void write(String s, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.charsWritten += len;
        if (s == null) {
            s = "null";
        }
        this.grizzlyOutputBuffer.write(s, off, len);
    }

    @Override
    public void write(String s) throws IOException {
        if (this.suspended) {
            return;
        }
        if (s == null) {
            s = "null";
        }
        this.grizzlyOutputBuffer.write(s);
    }

    public void checkConverter() throws IOException {
        this.grizzlyOutputBuffer.prepareCharacterEncoder();
    }

    public void flushBytes() throws IOException {
        this.grizzlyOutputBuffer.flush();
    }

    public int getBytesWritten() {
        return this.bytesWritten;
    }

    public int getCharsWritten() {
        return this.charsWritten;
    }

    public int getContentWritten() {
        return this.bytesWritten + this.charsWritten;
    }

    public boolean isNew() {
        return this.bytesWritten == 0 && this.charsWritten == 0;
    }

    public void setBufferSize(int size) {
        if (size > this.grizzlyOutputBuffer.getBufferSize()) {
            this.grizzlyOutputBuffer.setBufferSize(size);
        }
    }

    public void reset() {
        this.grizzlyOutputBuffer.reset();
        this.bytesWritten = 0;
        this.charsWritten = 0;
    }

    public int getBufferSize() {
        return this.grizzlyOutputBuffer.getBufferSize();
    }

    public boolean isReady() {
        if (!this.prevIsReady) {
            return false;
        }
        boolean result = this.grizzlyOutputBuffer.canWrite();
        if (!result) {
            if (this.writeHandler != null) {
                this.prevIsReady = false;
                CAN_WRITE_SCOPE.set(Boolean.TRUE);
                try {
                    this.grizzlyOutputBuffer.notifyCanWrite(this.writeHandler);
                }
                finally {
                    CAN_WRITE_SCOPE.remove();
                }
            } else {
                this.prevIsReady = true;
            }
        }
        return result;
    }

    public void setWriteListener(WriteListener writeListener) {
        if (this.writeHandler != null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00049"));
        }
        Request req = (Request)this.response.getRequest();
        if (!req.isAsyncStarted() && !req.isUpgrade()) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00050"));
        }
        this.writeHandler = new WriteHandlerImpl(writeListener);
        if (this.isReady()) {
            try {
                this.writeHandler.onWritePossible();
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "AS-WEB-CORE-00051", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disableWriteHandler() {
        if (this.writeHandler != null) {
            WriteHandler writeHandler = this.writeHandler;
            synchronized (writeHandler) {
                this.writeHandler.onError((Throwable)new InterruptedByTimeoutException());
            }
        }
    }

    private void addSessionCookies() throws IOException {
        Request req = (Request)this.response.getRequest();
        if (req.isRequestedSessionIdFromURL()) {
            return;
        }
        StandardContext ctx = (StandardContext)this.response.getContext();
        if (ctx == null || !ctx.getCookies()) {
            return;
        }
        Session sess = req.getSessionInternal(false);
        if (sess != null) {
            this.addSessionVersionCookie(req, ctx);
            this.addSessionCookieWithJvmRoute(req, ctx, sess);
            this.addSessionCookieWithJReplica(req, ctx, sess);
            this.addPersistedSessionCookie(req, ctx, sess);
            this.addJrouteCookie(req, ctx, sess);
            this.addSsoVersionCookie(req, ctx);
        }
    }

    private void addSessionVersionCookie(Request request, StandardContext context) {
        Map<String, String> sessionVersions = request.getSessionVersionsRequestAttribute();
        if (sessionVersions != null) {
            Cookie cookie = new Cookie("JSESSIONIDVERSION", RequestUtil.createSessionVersionString(sessionVersions));
            request.configureSessionCookie(cookie);
            if (request.isRequestedSessionIdFromCookie()) {
                cookie.setSecure(request.isRequestedSessionIdFromSecureCookie());
            }
            this.grizzlyResponse.addHeader(SET_COOKIE_HEADER, this.response.getCookieString(cookie));
        }
    }

    private void addSessionCookieWithJvmRoute(Request request, StandardContext ctx, Session sess) {
        if (ctx.getJvmRoute() == null || sess == null) {
            return;
        }
        Cookie cookie = this.getSafeCookie(ctx.getSessionCookieName(), sess.getIdInternal() + "." + ctx.getJvmRoute());
        request.configureSessionCookie(cookie);
        this.grizzlyResponse.addHeader(SET_COOKIE_HEADER, this.response.getCookieString(cookie));
    }

    private Cookie getSafeCookie(String name, String value) {
        Cookie cookie = null;
        try {
            String safeName = InputValidationUtil.getSafeHeaderName((String)name);
            String safeValue = InputValidationUtil.getSafeCookieHeaderValue((String)value);
            cookie = new Cookie(safeName, safeValue);
        }
        catch (Exception e) {
            try {
                this.grizzlyResponse.sendError(403, "Forbidden");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cookie;
    }

    private void addSessionCookieWithJReplica(Request request, StandardContext ctx, Session sess) {
        String replicaLocation = null;
        if (sess != null) {
            replicaLocation = (String)sess.getNote("com.sun.enterprise.http.jreplicaLocation");
            sess.removeNote("com.sun.enterprise.http.jreplicaLocation");
        }
        if (replicaLocation != null) {
            Cookie cookie = this.getSafeCookie("JREPLICA", replicaLocation);
            request.configureSessionCookie(cookie);
            if (request.isRequestedSessionIdFromCookie()) {
                cookie.setSecure(request.isRequestedSessionIdFromSecureCookie());
            }
            this.grizzlyResponse.addHeader(SET_COOKIE_HEADER, this.response.getCookieString(cookie));
        }
    }

    private void addSsoVersionCookie(Request request, StandardContext ctx) {
        Long ssoVersion = (Long)request.getNote("org.apache.catalina.request.SSOVersion");
        if (ssoVersion != null) {
            Cookie cookie = new Cookie("JSESSIONIDSSOVERSION", ssoVersion.toString());
            cookie.setMaxAge(-1);
            cookie.setPath("/");
            StandardHost host = (StandardHost)ctx.getParent();
            HttpServletRequest hreq = request.getRequest();
            if (host != null) {
                host.configureSingleSignOnCookieSecure(cookie, hreq);
                host.configureSingleSignOnCookieHttpOnly(cookie);
            } else {
                cookie.setSecure(hreq.isSecure());
            }
            this.grizzlyResponse.addHeader(SET_COOKIE_HEADER, this.response.getCookieString(cookie));
        }
    }

    private void addPersistedSessionCookie(Request request, StandardContext ctx, Session sess) throws IOException {
        if (sess == null) {
            return;
        }
        Cookie cookie = ctx.getManager().toCookie(sess);
        if (cookie != null) {
            request.configureSessionCookie(cookie);
            this.grizzlyResponse.addHeader(SET_COOKIE_HEADER, this.response.getCookieString(cookie));
        }
    }

    private void addJrouteCookie(Request request, StandardContext ctx, Session sess) {
        String jrouteId = request.getHeader("proxy-jroute");
        if (jrouteId == null) {
            return;
        }
        if (sess == null) {
            return;
        }
        if (request.getJrouteId() == null || !request.getJrouteId().equals(jrouteId)) {
            Cookie cookie = this.getSafeCookie("JROUTE", jrouteId);
            request.configureSessionCookie(cookie);
            if (request.isRequestedSessionIdFromCookie()) {
                cookie.setSecure(request.isRequestedSessionIdFromSecureCookie());
            }
            this.grizzlyResponse.addHeader(SET_COOKIE_HEADER, this.response.getCookieString(cookie));
        }
    }

    public boolean hasData() {
        return !this.suspended && (!this.grizzlyResponse.isCommitted() || this.grizzlyOutputBuffer.getBufferedDataSize() > 0);
    }

    private static class PrivilegedGetTccl
    implements PrivilegedAction<ClassLoader> {
        private PrivilegedGetTccl() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private static class PrivilegedSetTccl
    implements PrivilegedAction<Void> {
        private ClassLoader cl;

        PrivilegedSetTccl(ClassLoader cl) {
            this.cl = cl;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.cl);
            return null;
        }
    }

    class WriteHandlerImpl
    implements WriteHandler {
        private WriteListener writeListener = null;
        private volatile boolean disable = false;

        private WriteHandlerImpl(WriteListener listener) {
            this.writeListener = listener;
        }

        public void onWritePossible() {
            if (this.disable) {
                return;
            }
            if (!Boolean.TRUE.equals(CAN_WRITE_SCOPE.get())) {
                this.processWritePossible();
            } else {
                AsyncContextImpl.getExecutorService().execute(new Runnable(){

                    @Override
                    public void run() {
                        WriteHandlerImpl.this.processWritePossible();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processWritePossible() {
            ClassLoader oldCL;
            PrivilegedAction<ClassLoader> pa;
            if (Globals.IS_SECURITY_ENABLED) {
                pa = new PrivilegedGetTccl();
                oldCL = AccessController.doPrivileged(pa);
            } else {
                oldCL = Thread.currentThread().getContextClassLoader();
            }
            try {
                Context context = OutputBuffer.this.response.getContext();
                ClassLoader newCL = context.getLoader().getClassLoader();
                if (Globals.IS_SECURITY_ENABLED) {
                    PrivilegedSetTccl pa2 = new PrivilegedSetTccl(newCL);
                    AccessController.doPrivileged(pa2);
                } else {
                    Thread.currentThread().setContextClassLoader(newCL);
                }
                WriteHandlerImpl writeHandlerImpl = this;
                synchronized (writeHandlerImpl) {
                    OutputBuffer.this.prevIsReady = true;
                    try {
                        context.fireContainerEvent("beforeWriteListenerOnWritePossible", this.writeListener);
                        this.writeListener.onWritePossible();
                    }
                    catch (Throwable t) {
                        this.disable = true;
                        this.writeListener.onError(t);
                    }
                    finally {
                        context.fireContainerEvent("afterWriteListenerOnWritePossible", this.writeListener);
                    }
                }
            }
            finally {
                if (Globals.IS_SECURITY_ENABLED) {
                    pa = new PrivilegedSetTccl(oldCL);
                    AccessController.doPrivileged(pa);
                } else {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
            }
        }

        public void onError(final Throwable t) {
            if (this.disable) {
                return;
            }
            this.disable = true;
            if (!Boolean.TRUE.equals(CAN_WRITE_SCOPE.get())) {
                this.processError(t);
            } else {
                AsyncContextImpl.getExecutorService().execute(new Runnable(){

                    @Override
                    public void run() {
                        WriteHandlerImpl.this.processError(t);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processError(Throwable t) {
            ClassLoader oldCL;
            PrivilegedAction<ClassLoader> pa;
            if (Globals.IS_SECURITY_ENABLED) {
                pa = new PrivilegedGetTccl();
                oldCL = AccessController.doPrivileged(pa);
            } else {
                oldCL = Thread.currentThread().getContextClassLoader();
            }
            try {
                Context context = OutputBuffer.this.response.getContext();
                ClassLoader newCL = context.getLoader().getClassLoader();
                if (Globals.IS_SECURITY_ENABLED) {
                    PrivilegedSetTccl pa2 = new PrivilegedSetTccl(newCL);
                    AccessController.doPrivileged(pa2);
                } else {
                    Thread.currentThread().setContextClassLoader(newCL);
                }
                WriteHandlerImpl writeHandlerImpl = this;
                synchronized (writeHandlerImpl) {
                    try {
                        context.fireContainerEvent("beforeWriteListenerOnError", this.writeListener);
                        this.writeListener.onError(t);
                    }
                    finally {
                        context.fireContainerEvent("afterWriteListenerOnError", this.writeListener);
                    }
                }
            }
            finally {
                if (Globals.IS_SECURITY_ENABLED) {
                    pa = new PrivilegedSetTccl(oldCL);
                    AccessController.doPrivileged(pa);
                } else {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
            }
        }
    }

    private class SessionCookieChecker
    implements OutputBuffer.LifeCycleListener {
        private SessionCookieChecker() {
        }

        public void onCommit() throws IOException {
            OutputBuffer.this.grizzlyOutputBuffer.removeLifeCycleListener((OutputBuffer.LifeCycleListener)this);
            OutputBuffer.this.addSessionCookies();
        }
    }
}

