/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import jakarta.el.ELContext;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.JspContext;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.el.ExpressionEvaluator;
import jakarta.servlet.jsp.el.VariableResolver;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.ELContextImpl;
import org.apache.jasper.runtime.PageContextImpl;
import org.apache.jasper.runtime.VariableMapperImpl;

public class JspContextWrapper
extends PageContext {
    private PageContext invokingJspCtxt;
    private Hashtable<String, Object> pageAttributes;
    private ArrayList<String> nestedVars;
    private ArrayList<String> atBeginVars;
    private ArrayList<String> atEndVars;
    private Map<String, String> aliases;
    private HashMap<String, Object> originalNestedVars;
    private ELContext elContext;

    public JspContextWrapper(JspContext jspContext, ArrayList<String> nestedVars, ArrayList<String> atBeginVars, ArrayList<String> atEndVars, Map<String, String> aliases) {
        this.invokingJspCtxt = (PageContext)jspContext;
        this.nestedVars = nestedVars;
        this.atBeginVars = atBeginVars;
        this.atEndVars = atEndVars;
        this.pageAttributes = new Hashtable(16);
        this.aliases = aliases;
        if (nestedVars != null) {
            this.originalNestedVars = new HashMap(nestedVars.size());
        }
        this.syncBeginTagFile();
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        return this.pageAttributes.get(name);
    }

    public Object getAttribute(String name, int scope) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (scope == 1) {
            return this.pageAttributes.get(name);
        }
        return this.invokingJspCtxt.getAttribute(name, scope);
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (value != null) {
            this.pageAttributes.put(name, value);
        } else {
            this.removeAttribute(name, 1);
        }
    }

    public void setAttribute(String name, Object value, int scope) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (scope == 1) {
            if (value != null) {
                this.pageAttributes.put(name, value);
            } else {
                this.removeAttribute(name, 1);
            }
        } else {
            this.invokingJspCtxt.setAttribute(name, value, scope);
        }
    }

    public Object findAttribute(String name) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        Object o = this.pageAttributes.get(name);
        if (o == null && (o = this.invokingJspCtxt.getAttribute(name, 2)) == null) {
            if (this.getSession() != null) {
                o = this.invokingJspCtxt.getAttribute(name, 3);
            }
            if (o == null) {
                o = this.invokingJspCtxt.getAttribute(name, 4);
            }
        }
        return o;
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        this.pageAttributes.remove(name);
        this.invokingJspCtxt.removeAttribute(name, 2);
        if (this.getSession() != null) {
            this.invokingJspCtxt.removeAttribute(name, 3);
        }
        this.invokingJspCtxt.removeAttribute(name, 4);
    }

    public void removeAttribute(String name, int scope) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (scope == 1) {
            this.pageAttributes.remove(name);
        } else {
            this.invokingJspCtxt.removeAttribute(name, scope);
        }
    }

    public int getAttributesScope(String name) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (this.pageAttributes.get(name) != null) {
            return 1;
        }
        return this.invokingJspCtxt.getAttributesScope(name);
    }

    public Enumeration<String> getAttributeNamesInScope(int scope) {
        if (scope == 1) {
            return this.pageAttributes.keys();
        }
        return this.invokingJspCtxt.getAttributeNamesInScope(scope);
    }

    public void release() {
        this.invokingJspCtxt.release();
    }

    public JspWriter getOut() {
        return this.invokingJspCtxt.getOut();
    }

    public HttpSession getSession() {
        return this.invokingJspCtxt.getSession();
    }

    public Object getPage() {
        return this.invokingJspCtxt.getPage();
    }

    public ServletRequest getRequest() {
        return this.invokingJspCtxt.getRequest();
    }

    public ServletResponse getResponse() {
        return this.invokingJspCtxt.getResponse();
    }

    public Exception getException() {
        return this.invokingJspCtxt.getException();
    }

    public ServletConfig getServletConfig() {
        return this.invokingJspCtxt.getServletConfig();
    }

    public ServletContext getServletContext() {
        return this.invokingJspCtxt.getServletContext();
    }

    public static PageContext getRootPageContext(PageContext pc) {
        while (pc instanceof JspContextWrapper) {
            pc = ((JspContextWrapper)pc).invokingJspCtxt;
        }
        return pc;
    }

    public ELContext getELContext() {
        if (this.elContext == null) {
            PageContext pc = this.invokingJspCtxt;
            while (pc instanceof JspContextWrapper) {
                pc = ((JspContextWrapper)pc).invokingJspCtxt;
            }
            PageContextImpl pci = (PageContextImpl)pc;
            this.elContext = pci.getJspApplicationContext().createELContext(this.invokingJspCtxt.getELContext().getELResolver());
            this.elContext.putContext(JspContext.class, (Object)this);
            ((ELContextImpl)this.elContext).setVariableMapper(new VariableMapperImpl());
        }
        return this.elContext;
    }

    public void forward(String relativeUrlPath) throws ServletException, IOException {
        this.invokingJspCtxt.forward(relativeUrlPath);
    }

    public void include(String relativeUrlPath) throws ServletException, IOException {
        this.invokingJspCtxt.include(relativeUrlPath);
    }

    public void include(String relativeUrlPath, boolean flush) throws ServletException, IOException {
        this.invokingJspCtxt.include(relativeUrlPath, flush);
    }

    public VariableResolver getVariableResolver() {
        return null;
    }

    public BodyContent pushBody() {
        return this.invokingJspCtxt.pushBody();
    }

    public JspWriter pushBody(Writer writer) {
        return this.invokingJspCtxt.pushBody(writer);
    }

    public JspWriter popBody() {
        return this.invokingJspCtxt.popBody();
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return this.invokingJspCtxt.getExpressionEvaluator();
    }

    public void handlePageException(Exception ex) throws IOException, ServletException {
        this.handlePageException((Throwable)ex);
    }

    public void handlePageException(Throwable t) throws IOException, ServletException {
        this.invokingJspCtxt.handlePageException(t);
    }

    public void syncBeginTagFile() {
        this.saveNestedVariables();
    }

    public void syncBeforeInvoke() {
        this.copyTagToPageScope(0);
        this.copyTagToPageScope(1);
    }

    public void syncEndTagFile() {
        this.copyTagToPageScope(1);
        this.copyTagToPageScope(2);
        this.restoreNestedVariables();
    }

    private void copyTagToPageScope(int scope) {
        Iterator<String> iter = null;
        switch (scope) {
            case 0: {
                if (this.nestedVars == null) break;
                iter = this.nestedVars.iterator();
                break;
            }
            case 1: {
                if (this.atBeginVars == null) break;
                iter = this.atBeginVars.iterator();
                break;
            }
            case 2: {
                if (this.atEndVars == null) break;
                iter = this.atEndVars.iterator();
            }
        }
        while (iter != null && iter.hasNext()) {
            String varName = iter.next();
            Object obj = this.getAttribute(varName);
            varName = this.findAlias(varName);
            if (obj != null) {
                this.invokingJspCtxt.setAttribute(varName, obj);
                continue;
            }
            this.invokingJspCtxt.removeAttribute(varName, 1);
        }
    }

    private void saveNestedVariables() {
        if (this.nestedVars != null) {
            for (String varName : this.nestedVars) {
                Object obj = this.invokingJspCtxt.getAttribute(varName = this.findAlias(varName));
                if (obj == null) continue;
                this.originalNestedVars.put(varName, obj);
            }
        }
    }

    private void restoreNestedVariables() {
        if (this.nestedVars != null) {
            for (String varName : this.nestedVars) {
                Object obj = this.originalNestedVars.get(varName = this.findAlias(varName));
                if (obj != null) {
                    this.invokingJspCtxt.setAttribute(varName, obj);
                    continue;
                }
                this.invokingJspCtxt.removeAttribute(varName, 1);
            }
        }
    }

    private String findAlias(String varName) {
        if (this.aliases == null) {
            return varName;
        }
        String alias = this.aliases.get(varName);
        if (alias == null) {
            return varName;
        }
        return alias;
    }
}

