/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.util;

import com.sun.enterprise.naming.spi.NamingObjectFactory;
import com.sun.enterprise.naming.spi.NamingUtils;
import com.sun.enterprise.naming.util.CloningNamingObjectFactory;
import com.sun.enterprise.naming.util.DelegatingNamingObjectFactory;
import com.sun.enterprise.naming.util.JndiInitializationNamingObjectFactory;
import com.sun.enterprise.naming.util.JndiNamingObjectFactory;
import com.sun.enterprise.naming.util.LogFacade;
import com.sun.enterprise.naming.util.SimpleNamingObjectFactory;
import jakarta.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import javax.naming.Context;
import org.glassfish.common.util.ObjectInputOutputStreamFactoryFactory;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class NamingUtilsImpl
implements NamingUtils {
    @LogMessageInfo(message="Exception in NamingManagerImpl copyMutableObject(): {0}", cause="Problem with serialising or deserialising of the object", action="Check the class hierarchy to see if all the classes are Serializable.")
    public static final String EXCEPTION_COPY_MUTABLE = "AS-NAMING-00006";

    @Override
    public NamingObjectFactory createSimpleNamingObjectFactory(String name, Object value) {
        return new SimpleNamingObjectFactory(name, value);
    }

    @Override
    public NamingObjectFactory createLazyNamingObjectFactory(String name, String jndiName, boolean cacheResult) {
        return new JndiNamingObjectFactory(name, jndiName, cacheResult);
    }

    @Override
    public NamingObjectFactory createLazyInitializationNamingObjectFactory(String name, String jndiName, boolean cacheResult) {
        return new JndiInitializationNamingObjectFactory(name, jndiName, cacheResult);
    }

    @Override
    public NamingObjectFactory createCloningNamingObjectFactory(String name, Object value) {
        return new CloningNamingObjectFactory(name, value);
    }

    @Override
    public NamingObjectFactory createCloningNamingObjectFactory(String name, NamingObjectFactory delegate) {
        return new CloningNamingObjectFactory(name, delegate);
    }

    @Override
    public NamingObjectFactory createDelegatingNamingObjectFactory(String name, NamingObjectFactory delegate, boolean cacheResult) {
        return new DelegatingNamingObjectFactory(name, delegate, cacheResult);
    }

    @Override
    public Object makeCopyOfObject(Object obj) {
        if (!(obj instanceof Context) && obj instanceof Serializable) {
            if (LogFacade.logger.isLoggable(Level.FINE)) {
                LogFacade.logger.log(Level.FINE, "** makeCopyOfObject:: " + obj);
            }
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = ObjectInputOutputStreamFactoryFactory.getFactory().createObjectOutputStream((OutputStream)bos);
                oos.writeObject(obj);
                oos.flush();
                byte[] data = bos.toByteArray();
                oos.close();
                bos.close();
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                final ObjectInputStream ois = ObjectInputOutputStreamFactoryFactory.getFactory().createObjectInputStream((InputStream)bis);
                obj = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException, ClassNotFoundException {
                        return ois.readObject();
                    }
                });
                return obj;
            }
            catch (Exception ex) {
                LogFacade.logger.log(Level.SEVERE, EXCEPTION_COPY_MUTABLE, ex);
                RuntimeException re = new RuntimeException("Cant copy Serializable object:", ex);
                throw re;
            }
        }
        return obj;
    }
}

