/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.adapter;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.ws.rs.core.Application;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.adapter.JerseyContainer;
import org.glassfish.admin.rest.adapter.RestResourceProvider;
import org.glassfish.admin.rest.provider.ActionReportResultHtmlProvider;
import org.glassfish.admin.rest.provider.ActionReportResultJsonProvider;
import org.glassfish.admin.rest.provider.ActionReportResultXmlProvider;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.admin.restconnector.ProxiedRestAdapter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.common.util.admin.RestSessionManager;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.internal.api.AdminAccessController;
import org.glassfish.internal.api.RemoteAdminAccessException;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jersey.inject.hk2.Hk2ReferencingFactory;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Refs;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.jvnet.hk2.annotations.Optional;

public abstract class RestAdapter
extends HttpHandler
implements ProxiedRestAdapter,
PostConstruct {
    protected static final String COOKIE_REST_TOKEN = "gfresttoken";
    protected static final String COOKIE_GF_REST_UID = "gfrestuid";
    protected static final String HEADER_ACCEPT = "Accept";
    protected static final String HEADER_USER_AGENT = "User-Agent";
    protected static final String HEADER_X_AUTH_TOKEN = "X-Auth-Token";
    protected static final String HEADER_AUTHENTICATE = "WWW-Authenticate";
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RestService.class);
    private RestResourceProvider restResourceProvider;
    @Inject
    protected ServiceLocator habitat;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    private CountDownLatch latch = new CountDownLatch(1);
    @Inject
    protected ServerContext sc;
    @Inject
    protected ServerEnvironment serverEnvironment;
    @Inject
    private RestSessionManager sessionManager;
    @Inject
    @Optional
    protected AdminAccessController adminAuthenticator;
    private volatile JerseyContainer adapter = null;

    protected RestAdapter() {
        this.setAllowEncodedSlash(true);
    }

    @Override
    public void postConstruct() {
        this.latch.countDown();
    }

    protected String getContextRoot() {
        return this.getRestResourceProvider().getContextRoot();
    }

    public HttpHandler getHttpService() {
        return this;
    }

    public void service(Request req, Response res) {
        RestLogging.restLogger.log(Level.FINER, "Received resource request: {0}", req.getRequestURI());
        try {
            res.setCharacterEncoding("UTF-8");
            if (this.latch.await(20L, TimeUnit.SECONDS)) {
                String context;
                if (this.serverEnvironment.isInstance() && !Method.GET.equals(req.getMethod()) && !this.getRestResourceProvider().enableModifAccessToInstances()) {
                    this.reportError(req, res, 403, localStrings.getLocalString("rest.resource.only.GET.on.instance", "Only GET requests are allowed on an instance that is not DAS."));
                    return;
                }
                if (this.adminAuthenticator != null) {
                    Subject subject = this.adminAuthenticator.loginAsAdmin(req);
                    req.setAttribute("SUBJECT", (Object)subject);
                }
                if ((context = this.getContextRoot()) != null && !"".equals(context) && this.adapter == null) {
                    RestLogging.restLogger.log(Level.FINE, "Exposing rest resource context root: {0}", context);
                    this.adapter = this.exposeContext();
                    RestLogging.restLogger.log(Level.INFO, "NCLS-REST-00001", context);
                }
                this.adapter.service(req, res);
            } else {
                this.reportError(req, res, 503, localStrings.getLocalString("rest.adapter.server.wait", "Server cannot process this command at this time, please wait"));
            }
        }
        catch (InterruptedException e) {
            this.reportError(req, res, 503, localStrings.getLocalString("rest.adapter.server.wait", "Server cannot process this command at this time, please wait"));
        }
        catch (IOException e) {
            this.reportError(req, res, 503, localStrings.getLocalString("rest.adapter.server.ioexception", "REST: IO Exception " + e.getLocalizedMessage()));
        }
        catch (RemoteAdminAccessException e) {
            this.reportError(req, res, 403, localStrings.getLocalString("rest.adapter.auth.forbidden", "Remote access not allowed. If you desire remote access, please turn on secure admin"));
        }
        catch (LoginException e) {
            int status = 401;
            String msg = localStrings.getLocalString("rest.adapter.auth.userpassword", "Invalid user name or password");
            res.setHeader(HEADER_AUTHENTICATE, "BASIC");
            this.reportError(req, res, status, msg);
        }
        catch (Exception e) {
            String msg = localStrings.getLocalString("rest.adapter.server.exception", "An error occurred while processing the request. Please see the server logs for details.");
            RestLogging.restLogger.log(Level.INFO, "NCLS-REST-00003", e);
            this.reportError(req, res, 503, msg);
        }
    }

    private String getAcceptedMimeType(Request req) {
        String type = null;
        String requestURI = req.getRequestURI();
        HashSet<String> acceptableTypes = new HashSet<String>(3);
        acceptableTypes.add("html");
        acceptableTypes.add("xml");
        acceptableTypes.add("json");
        if (requestURI.indexOf(46) != -1) {
            type = requestURI.substring(requestURI.indexOf(46) + 1);
        } else {
            String accept;
            String userAgent = req.getHeader(HEADER_USER_AGENT);
            if (userAgent != null && (accept = req.getHeader(HEADER_ACCEPT)) != null) {
                if (accept.indexOf("html") != -1) {
                    return "html";
                }
                StringTokenizer st = new StringTokenizer(accept, ",");
                while (st.hasMoreElements()) {
                    String scheme = st.nextToken();
                    if (!acceptableTypes.contains(scheme = scheme.substring(scheme.indexOf(47) + 1))) continue;
                    type = scheme;
                    break;
                }
            }
        }
        return type;
    }

    protected RestResourceProvider getRestResourceProvider() {
        return this.restResourceProvider;
    }

    protected void setRestResourceProvider(RestResourceProvider rrp) {
        this.restResourceProvider = rrp;
    }

    protected Set<? extends Binder> getAdditionalBinders() {
        return Collections.singleton(new AbstractBinder(){

            @Override
            protected void configure() {
                this.bindFactory(SubjectReferenceFactory.class).to(new TypeLiteral<Ref<Subject>>(){}).in(PerLookup.class);
                this.bindFactory(Hk2ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<Subject>>(){}).in(RequestScoped.class);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JerseyContainer exposeContext() throws EndpointRegistrationException {
        Set<Class<?>> classes = this.getRestResourceProvider().getResourceClasses(this.habitat);
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader apiClassLoader = this.sc.getCommonClassLoader();
            Thread.currentThread().setContextClassLoader(apiClassLoader);
            ResourceConfig rc = this.getRestResourceProvider().getResourceConfig(classes, this.sc, this.habitat, this.getAdditionalBinders());
            JerseyContainer jerseyContainer = this.getJerseyContainer(rc);
            return jerseyContainer;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    protected JerseyContainer getJerseyContainer(ResourceConfig rc) {
        final HttpHandler httpHandler = (HttpHandler)ContainerFactory.createContainer(HttpHandler.class, (Application)rc);
        return new JerseyContainer(){

            @Override
            public void service(Request request, Response response) throws Exception {
                httpHandler.service(request, response);
            }
        };
    }

    private void reportError(Request req, Response res, int statusCode, String msg) {
        try {
            BaseProvider provider;
            RestActionReporter report = new RestActionReporter();
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setActionDescription("Error");
            report.setMessage(msg);
            String type = this.getAcceptedMimeType(req);
            if ("xml".equals(type)) {
                res.setContentType("application/xml");
                provider = new ActionReportResultXmlProvider();
            } else if ("json".equals(type)) {
                res.setContentType("application/json");
                provider = new ActionReportResultJsonProvider();
            } else {
                res.setContentType("text/html");
                provider = new ActionReportResultHtmlProvider();
            }
            res.setStatus(statusCode);
            res.getOutputStream().write(provider.getContent(new ActionReportResult(report)).getBytes());
            res.getOutputStream().flush();
            res.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class SubjectReferenceFactory
    implements Factory<Ref<Subject>> {
        Ref<Request> requestReference;

        @Inject
        public SubjectReferenceFactory(Provider<Ref<Request>> requestReference) {
            this.requestReference = (Ref)requestReference.get();
        }

        @Override
        public Ref<Subject> provide() {
            Subject subject = (Subject)((Request)this.requestReference.get()).getAttribute("SUBJECT");
            return Refs.of((Object)subject);
        }

        @Override
        public void dispose(Ref<Subject> t) {
        }
    }
}

