/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.ldap;

import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.IASRealm;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.login.LoginException;
import org.glassfish.internal.api.RelativePathResolver;
import org.jvnet.hk2.annotations.Service;

@Service
public final class LDAPRealm
extends IASRealm {
    public static final String AUTH_TYPE = "ldap";
    public static final String PARAM_DIRURL = "directory";
    public static final String PARAM_USERDN = "base-dn";
    public static final String PARAM_SEARCH_FILTER = "search-filter";
    public static final String PARAM_GRPDN = "group-base-dn";
    public static final String PARAM_GRP_SEARCH_FILTER = "group-search-filter";
    public static final String PARAM_GRP_TARGET = "group-target";
    public static final String PARAM_DYNAMIC_GRP_FILTER = "dynamic-group-search-filter";
    public static final String PARAM_DYNAMIC_GRP_TARGET = "dynamic-group-target";
    public static final String PARAM_MODE = "mode";
    public static final String PARAM_JNDICF = "jndiCtxFactory";
    public static final String PARAM_POOLSIZE = "pool-size";
    public static final String PARAM_BINDDN = "search-bind-dn";
    public static final String PARAM_BINDPWD = "search-bind-password";
    public static final String MODE_FIND_BIND = "find-bind";
    public static final String SUBST_SUBJECT_NAME = "%s";
    public static final String SUBST_SUBJECT_DN = "%d";
    private static final String SEARCH_FILTER_DEFAULT = "uid=%s";
    private static final String GRP_SEARCH_FILTER_DEFAULT = "uniquemember=%d";
    private static final String GRP_TARGET_DEFAULT = "cn";
    private static final String DYNAMIC_GRP_TARGET_DEFAULT = "ismemberof";
    private static final String MODE_DEFAULT = "find-bind";
    private static final String JNDICF_DEFAULT = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final int POOLSIZE_DEFAULT = 5;
    private final String[] _dnOnly = new String[]{"dn"};
    private static final String SUN_JNDI_POOL = "com.sun.jndi.ldap.connect.pool";
    private static final String SUN_JNDI_POOL_ = "com.sun.jndi.ldap.connect.pool.";
    private static final String SUN_JNDI_POOL_PROTOCOL = "com.sun.jndi.ldap.connect.pool.protocol";
    private static final String SUN_JNDI_POOL_MAXSIZE = "com.sun.jndi.ldap.connect.pool.maxsize";
    private static final String DYNAMIC_GROUP_OBJECT_FACTORY = "com.sun.jndi.ldap.obj.LdapGroupFactory";
    public static final String DYNAMIC_GROUP_FACTORY_OBJECT_PROPERTY = "java.naming.factory.object";
    private static final String DYNAMIC_GROUP_STATE_FACTORY = "com.sun.jndi.ldap.obj.LdapGroupFactory";
    public static final String DYNAMIC_GROUP_STATE_FACTORY_PROPERTY = "java.naming.factory.state";
    public static final String LDAP_SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    public static final String DEFAULT_SSL_LDAP_SOCKET_FACTORY = "com.sun.enterprise.security.auth.realm.ldap.CustomSocketFactory";
    public static final String LDAPS_URL = "ldaps://";
    public static final String DEFAULT_POOL_PROTOCOL = "plain ssl";
    public static final String DYNAMIC_GROUP_FILTER = "(&(objectclass=groupofuniquenames)(objectclass=*groupofurls*))";
    public static final String SSL = "SSL";
    private HashMap groupCache;
    private Vector emptyVector;
    private Properties ldapBindProps = new Properties();

    @Override
    public synchronized void init(Properties props) throws BadRealmException, NoSuchRealmException {
        String bindPWD;
        super.init(props);
        String url = props.getProperty(PARAM_DIRURL);
        String dn = props.getProperty(PARAM_USERDN);
        String jaasCtx = props.getProperty("jaas-context");
        if (url == null || dn == null || jaasCtx == null) {
            String msg = sm.getString("ldaprealm.badconfig", (Object)url, (Object)dn, (Object)jaasCtx);
            throw new BadRealmException(msg);
        }
        this.setProperty(PARAM_DIRURL, url);
        this.ldapBindProps.setProperty("java.naming.provider.url", url);
        this.setProperty(PARAM_USERDN, dn);
        this.setProperty("jaas-context", jaasCtx);
        String mode = props.getProperty(PARAM_MODE, "find-bind");
        if (!"find-bind".equals(mode)) {
            String msg = sm.getString("ldaprealm.badmode", (Object)mode);
            throw new BadRealmException(msg);
        }
        this.setProperty(PARAM_MODE, mode);
        String ctxF = props.getProperty(PARAM_JNDICF, JNDICF_DEFAULT);
        this.setProperty(PARAM_JNDICF, ctxF);
        this.ldapBindProps.setProperty("java.naming.factory.initial", ctxF);
        String searchFilter = props.getProperty(PARAM_SEARCH_FILTER, SEARCH_FILTER_DEFAULT);
        this.setProperty(PARAM_SEARCH_FILTER, searchFilter);
        String grpDN = props.getProperty(PARAM_GRPDN, dn);
        this.setProperty(PARAM_GRPDN, grpDN);
        String grpSearchFilter = props.getProperty(PARAM_GRP_SEARCH_FILTER, GRP_SEARCH_FILTER_DEFAULT);
        this.setProperty(PARAM_GRP_SEARCH_FILTER, grpSearchFilter);
        String dynGrpSearchFilter = props.getProperty(PARAM_DYNAMIC_GRP_FILTER, SEARCH_FILTER_DEFAULT);
        this.setProperty(PARAM_DYNAMIC_GRP_FILTER, dynGrpSearchFilter);
        String grpTarget = props.getProperty(PARAM_GRP_TARGET, GRP_TARGET_DEFAULT);
        this.setProperty(PARAM_GRP_TARGET, grpTarget);
        String dynGrpTarget = props.getProperty(PARAM_DYNAMIC_GRP_TARGET, DYNAMIC_GRP_TARGET_DEFAULT);
        this.setProperty(PARAM_DYNAMIC_GRP_TARGET, dynGrpTarget);
        String objectFactory = props.getProperty(DYNAMIC_GROUP_FACTORY_OBJECT_PROPERTY, "com.sun.jndi.ldap.obj.LdapGroupFactory");
        this.setProperty(DYNAMIC_GROUP_FACTORY_OBJECT_PROPERTY, objectFactory);
        this.ldapBindProps.setProperty(DYNAMIC_GROUP_FACTORY_OBJECT_PROPERTY, objectFactory);
        String stateFactory = props.getProperty(DYNAMIC_GROUP_STATE_FACTORY_PROPERTY, "com.sun.jndi.ldap.obj.LdapGroupFactory");
        this.setProperty(DYNAMIC_GROUP_STATE_FACTORY_PROPERTY, stateFactory);
        this.ldapBindProps.setProperty(DYNAMIC_GROUP_STATE_FACTORY_PROPERTY, stateFactory);
        String bindDN = props.getProperty(PARAM_BINDDN);
        if (bindDN != null) {
            this.setProperty(PARAM_BINDDN, bindDN);
            this.ldapBindProps.setProperty("java.naming.security.principal", bindDN);
        }
        if ((bindPWD = props.getProperty(PARAM_BINDPWD)) != null) {
            try {
                bindPWD = RelativePathResolver.getRealPasswordFromAlias((String)bindPWD);
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "ldaprealm.pwd.dealiasing.failed", ex);
            }
            this.setProperty(PARAM_BINDPWD, bindPWD);
            this.ldapBindProps.setProperty("java.naming.security.credentials", bindPWD);
        }
        Enumeration<?> penum = props.propertyNames();
        while (penum.hasMoreElements()) {
            String propName = (String)penum.nextElement();
            if (propName.startsWith("java.naming.") || propName.startsWith("javax.security.") || propName.startsWith("com.sun.jndi.ldap.")) {
                this.ldapBindProps.setProperty(propName, props.getProperty(propName));
                continue;
            }
            if (!propName.startsWith(SUN_JNDI_POOL_) || SUN_JNDI_POOL_MAXSIZE.equals(propName) || System.getProperty(propName) != null) continue;
            System.setProperty(propName, props.getProperty(propName));
        }
        String poolSize = Integer.getInteger(PARAM_POOLSIZE, 5).toString();
        String sunPoolSizeStr = props.getProperty(SUN_JNDI_POOL_MAXSIZE, poolSize);
        try {
            sunPoolSizeStr = Integer.valueOf(sunPoolSizeStr).toString();
        }
        catch (Exception ex) {
            sunPoolSizeStr = poolSize;
        }
        if (System.getProperty(SUN_JNDI_POOL_MAXSIZE) == null) {
            System.setProperty(SUN_JNDI_POOL_MAXSIZE, sunPoolSizeStr);
        }
        this.setProperty(PARAM_POOLSIZE, sunPoolSizeStr);
        String usePool = props.getProperty(SUN_JNDI_POOL, "true");
        this.ldapBindProps.setProperty(SUN_JNDI_POOL, usePool);
        if (url.startsWith(LDAPS_URL)) {
            this.ldapBindProps.setProperty(LDAP_SOCKET_FACTORY, DEFAULT_SSL_LDAP_SOCKET_FACTORY);
            if (System.getProperty(SUN_JNDI_POOL_PROTOCOL) == null) {
                System.setProperty(SUN_JNDI_POOL_PROTOCOL, DEFAULT_POOL_PROTOCOL);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "LDAPRealm : Using custom socket factory for SSL with pooling");
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            Properties tempProps = (Properties)this.ldapBindProps.clone();
            tempProps.remove("java.naming.security.credentials");
            _logger.log(Level.FINE, "LDAPRealm : " + tempProps);
        }
        this.groupCache = new HashMap();
        this.emptyVector = new Vector();
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE;
    }

    private String[] addMappedGroupNames(String[] grpList) {
        if (this.groupMapper == null) {
            return grpList;
        }
        ArrayList<String> finalresult = new ArrayList<String>();
        for (String grp : grpList) {
            ArrayList<String> result = new ArrayList<String>();
            this.groupMapper.getMappedGroups(grp, result);
            finalresult.add(grp);
            if (result.isEmpty()) continue;
            finalresult.addAll(result);
        }
        return finalresult.toArray(new String[finalresult.size()]);
    }

    private Properties getLdapBindProps() {
        return (Properties)this.ldapBindProps.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getGroups(String userDN) {
        InitialDirContext ctx = null;
        String srcFilter = null;
        String dynFilter = null;
        String dynMember = this.getProperty(PARAM_DYNAMIC_GRP_TARGET);
        try {
            ctx = new InitialDirContext(this.getLdapBindProps());
            String _username = userDN;
            try {
                _username = new LdapName(userDN).getRdns().stream().filter(rdn -> rdn.getType().equalsIgnoreCase(GRP_TARGET_DEFAULT)).map(rdn -> rdn.getValue().toString()).findFirst().orElseGet(null);
            }
            catch (InvalidNameException invalidNameException) {
                // empty catch block
            }
            if (_username == null && userDN != null && userDN.startsWith("uid")) {
                int first = userDN.indexOf("uid=");
                int last = userDN.indexOf(",");
                if (first != -1 && last != -1) {
                    _username = userDN.substring(first + 4, last);
                }
            }
            StringBuffer sb = new StringBuffer(this.getProperty(PARAM_GRP_SEARCH_FILTER));
            StringBuffer dynSb = new StringBuffer(this.getProperty(PARAM_DYNAMIC_GRP_FILTER));
            LDAPRealm.substitute(sb, SUBST_SUBJECT_NAME, _username);
            LDAPRealm.substitute(sb, SUBST_SUBJECT_DN, userDN);
            LDAPRealm.substitute(dynSb, SUBST_SUBJECT_NAME, _username);
            LDAPRealm.substitute(dynSb, SUBST_SUBJECT_DN, userDN);
            srcFilter = sb.toString();
            dynFilter = dynSb.toString();
            ArrayList<String> groupsList = new ArrayList<String>();
            groupsList.addAll(this.groupSearch(ctx, this.getProperty(PARAM_GRPDN), srcFilter, this.getProperty(PARAM_GRP_TARGET)));
            groupsList.addAll(this.dynamicGroupSearch(ctx, this.getProperty(PARAM_GRPDN), dynMember, dynFilter, this.getProperty(PARAM_GRP_TARGET)));
            ArrayList<String> arrayList = groupsList;
            return arrayList;
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "ldaprealm.groupsearcherror", e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    _logger.log(Level.WARNING, "ldaprealm.exception", e);
                }
            }
        }
        return null;
    }

    @Override
    public Enumeration getGroupNames(String username) throws InvalidOperationException, NoSuchUserException {
        Vector v = (Vector)this.groupCache.get(username);
        if (v == null) {
            List<String> searchedGrps = this.getGroups(username);
            if (searchedGrps != null) {
                return Collections.enumeration(searchedGrps);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "No groups available for: " + username);
            }
            return this.emptyVector.elements();
        }
        if (this.groupMapper != null) {
            Vector ret = new Vector();
            ret.addAll(v);
            ArrayList<String> result = new ArrayList<String>();
            for (Object o : v) {
                String grp = (String)o;
                ArrayList<String> tmp = this.getMappedGroupNames(grp);
                result.addAll(tmp);
            }
            ret.addAll(result);
            return ret.elements();
        }
        return v.elements();
    }

    private void setGroupNames(String username, String[] groups) {
        Vector<String> v = new Vector<String>(groups.length);
        for (int i = 0; i < groups.length; ++i) {
            v.add(groups[i]);
        }
        this.groupCache.put(username, v);
    }

    public String[] findAndBind(String _username, char[] _password) throws LoginException {
        _username = this.RFC2254Encode(_username);
        StringBuffer sb = new StringBuffer(this.getProperty(PARAM_SEARCH_FILTER));
        LDAPRealm.substitute(sb, SUBST_SUBJECT_NAME, _username);
        String userid = sb.toString();
        InitialDirContext ctx = null;
        String srcFilter = null;
        String[] grpList = null;
        String dynFilter = null;
        String dynMember = this.getProperty(PARAM_DYNAMIC_GRP_TARGET);
        try {
            ctx = new InitialDirContext(this.getLdapBindProps());
            String realUserDN = this.userSearch(ctx, this.getProperty(PARAM_USERDN), userid);
            if (realUserDN == null) {
                String msg = sm.getString("ldaprealm.usernotfound", (Object)_username);
                throw new LoginException(msg);
            }
            boolean bindSuccessful = this.bindAsUser(realUserDN, _password);
            if (!bindSuccessful) {
                String msg = sm.getString("ldaprealm.bindfailed", (Object)realUserDN);
                throw new LoginException(msg);
            }
            sb = new StringBuffer(this.getProperty(PARAM_GRP_SEARCH_FILTER));
            StringBuffer dynSb = new StringBuffer(this.getProperty(PARAM_DYNAMIC_GRP_FILTER));
            LDAPRealm.substitute(sb, SUBST_SUBJECT_NAME, _username);
            LDAPRealm.substitute(sb, SUBST_SUBJECT_DN, realUserDN);
            LDAPRealm.substitute(dynSb, SUBST_SUBJECT_NAME, _username);
            LDAPRealm.substitute(dynSb, SUBST_SUBJECT_DN, realUserDN);
            srcFilter = sb.toString();
            dynFilter = dynSb.toString();
            ArrayList groupsList = new ArrayList();
            groupsList.addAll(this.groupSearch(ctx, this.getProperty(PARAM_GRPDN), srcFilter, this.getProperty(PARAM_GRP_TARGET)));
            groupsList.addAll(this.dynamicGroupSearch(ctx, this.getProperty(PARAM_GRPDN), dynMember, dynFilter, this.getProperty(PARAM_GRP_TARGET)));
            grpList = new String[groupsList.size()];
            groupsList.toArray(grpList);
        }
        catch (Exception e) {
            LoginException le = new LoginException(e.toString());
            le.initCause(e);
            _logger.log(Level.SEVERE, "ldaprealm.exception", le);
            throw le;
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "LDAP:Group search filter: " + srcFilter);
            StringBuffer gb = new StringBuffer();
            gb.append("Group memberships found: ");
            if (grpList.length > 0) {
                for (int i = 0; i < grpList.length; ++i) {
                    gb.append(" " + grpList[i]);
                }
            } else {
                gb.append("(null)");
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "LDAP: " + gb.toString());
            }
        }
        grpList = this.addAssignGroups(grpList);
        grpList = this.addMappedGroupNames(grpList);
        this.setGroupNames(_username, grpList);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "LDAP: login succeeded for: " + _username);
        }
        return grpList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String userSearch(DirContext ctx, String baseDN, String filter) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINE, "search: baseDN: " + baseDN + "  filter: " + filter);
        }
        String foundDN = null;
        NamingEnumeration<SearchResult> namingEnum = null;
        SearchControls ctls = new SearchControls();
        ctls.setReturningAttributes(this._dnOnly);
        ctls.setSearchScope(2);
        ctls.setCountLimit(1L);
        try {
            namingEnum = ctx.search(baseDN, filter, ctls);
            if (namingEnum.hasMore()) {
                SearchResult res = namingEnum.next();
                StringBuffer sb = new StringBuffer();
                CompositeName compDN = new CompositeName(res.getName());
                String ldapDN = compDN.get(0);
                sb.append(ldapDN);
                if (res.isRelative()) {
                    sb.append(",");
                    sb.append(baseDN);
                }
                foundDN = sb.toString();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINE, "Found user DN: " + foundDN);
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "ldaprealm.searcherror", filter);
            _logger.log(Level.WARNING, "security.exception", e);
        }
        finally {
            if (namingEnum != null) {
                try {
                    namingEnum.close();
                }
                catch (Exception exception) {}
            }
        }
        return foundDN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bindAsUser(String bindDN, char[] password) {
        boolean bindSuccessful = false;
        Properties p = this.getLdapBindProps();
        p.put("java.naming.security.principal", bindDN);
        p.put("java.naming.security.credentials", new String(password));
        InitialDirContext ctx = null;
        try {
            ctx = new InitialDirContext(p);
            bindSuccessful = true;
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Error binding to directory as: " + bindDN);
                _logger.finest("Exception from JNDI: " + e.toString());
            }
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
        return bindSuccessful;
    }

    private List dynamicGroupSearch(DirContext ctx, String baseDN, String memberOfAttr, String filter, String target) throws NamingException {
        ArrayList<Object> groupList = new ArrayList<Object>();
        String[] targets = new String[]{memberOfAttr};
        try {
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(targets);
            ctls.setSearchScope(2);
            ctls.setReturningObjFlag(false);
            NamingEnumeration<SearchResult> e = ctx.search(baseDN, filter, ctls);
            while (e.hasMore()) {
                SearchResult res = e.next();
                Attribute isMemberOf = res.getAttributes().get(memberOfAttr);
                if (isMemberOf == null) continue;
                NamingEnumeration<?> values = isMemberOf.getAll();
                block3: while (values.hasMoreElements()) {
                    String groupDN = (String)values.nextElement();
                    LdapName dn = new LdapName(groupDN);
                    for (Rdn rdn : dn.getRdns()) {
                        if (!rdn.getType().equalsIgnoreCase(target)) continue;
                        groupList.add(rdn.getValue());
                        continue block3;
                    }
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "ldaprealm.searcherror", filter);
            _logger.log(Level.WARNING, "security.exception", e);
        }
        return groupList;
    }

    private List groupSearch(DirContext ctx, String baseDN, String filter, String target) {
        ArrayList<String> groupList = new ArrayList<String>();
        try {
            String[] targets = new String[]{target};
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(targets);
            ctls.setSearchScope(2);
            NamingEnumeration<SearchResult> e = ctx.search(baseDN, filter.replaceAll(Matcher.quoteReplacement("\\"), Matcher.quoteReplacement("\\\\")), ctls);
            while (e.hasMore()) {
                SearchResult res = e.next();
                Attribute grpAttr = res.getAttributes().get(target);
                int sz = grpAttr.size();
                for (int i = 0; i < sz; ++i) {
                    String s = (String)grpAttr.get(i);
                    groupList.add(s);
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "ldaprealm.searcherror", filter);
            _logger.log(Level.WARNING, "security.exception", e);
        }
        return groupList;
    }

    private static void substitute(StringBuffer sb, String target, String value) {
        int i = sb.indexOf(target);
        while (i >= 0) {
            sb.replace(i, i + target.length(), value);
            i = sb.indexOf(target);
        }
    }

    private String RFC2254Encode(String inName) {
        int len = inName.length();
        StringBuffer buf = new StringBuffer(len);
        block7: for (int i = 0; i < len; ++i) {
            char ch = inName.charAt(i);
            switch (ch) {
                case '*': {
                    buf.append("\\2a");
                    continue block7;
                }
                case '(': {
                    buf.append("\\28");
                    continue block7;
                }
                case ')': {
                    buf.append("\\29");
                    continue block7;
                }
                case '\\': {
                    buf.append("\\5c");
                    continue block7;
                }
                case '\u0000': {
                    buf.append("\\00");
                    continue block7;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }
}

