/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.binding.convert.impl;

import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.krazo.binding.convert.ConverterResult;
import org.eclipse.krazo.binding.convert.impl.NumberConverter;

public class LongConverter
extends NumberConverter<Long> {
    @Override
    public boolean supports(Class<Long> rawType, Annotation[] annotations) {
        return Long.class.equals(rawType) || Long.TYPE.equals(rawType);
    }

    @Override
    public ConverterResult<Long> convert(String value, Class<Long> rawType, Annotation[] annotations, Locale locale) {
        Long defaultValue = Long.TYPE.equals(rawType) ? Long.valueOf(0L) : null;
        try {
            return ConverterResult.success(this.parseNumber(value, locale).map(Number::longValue).orElse(defaultValue));
        }
        catch (ParseException e) {
            return ConverterResult.failed(defaultValue, e.getMessage());
        }
    }
}

