/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.SecurityRoleMapperFactoryGen;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContextException;
import java.security.Policy;
import java.util.Set;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.glassfish.deployment.versioning.VersioningUtils;

public class SecurityUtil {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SecurityUtil.class);
    private static final Logger _logger = LogDomains.getLogger(SecurityUtil.class, (String)"javax.enterprise.system.core.security");
    public static final String VENDOR_PRESENT = "com.sun.enterprise.security.provider.jaccvendorpresent";
    private static final String REPOSITORY_HOME_PROP = "com.sun.enterprise.jaccprovider.property.repository";
    public static final String repository = System.getProperty("com.sun.enterprise.jaccprovider.property.repository");

    public static String getContextID(EjbBundleDescriptor ejbBundleDesc) {
        if (ejbBundleDesc == null) {
            return null;
        }
        RootDeploymentDescriptor root = ejbBundleDesc.getModuleDescriptor().getDescriptor();
        if (root != ejbBundleDesc && root instanceof WebBundleDescriptor) {
            return SecurityUtil.createUniquePseudoModuleID(ejbBundleDesc);
        }
        return VersioningUtils.getRepositoryName((String)ejbBundleDesc.getApplication().getRegistrationName()) + "/" + ejbBundleDesc.getUniqueFriendlyId();
    }

    public static String getContextID(WebBundleDescriptor webBundleDescriptor) {
        if (webBundleDescriptor == null) {
            return null;
        }
        return VersioningUtils.getRepositoryName((String)webBundleDescriptor.getApplication().getRegistrationName()) + "/" + webBundleDescriptor.getUniqueFriendlyId();
    }

    public static void removePolicy(String contextId) throws IASSecurityException {
        if (contextId == null) {
            throw new IASSecurityException("Invalid Module Name");
        }
        try {
            boolean wasInService = PolicyConfigurationFactory.getPolicyConfigurationFactory().inService(contextId);
            PolicyConfiguration pc = PolicyConfigurationFactory.getPolicyConfigurationFactory().getPolicyConfiguration(contextId, false);
            pc.delete();
            if (wasInService) {
                Policy.getPolicy().refresh();
            }
        }
        catch (ClassNotFoundException cnfe) {
            String msg = localStrings.getLocalString("enterprise.security.securityutil.classnotfound", "Could not find PolicyConfigurationFactory class. Check jakarta.security.jacc.PolicyConfigurationFactory.provider property");
            throw new IASSecurityException(msg);
        }
        catch (PolicyContextException pce) {
            throw new IASSecurityException(pce.toString());
        }
    }

    private static String createUniquePseudoModuleID(EjbBundleDescriptor ejbDesc) {
        String pseudonym;
        boolean unique;
        Application app = ejbDesc.getApplication();
        Set webModules = app.getBundleDescriptors(WebBundleDescriptor.class);
        Set ejbModules = app.getBundleDescriptors(EjbBundleDescriptor.class);
        String moduleName = ejbDesc.getUniqueFriendlyId();
        int uniquifier = 0;
        do {
            unique = true;
            pseudonym = moduleName + (String)(uniquifier == 0 ? "_internal" : "_internal_" + uniquifier);
            if (webModules != null) {
                for (WebBundleDescriptor w : webModules) {
                    if (!pseudonym.equals(w.getUniqueFriendlyId())) continue;
                    unique = false;
                    break;
                }
            }
            if (unique && ejbModules != null) {
                for (EjbBundleDescriptor e : ejbModules) {
                    if (!pseudonym.equals(e.getUniqueFriendlyId())) continue;
                    unique = false;
                    break;
                }
            }
            ++uniquifier;
        } while (!unique);
        return VersioningUtils.getRepositoryName((String)app.getRegistrationName()) + "/" + pseudonym;
    }

    public static void removeRoleMapper(DeploymentContext dc) {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin != OpsParams.Origin.undeploy) {
            return;
        }
        String appName = params.name();
        SecurityRoleMapperFactory factory = SecurityUtil.getRoleMapperFactory();
        factory.removeRoleMapper(appName);
    }

    public static SecurityRoleMapperFactory getRoleMapperFactory() {
        SecurityRoleMapperFactory factory = SecurityRoleMapperFactoryGen.getSecurityRoleMapperFactory();
        if (factory == null) {
            throw new IllegalArgumentException("This application has no role mapper factory defined");
        }
        return factory;
    }
}

