/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

class FilteringClassLoader
extends ClassLoader {
    private static final Logger LOG = Logger.getLogger(FilteringClassLoader.class.getName());
    private static final String PATH_WELD_EXTENTSION = "META-INF/services/jakarta.enterprise.inject.spi.Extension";
    private static final String PATH_MANIFEST = "META-INF/MANIFEST.MF";
    private static final Pattern PATTERN_OSGI_EE_JAVA = Pattern.compile("\\(&\\(osgi.ee=JavaSE\\)\\(version=(.+)\\)\\)");
    private static final Runtime.Version JDK17 = Runtime.Version.parse("17");

    FilteringClassLoader(ClassLoader parent) {
        super(parent);
        LOG.log(Level.FINEST, "Parent: {0}", parent);
    }

    @Override
    public URL getResource(String name) {
        LOG.log(Level.FINE, "getResource(): {0}", name);
        return this.getParent().getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        LOG.log(Level.FINE, "getResources(): {0}", name);
        Enumeration<URL> resources = this.getParent().getResources(name);
        Runtime.Version javaVersion = Runtime.version();
        if (javaVersion.compareTo(JDK17) >= 0) {
            return resources;
        }
        if (!name.endsWith(PATH_WELD_EXTENTSION)) {
            return resources;
        }
        Predicate<URL> filter = url -> {
            if (this.isCompatible((URL)url)) {
                LOG.log(Level.FINEST, "Resource OK: {0}", url);
                return true;
            }
            LOG.log(Level.WARNING, "Removed extension {0} incompatible with the current JDK {1}.", new Object[]{url, javaVersion});
            return false;
        };
        Iterable iterable = () -> resources.asIterator();
        List list = StreamSupport.stream(iterable.spliterator(), false).filter(filter).collect(Collectors.toList());
        return Collections.enumeration(list);
    }

    private boolean isCompatible(URL extensionUrl) {
        URL manifestURL = this.toManifestURL(extensionUrl);
        Manifest manifest = this.loadManifest(manifestURL);
        if (manifest == null) {
            return true;
        }
        Runtime.Version requiredMinVersion = this.getRequiredMinimalJavaVersion(manifest.getMainAttributes());
        if (requiredMinVersion == null) {
            return true;
        }
        return requiredMinVersion.compareTo(Runtime.version()) <= 0;
    }

    private URL toManifestURL(URL extensionUrl) {
        try {
            return new URL(extensionUrl.toExternalForm().replaceFirst(PATH_WELD_EXTENTSION, PATH_MANIFEST));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Unprocessable URL: " + extensionUrl, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest loadManifest(URL manifestURL) {
        try (InputStream stream = this.openStream(manifestURL);){
            if (stream == null) {
                Manifest manifest2 = null;
                return manifest2;
            }
            Manifest manifest = new Manifest(stream);
            return manifest;
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Could not read manifest at " + manifestURL, e);
            return null;
        }
    }

    private InputStream openStream(URL manifestURL) throws IOException {
        try {
            return manifestURL.openStream();
        }
        catch (FileNotFoundException e) {
            LOG.log(Level.FINEST, "The manifest is not present at " + manifestURL, e);
            return null;
        }
    }

    private Runtime.Version getRequiredMinimalJavaVersion(Attributes attributes) {
        String requireCapability = attributes.getValue("Require-Capability");
        if (requireCapability == null) {
            return null;
        }
        Matcher matcher = PATTERN_OSGI_EE_JAVA.matcher(requireCapability);
        if (matcher.find()) {
            return Runtime.Version.parse(matcher.group(1));
        }
        return null;
    }
}

