/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.cfg;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class LoggingProperties
extends Properties {
    private static final long serialVersionUID = 8351124426913908969L;

    public LoggingProperties() {
    }

    public LoggingProperties(Properties properties) {
        this.putAll((Map<?, ?>)properties);
    }

    @Override
    public Enumeration<Object> keys() {
        return Collections.enumeration(Collections.list(super.keys()).stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList()));
    }

    public SortedSet<String> getPropertyNames() {
        return this.keySet().stream().map(String::valueOf).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public synchronized Set<Map.Entry<Object, Object>> entrySet() {
        Comparator comparator = (x, z) -> {
            if (x.getKey() instanceof Comparable && z.getKey() instanceof Comparable) {
                Comparable key1 = (Comparable)x.getKey();
                Comparable key2 = (Comparable)z.getKey();
                return key1.compareTo(key2);
            }
            return Integer.compare(x.getKey().hashCode(), z.getKey().hashCode());
        };
        return Collections.synchronizedSet(super.entrySet().stream().sorted(comparator).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public void store(File outputFile, String comments) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outputFile));){
            this.store(os, comments);
        }
    }

    public ByteArrayInputStream toInputStream(String comments) throws IOException {
        ByteArrayOutputStream outputstream = new ByteArrayOutputStream(32768);
        this.store(outputstream, comments);
        return new ByteArrayInputStream(outputstream.toByteArray());
    }

    @Override
    public LoggingProperties clone() {
        return (LoggingProperties)super.clone();
    }

    public static LoggingProperties loadFrom(File file) throws IOException {
        if (!file.canRead()) {
            return null;
        }
        try (FileInputStream input = new FileInputStream(file);){
            LoggingProperties loggingProperties = LoggingProperties.loadFrom(input);
            return loggingProperties;
        }
    }

    public static LoggingProperties loadFrom(InputStream stream) throws IOException {
        LoggingProperties properties = new LoggingProperties();
        properties.load(stream);
        return properties;
    }
}

