/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.env;

import java.io.PrintStream;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public final class LoggingSystemEnvironment {
    private static final PrintStream ORIGINAL_STD_ERR = System.err;
    private static final PrintStream ORIGINAL_STD_OUT = System.out;
    private static String productId;
    private static boolean releaseParametersEarly;
    private static boolean resolveLevelWithIncompleteConfiguration;

    private LoggingSystemEnvironment() {
    }

    public static synchronized void initialize() {
    }

    public static PrintStream getOriginalStdErr() {
        return ORIGINAL_STD_ERR;
    }

    public static PrintStream getOriginalStdOut() {
        return ORIGINAL_STD_OUT;
    }

    public static void resetStandardOutputs() {
        LoggingSystemEnvironment.logSetter("Output streams reset to JVM defaults.");
        System.setOut(ORIGINAL_STD_OUT);
        System.setErr(ORIGINAL_STD_ERR);
    }

    public static String getProductId() {
        return productId;
    }

    public static void setProductId(String productId) {
        LoggingSystemEnvironment.logSetter("productId: " + productId);
        LoggingSystemEnvironment.productId = productId;
    }

    public static boolean isReleaseParametersEarly() {
        return releaseParametersEarly;
    }

    public static void setReleaseParametersEarly(boolean releaseParametersEarly) {
        LoggingSystemEnvironment.logSetter("releaseParametersEarly: " + releaseParametersEarly);
        LoggingSystemEnvironment.releaseParametersEarly = releaseParametersEarly;
    }

    public static void setResolveLevelWithIncompleteConfiguration(boolean resolveLevelWithIncompleteConfiguration) {
        LoggingSystemEnvironment.logSetter("resolveLevelWithIncompleteConfiguration: " + resolveLevelWithIncompleteConfiguration);
        LoggingSystemEnvironment.resolveLevelWithIncompleteConfiguration = resolveLevelWithIncompleteConfiguration;
    }

    public static boolean isResolveLevelWithIncompleteConfiguration() {
        return resolveLevelWithIncompleteConfiguration;
    }

    private static void logSetter(String message) {
        GlassFishLoggingTracer.stacktrace(LoggingSystemEnvironment.class, message);
    }

    static {
        releaseParametersEarly = true;
    }
}

