/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.web.integration;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityContextProxy;
import java.security.Principal;
import java.security.cert.X509Certificate;
import org.glassfish.security.common.UserNameAndPassword;

public class WebPrincipal
extends UserNameAndPassword
implements SecurityContextProxy {
    private static final long serialVersionUID = -7855179427171479644L;
    private X509Certificate[] certificates;
    private final boolean useCertificate;
    private final SecurityContext securityContext;
    private Principal customPrincipal;

    public WebPrincipal(UserNameAndPassword principal, SecurityContext context) {
        super(principal.getName(), principal.getPassword());
        this.useCertificate = false;
        this.securityContext = context;
    }

    public WebPrincipal(Principal principal, SecurityContext context) {
        super(principal.getName());
        this.customPrincipal = principal;
        this.useCertificate = false;
        this.securityContext = context;
    }

    public WebPrincipal(String user, String password, SecurityContext context) {
        this(user, password == null ? null : password.toCharArray(), context);
    }

    public WebPrincipal(String user, char[] pwd, SecurityContext context) {
        super(user, pwd);
        this.useCertificate = false;
        this.securityContext = context;
    }

    public WebPrincipal(X509Certificate[] certs, SecurityContext context) {
        super(WebPrincipal.getPrincipalName(context, certs));
        this.certificates = certs;
        this.useCertificate = true;
        this.securityContext = context;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }

    public boolean isUsingCertificate() {
        return this.useCertificate;
    }

    public Principal getCustomPrincipal() {
        return this.customPrincipal;
    }

    public boolean equals(Object another) {
        if (this.customPrincipal == null) {
            return super.equals(another);
        }
        return this.customPrincipal.equals(another);
    }

    public int hashCode() {
        if (this.customPrincipal == null) {
            return super.hashCode();
        }
        return this.customPrincipal.hashCode();
    }

    public String toString() {
        if (this.customPrincipal == null) {
            return super.toString();
        }
        return this.customPrincipal.toString();
    }

    private static String getPrincipalName(SecurityContext securityContext, X509Certificate[] certificates) {
        Principal callerPrincipal = securityContext.getCallerPrincipal();
        if (callerPrincipal != null) {
            return callerPrincipal.getName();
        }
        if (certificates != null && certificates.length > 0) {
            return certificates[0].getSubjectX500Principal().getName();
        }
        return null;
    }
}

