/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import com.sun.appserv.ProxyHandler;
import java.io.CharConversionException;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Constants;
import org.apache.catalina.connector.CoyotePrincipal;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.util.ServerInfo;
import org.glassfish.common.util.InputValidationUtil;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Note;
import org.glassfish.grizzly.http.server.AfterServiceListener;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.internal.api.Globals;
import org.glassfish.web.valve.GlassFishValve;
import org.glassfish.web.valve.ServletContainerInterceptor;

public class CoyoteAdapter
extends HttpHandler {
    private static final Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    static final String JVM_ROUTE = System.getProperty("jvmRoute");
    protected static final boolean ALLOW_BACKSLASH = Boolean.valueOf(System.getProperty("org.glassfish.grizzly.tcp.tomcat5.CoyoteAdapter.ALLOW_BACKSLASH", "false"));
    private static final boolean COLLAPSE_ADJACENT_SLASHES = Boolean.valueOf(System.getProperty("com.sun.enterprise.web.collapseAdjacentSlashes", "true"));
    protected static final Note<MappingData> MAPPING_DATA = org.glassfish.grizzly.http.server.Request.createNote((String)"MappingData");
    static final Note<Request> CATALINA_REQUEST_NOTE = org.glassfish.grizzly.http.server.Request.createNote((String)Request.class.getName());
    static final Note<Response> CATALINA_RESPONSE_NOTE = org.glassfish.grizzly.http.server.Request.createNote((String)Response.class.getName());
    static final CatalinaAfterServiceListener catalinaAfterServiceListener = new CatalinaAfterServiceListener();
    private static final Note<DataChunk> DATA_CHUNK = org.glassfish.grizzly.http.server.Request.createNote((String)"DataChunk");
    private Collection<ServletContainerInterceptor> interceptors;
    private boolean compatWithTomcat;
    private String serverName = ServerInfo.getPublicServerInfo();
    private Connector connector;

    public CoyoteAdapter(Connector connector) {
        this.connector = connector;
        this.initServletInterceptors();
    }

    public void service(org.glassfish.grizzly.http.server.Request grizzlyRequest, org.glassfish.grizzly.http.server.Response grizzlyResponse) throws Exception {
        boolean v3Enabled;
        grizzlyResponse.getResponse().setAllowCustomReasonPhrase(Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER);
        Request catalinaRequest = (Request)grizzlyRequest.getNote(CATALINA_REQUEST_NOTE);
        Response catalinaResponse = (Response)grizzlyRequest.getNote(CATALINA_RESPONSE_NOTE);
        MappingData mappingData = (MappingData)grizzlyRequest.getNote(MAPPING_DATA);
        boolean bl = v3Enabled = mappingData != null;
        if (catalinaRequest == null) {
            catalinaRequest = (Request)this.connector.createRequest();
            catalinaResponse = (Response)this.connector.createResponse();
            catalinaRequest.setResponse(catalinaResponse);
            catalinaResponse.setRequest(catalinaRequest);
            grizzlyRequest.setNote(CATALINA_REQUEST_NOTE, (Object)catalinaRequest);
            grizzlyRequest.setNote(CATALINA_RESPONSE_NOTE, (Object)catalinaResponse);
            grizzlyRequest.getRequest().getRequestURIRef().setDefaultURIEncoding(Charset.forName(this.connector.getURIEncoding()));
        }
        catalinaRequest.setGrizzlyRequest(grizzlyRequest);
        catalinaResponse.setCoyoteResponse(grizzlyResponse);
        if (v3Enabled && !this.compatWithTomcat) {
            catalinaRequest.setMappingData(mappingData);
            catalinaRequest.updatePaths(mappingData);
        }
        grizzlyRequest.addAfterServiceListener((AfterServiceListener)catalinaAfterServiceListener);
        try {
            this.doService(grizzlyRequest, catalinaRequest, grizzlyResponse, catalinaResponse, v3Enabled);
            catalinaRequest.onExitService();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00037", t);
        }
    }

    private void enteringServletContainer(Request req, Response res) {
        if (this.interceptors == null) {
            return;
        }
        for (ServletContainerInterceptor interceptor : this.interceptors) {
            try {
                interceptor.preInvoke(req, res);
            }
            catch (Throwable th) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00493", th);
            }
        }
    }

    private void leavingServletContainer(Request req, Response res) {
        if (this.interceptors == null) {
            return;
        }
        for (ServletContainerInterceptor interceptor : this.interceptors) {
            try {
                interceptor.postInvoke(req, res);
            }
            catch (Throwable th) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00493", th);
            }
        }
    }

    private void initServletInterceptors() {
        try {
            this.interceptors = Globals.getDefaultHabitat().getAllServices(ServletContainerInterceptor.class, new Annotation[0]);
        }
        catch (Throwable th) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00494", th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doService(org.glassfish.grizzly.http.server.Request grizzlyRequest, Request catalinaRequest, org.glassfish.grizzly.http.server.Response grizzlyResponse, Response catalinaResponse, boolean v3Enabled) throws Exception {
        if (!this.connector.isEnabled()) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00038"), String.valueOf(this.connector.getPort()));
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, msg);
            }
            catalinaResponse.sendError(404, msg);
            return;
        }
        if (this.postParseRequest(grizzlyRequest, catalinaRequest, grizzlyResponse, catalinaResponse, v3Enabled)) {
            boolean authPassthroughEnabled = this.connector.getAuthPassthroughEnabled();
            ProxyHandler proxyHandler = this.connector.getProxyHandler();
            if (authPassthroughEnabled && proxyHandler != null) {
                if (proxyHandler.getSSLKeysize(catalinaRequest.getRequest()) > 0) {
                    catalinaRequest.setSecure(true);
                }
                X509Certificate[] certs = null;
                try {
                    certs = proxyHandler.getSSLClientCertificateChain(catalinaRequest.getRequest());
                }
                catch (CertificateException ce) {
                    log.log(Level.SEVERE, "AS-WEB-CORE-00039", ce);
                }
                if (certs != null) {
                    catalinaRequest.setAttribute("jakarta.servlet.request.X509Certificate", certs);
                }
            }
            this.connector.requestStartEvent(catalinaRequest.getRequest(), catalinaRequest.getHost(), catalinaRequest.getContext());
            Container container = this.connector.getContainer();
            this.enteringServletContainer(catalinaRequest, catalinaResponse);
            try {
                catalinaRequest.lockSession();
                if (container.getPipeline().hasNonBasicValves() || container.hasCustomPipeline()) {
                    container.getPipeline().invoke(catalinaRequest, catalinaResponse);
                } else {
                    Host host = catalinaRequest.getHost();
                    if (host == null) {
                        catalinaResponse.sendError(400);
                        catalinaResponse.setDetailMessage(MessageFormat.format(rb.getString("AS-WEB-CORE-00040"), catalinaRequest.getRequest().getServerName()));
                        return;
                    }
                    if (host.getPipeline().hasNonBasicValves() || host.hasCustomPipeline()) {
                        host.getPipeline().invoke(catalinaRequest, catalinaResponse);
                    } else {
                        GlassFishValve hostValve = host.getPipeline().getBasic();
                        hostValve.invoke(catalinaRequest, catalinaResponse);
                        hostValve.postInvoke(catalinaRequest, catalinaResponse);
                    }
                }
            }
            finally {
                try {
                    this.connector.requestEndEvent(catalinaRequest.getRequest(), catalinaRequest.getHost(), catalinaRequest.getContext(), catalinaResponse.getStatus());
                }
                finally {
                    this.leavingServletContainer(catalinaRequest, catalinaResponse);
                }
            }
        }
    }

    protected boolean postParseRequest(org.glassfish.grizzly.http.server.Request grizzlyRequest, Request catalinaRequest, org.glassfish.grizzly.http.server.Response grizzlyResponse, Response catalinaResponse, boolean v3Enabled) throws Exception {
        Context catalinaContext;
        DataChunk decodedURI;
        catalinaRequest.setSecure(grizzlyRequest.isSecure());
        try {
            decodedURI = grizzlyRequest.getRequest().getRequestURIRef().getDecodedRequestURIBC();
        }
        catch (CharConversionException cce) {
            catalinaResponse.sendError(400, "Invalid URI");
            return false;
        }
        if (!CoyoteAdapter.normalize(decodedURI, catalinaResponse)) {
            catalinaResponse.sendError(400, catalinaResponse.getDetailMessage());
            return false;
        }
        if (this.compatWithTomcat || !v3Enabled) {
            String authtype;
            String principal = grizzlyRequest.getRemoteUser();
            if (principal != null) {
                catalinaRequest.setUserPrincipal(new CoyotePrincipal(principal));
            }
            if ((authtype = grizzlyRequest.getAuthType()) != null) {
                catalinaRequest.setAuthType(authtype);
            }
        }
        CharChunk uriParamsCC = catalinaRequest.getURIParams();
        CharChunk uriCC = decodedURI.getCharChunk();
        int semicolon = uriCC.indexOf(';');
        if (semicolon > 0) {
            int absSemicolon = uriCC.getStart() + semicolon;
            uriParamsCC.setChars(uriCC.getBuffer(), absSemicolon, uriCC.getEnd() - absSemicolon);
            decodedURI.setChars(uriCC.getBuffer(), uriCC.getStart(), absSemicolon - uriCC.getStart());
        }
        if (this.compatWithTomcat || !v3Enabled) {
            DataChunk localDecodedURI = decodedURI;
            if (semicolon > 0) {
                localDecodedURI = (DataChunk)grizzlyRequest.getNote(DATA_CHUNK);
                if (localDecodedURI == null) {
                    localDecodedURI = DataChunk.newInstance();
                    grizzlyRequest.setNote(DATA_CHUNK, (Object)localDecodedURI);
                }
                localDecodedURI.duplicate(decodedURI);
            }
            this.connector.getMapper().map(grizzlyRequest.getRequest().serverName(), localDecodedURI, catalinaRequest.getMappingData());
            MappingData md = catalinaRequest.getMappingData();
            grizzlyRequest.setNote(MAPPING_DATA, (Object)md);
            catalinaRequest.updatePaths(md);
        }
        String proxyName = this.connector.getProxyName();
        int proxyPort = this.connector.getProxyPort();
        if (proxyPort != 0) {
            grizzlyRequest.setServerPort(proxyPort);
        }
        if (proxyName != null) {
            grizzlyRequest.setServerName(proxyName);
        }
        if ((catalinaContext = (Context)catalinaRequest.getMappingData().context) != null) {
            if (grizzlyRequest.isRequestedSessionIdFromURL() && "jsessionid".equals(catalinaContext.getSessionParameterName())) {
                catalinaRequest.obtainSessionId();
            } else if (!uriParamsCC.isNull()) {
                catalinaRequest.parseSessionId(catalinaContext.getSessionParameterName(), uriParamsCC);
            }
        }
        catalinaRequest.setDefaultContext(catalinaRequest.getMappingData().isDefaultContext);
        catalinaRequest.setContext(catalinaContext);
        if (catalinaContext != null && !uriParamsCC.isNull()) {
            catalinaRequest.parseSessionVersion(uriParamsCC);
        }
        if (!uriParamsCC.isNull()) {
            catalinaRequest.parseJReplica(uriParamsCC);
        }
        catalinaRequest.setWrapper((Wrapper)catalinaRequest.getMappingData().wrapper);
        if (!this.connector.getAllowTrace() && Method.TRACE.equals(grizzlyRequest.getMethod())) {
            String[] methods;
            Wrapper wrapper = catalinaRequest.getWrapper();
            Object header = null;
            if (wrapper != null && (methods = wrapper.getServletMethods()) != null) {
                for (String method : methods) {
                    if ("TRACE".equals(method)) continue;
                    header = header == null ? method : (String)header + ", " + method;
                }
            }
            grizzlyResponse.setStatus(405, "TRACE method is not allowed");
            grizzlyResponse.addHeader("Allow", header);
            return false;
        }
        DataChunk redirectPathMB = catalinaRequest.getMappingData().redirectPath;
        if (!(redirectPathMB.isNull() || catalinaContext.hasAdHocPaths() && catalinaContext.getAdHocServletName(catalinaRequest.getRequest().getServletPath()) != null)) {
            Object redirectPath = redirectPathMB.toString();
            String query = catalinaRequest.getQueryString();
            if (catalinaRequest.isRequestedSessionIdFromURL()) {
                redirectPath = (String)redirectPath + ";" + catalinaContext.getSessionParameterName() + "=" + catalinaRequest.getRequestedSessionId();
            }
            redirectPath = catalinaResponse.encode((String)redirectPath);
            if (query != null) {
                redirectPath = (String)redirectPath + "?" + query;
            }
            boolean authPassthroughEnabled = this.connector.getAuthPassthroughEnabled();
            ProxyHandler proxyHandler = this.connector.getProxyHandler();
            if (authPassthroughEnabled && proxyHandler != null && proxyHandler.getSSLKeysize(catalinaRequest.getRequest()) > 0) {
                catalinaRequest.setSecure(true);
            }
            if (InputValidationUtil.validateStringforCRLF((String)redirectPath)) {
                catalinaResponse.sendError(403, "Forbidden");
            } else {
                catalinaResponse.sendRedirect(InputValidationUtil.removeLinearWhiteSpaces((String)redirectPath), false);
            }
            return false;
        }
        catalinaRequest.parseSessionCookiesId();
        catalinaRequest.parseJrouteCookie();
        return true;
    }

    public static boolean normalize(DataChunk uriDataChunk, Response response) {
        DataChunk.Type type = uriDataChunk.getType();
        if (type == DataChunk.Type.Chars) {
            return CoyoteAdapter.normalizeChars(uriDataChunk, response);
        }
        return CoyoteAdapter.normalizeBytes(uriDataChunk, response);
    }

    private static boolean normalizeBytes(DataChunk uriDataChunk, Response response) {
        int end;
        ByteChunk uriBC = uriDataChunk.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        if (start == (end = uriBC.getEnd())) {
            response.setDetailMessage("Invalid URI: Empty URL");
            return false;
        }
        if (end - start == 1 && b[start] == 42) {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (b[pos] == 92) {
                if (ALLOW_BACKSLASH) {
                    b[pos] = 47;
                } else {
                    response.setDetailMessage("Invalid URI: Backslashes not allowed");
                    return false;
                }
            }
            if (b[pos] != 0) continue;
            response.setDetailMessage("Invalid URI: Null byte found during request normalization");
            return false;
        }
        if (b[start] != 47) {
            response.setDetailMessage("Invalid URI: Request must start with /");
            return false;
        }
        if (COLLAPSE_ADJACENT_SLASHES) {
            for (pos = start; pos < end - 1; ++pos) {
                if (b[pos] != 47) continue;
                while (pos + 1 < end && b[pos + 1] == 47) {
                    CoyoteAdapter.copyBytes(b, pos, pos + 1, end - pos - 1);
                    --end;
                }
            }
        }
        if (end - start > 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                response.setDetailMessage("Invalid URI: Request traversed outside of allowed context");
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (b[pos] != 47) continue;
                index2 = pos;
            }
            CoyoteAdapter.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        uriBC.setBytes(b, start, end);
        return true;
    }

    private static boolean normalizeChars(DataChunk uriDataChunk, Response response) {
        CharChunk uriCharChunk = uriDataChunk.getCharChunk();
        char[] c = uriCharChunk.getChars();
        int start = uriCharChunk.getStart();
        int end = uriCharChunk.getEnd();
        if (end - start == 1 && c[start] == '*') {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (c[pos] == '\\') {
                if (ALLOW_BACKSLASH) {
                    c[pos] = 47;
                } else {
                    response.setDetailMessage("Invalid URI: Backslashes not allowed");
                    return false;
                }
            }
            if (c[pos] != '\u0000') continue;
            response.setDetailMessage("Invalid URI: Null byte found during request normalization");
            return false;
        }
        if (c[start] != '/') {
            response.setDetailMessage("Invalid URI: Request must start with /");
            return false;
        }
        if (COLLAPSE_ADJACENT_SLASHES) {
            for (pos = start; pos < end - 1; ++pos) {
                if (c[pos] != '/') continue;
                while (pos + 1 < end && c[pos + 1] == '/') {
                    CoyoteAdapter.copyChars(c, pos, pos + 1, end - pos - 1);
                    --end;
                }
            }
        }
        if (end - start > 2 && c[end - 1] == '.' && (c[end - 2] == '/' || c[end - 2] == '.' && c[end - 3] == '/')) {
            c[end] = 47;
            ++end;
        }
        uriCharChunk.setEnd(end);
        index = 0;
        while ((index = uriCharChunk.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyChars(c, start + index, start + index + 2, end - start - index - 2);
            uriCharChunk.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriCharChunk.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                response.setDetailMessage("Invalid URI: Request traversed outside of allowed context");
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (c[pos] != '/') continue;
                index2 = pos;
            }
            CoyoteAdapter.copyChars(c, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriCharChunk.setEnd(end);
            index = index2;
        }
        uriCharChunk.setChars(c, start, end);
        return true;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            b[pos + dest] = b[pos + src];
        }
    }

    private static void copyChars(char[] c, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            c[pos + dest] = c[pos + src];
        }
    }

    protected void log(String message) {
        log.log(Level.INFO, message);
    }

    protected void log(String message, Throwable throwable) {
        log.log(Level.SEVERE, message, throwable);
    }

    public void fireAdapterEvent(String type, Object data) {
        if (this.connector != null && this.connector.getContainer() != null) {
            try {
                ((ContainerBase)this.connector.getContainer()).fireContainerEvent(type, data);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00037", t);
            }
        }
    }

    public boolean isCompatWithTomcat() {
        return this.compatWithTomcat;
    }

    public void setCompatWithTomcat(boolean compatWithTomcat) {
        this.compatWithTomcat = compatWithTomcat;
        this.serverName = compatWithTomcat ? "Apache/" + this.serverName : ServerInfo.getPublicServerInfo();
    }

    public int getPort() {
        return this.connector.getPort();
    }

    static final class CatalinaAfterServiceListener
    implements AfterServiceListener {
        CatalinaAfterServiceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAfterService(org.glassfish.grizzly.http.server.Request grizzlyRequest) {
            Request catalinaRequest = (Request)grizzlyRequest.getNote(CATALINA_REQUEST_NOTE);
            Response catalinaResponse = (Response)grizzlyRequest.getNote(CATALINA_RESPONSE_NOTE);
            if (catalinaRequest != null) {
                try {
                    if (!catalinaRequest.isUpgrade()) {
                        catalinaResponse.finishResponse();
                    } else {
                        catalinaResponse.setUpgrade(catalinaRequest.isUpgrade());
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "AS-WEB-CORE-00037", e);
                }
                finally {
                    try {
                        catalinaRequest.unlockSession();
                    }
                    finally {
                        catalinaRequest.recycle();
                        catalinaResponse.recycle();
                    }
                }
            }
        }
    }
}

