/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.faces.integration;

import com.sun.enterprise.container.common.spi.CDIService;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.AnnotationScanner;
import com.sun.faces.spi.DiscoverableInjectionProvider;
import com.sun.faces.spi.HighAvailabilityEnabler;
import com.sun.faces.spi.InjectionProviderException;
import com.sun.faces.util.FacesLogger;
import jakarta.servlet.ServletContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;

public class GlassFishInjectionProvider
extends DiscoverableInjectionProvider
implements AnnotationScanner,
HighAvailabilityEnabler {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String SERVICELOCATOR_ATTRIBUTE = "org.glassfish.servlet.habitat";
    private ComponentEnvManager componentEnvManager;
    private InjectionManager injectionManager;
    private InvocationManager invocationManager;
    private CDIService cdiService;

    public GlassFishInjectionProvider(ServletContext servletContext) {
        ServiceLocator defaultServices = (ServiceLocator)servletContext.getAttribute(SERVICELOCATOR_ATTRIBUTE);
        this.componentEnvManager = (ComponentEnvManager)defaultServices.getService(ComponentEnvManager.class, new Annotation[0]);
        this.invocationManager = (InvocationManager)defaultServices.getService(InvocationManager.class, new Annotation[0]);
        this.injectionManager = (InjectionManager)defaultServices.getService(InjectionManager.class, new Annotation[0]);
        this.cdiService = (CDIService)defaultServices.getService(CDIService.class, new Annotation[0]);
    }

    public Map<String, List<AnnotationScanner.ScannedAnnotation>> getAnnotatedClassesInCurrentModule(ServletContext servletContext) throws InjectionProviderException {
        DeploymentContext dc = (DeploymentContext)servletContext.getAttribute("com.sun.enterprise.web.WebModule.DeploymentContext");
        Types types = (Types)dc.getTransientAppMetaData(Types.class.getName(), Types.class);
        Collection allTypes = types.getAllTypes();
        Collection annotations = null;
        HashMap<String, List<AnnotationScanner.ScannedAnnotation>> classesByAnnotation = new HashMap<String, List<AnnotationScanner.ScannedAnnotation>>();
        ArrayList<1> classesWithThisAnnotation = null;
        for (final Type cur : allTypes) {
            annotations = cur.getAnnotations();
            AnnotationScanner.ScannedAnnotation toAdd = null;
            for (AnnotationModel curAnnotation : annotations) {
                String curAnnotationName = curAnnotation.getType().getName();
                classesWithThisAnnotation = (ArrayList<1>)classesByAnnotation.get(curAnnotationName);
                if (null == classesWithThisAnnotation) {
                    classesWithThisAnnotation = new ArrayList<1>();
                    classesByAnnotation.put(curAnnotationName, classesWithThisAnnotation);
                }
                if (classesWithThisAnnotation.contains(toAdd = new AnnotationScanner.ScannedAnnotation(){

                    public boolean equals(Object obj) {
                        String otherName;
                        boolean result = false;
                        if (obj instanceof AnnotationScanner.ScannedAnnotation && null != (otherName = ((AnnotationScanner.ScannedAnnotation)obj).getFullyQualifiedClassName())) {
                            result = cur.getName().equals(otherName);
                        }
                        return result;
                    }

                    public int hashCode() {
                        String str = this.getFullyQualifiedClassName();
                        Collection<URI> obj = this.getDefiningURIs();
                        int result = str != null ? str.hashCode() : 0;
                        result = 31 * result + (obj != null ? obj.hashCode() : 0);
                        return result;
                    }

                    public String getFullyQualifiedClassName() {
                        return cur.getName();
                    }

                    public Collection<URI> getDefiningURIs() {
                        return cur.getDefiningURIs();
                    }
                })) continue;
                classesWithThisAnnotation.add(toAdd);
            }
        }
        return classesByAnnotation;
    }

    public void inject(Object managedBean) throws InjectionProviderException {
        try {
            this.injectionManager.injectInstance(managedBean, this.getNamingEnvironment(), false);
            if (this.cdiService.isCurrentModuleCDIEnabled()) {
                this.cdiService.injectManagedObject(managedBean, this.getBundle());
            }
        }
        catch (InjectionException ie) {
            throw new InjectionProviderException((Throwable)ie);
        }
    }

    public void invokePreDestroy(Object managedBean) throws InjectionProviderException {
        try {
            this.injectionManager.invokeInstancePreDestroy(managedBean);
        }
        catch (InjectionException ie) {
            throw new InjectionProviderException((Throwable)ie);
        }
    }

    public void invokePostConstruct(Object managedBean) throws InjectionProviderException {
        try {
            this.invokePostConstruct(managedBean, this.getNamingEnvironment());
        }
        catch (InjectionException ie) {
            throw new InjectionProviderException((Throwable)ie);
        }
    }

    private JndiNameEnvironment getNamingEnvironment() throws InjectionException {
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        if (currentInvocation == null) {
            throw new InjectionException("null invocation context");
        }
        if (currentInvocation.getInvocationType() != ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION) {
            throw new InjectionException("Wrong invocation type");
        }
        JndiNameEnvironment componentEnv = (JndiNameEnvironment)currentInvocation.jndiEnvironment;
        if (componentEnv != null) {
            return componentEnv;
        }
        throw new InjectionException("No descriptor registered for  current invocation : " + String.valueOf(currentInvocation));
    }

    private void invokePostConstruct(Object instance, JndiNameEnvironment envDescriptor) throws InjectionException {
        LinkedList<Method> postConstructMethods = new LinkedList<Method>();
        for (Class<?> nextClass = instance.getClass(); !Object.class.equals(nextClass) && nextClass != null; nextClass = nextClass.getSuperclass()) {
            InjectionInfo injInfo = envDescriptor.getInjectionInfoByClass(nextClass);
            if (injInfo.getPostConstructMethodName() == null) continue;
            Method postConstructMethod = this.getPostConstructMethod(injInfo, nextClass);
            postConstructMethods.addFirst(postConstructMethod);
        }
        for (Method postConstructMethod : postConstructMethods) {
            this.invokeLifecycleMethod(postConstructMethod, instance);
        }
    }

    private Method getPostConstructMethod(InjectionInfo injectionInfo, Class<? extends Object> resourceClass) throws InjectionException {
        Method postConstructMethod = injectionInfo.getPostConstructMethod();
        if (postConstructMethod == null) {
            String postConstructMethodName = injectionInfo.getPostConstructMethodName();
            for (Method next : resourceClass.getDeclaredMethods()) {
                if (!next.getName().equals(postConstructMethodName) || next.getParameterTypes().length != 0) continue;
                postConstructMethod = next;
                injectionInfo.setPostConstructMethod(postConstructMethod);
                break;
            }
        }
        if (postConstructMethod == null) {
            throw new InjectionException("InjectionManager exception. PostConstruct method " + injectionInfo.getPostConstructMethodName() + " could not be found in class " + injectionInfo.getClassName());
        }
        return postConstructMethod;
    }

    private void invokeLifecycleMethod(final Method lifecycleMethod, final Object instance) throws InjectionException {
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Calling lifecycle method " + String.valueOf(lifecycleMethod) + " on class " + String.valueOf(lifecycleMethod.getDeclaringClass()));
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    if (!lifecycleMethod.trySetAccessible()) {
                        throw new InaccessibleObjectException("Unable to make accessible: " + String.valueOf(lifecycleMethod));
                    }
                    lifecycleMethod.invoke(instance, new Object[0]);
                    return null;
                }
            });
        }
        catch (Exception t) {
            String msg = "Exception attempting invoke lifecycle  method " + String.valueOf(lifecycleMethod);
            LOGGER.log(Level.FINE, msg, t);
            InjectionException ie = new InjectionException(msg);
            Throwable cause = t instanceof InvocationTargetException ? t.getCause() : t;
            ie.initCause(cause);
            throw ie;
        }
    }

    private BundleDescriptor getBundle() {
        JndiNameEnvironment env = this.componentEnvManager.getCurrentJndiNameEnvironment();
        BundleDescriptor bundle = null;
        if (env instanceof BundleDescriptor) {
            bundle = (BundleDescriptor)env;
        }
        if (bundle == null) {
            throw new IllegalStateException("Invalid context for managed bean creation");
        }
        return bundle;
    }

    public void enableHighAvailability(ServletContext ctx) {
        WebConfiguration config = WebConfiguration.getInstance((ServletContext)ctx);
        if (!config.isSet(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable)) {
            Object isDistributableObj = ctx.getAttribute("com.sun.enterprise.web.WebModule.isDistributable");
            Object enableHAObj = ctx.getAttribute("com.sun.enterprise.web.WebModule.enableHA");
            if (isDistributableObj instanceof Boolean && enableHAObj instanceof Boolean) {
                boolean isDistributable = (Boolean)isDistributableObj;
                boolean enableHA = (Boolean)enableHAObj;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "isDistributable = {0} enableHA = {1}", new Object[]{isDistributable, enableHA});
                }
                if (isDistributable && enableHA) {
                    LOGGER.fine("setting the EnableAgressiveSessionDirtying to true");
                    config.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable, Boolean.TRUE.booleanValue());
                }
            }
        }
    }
}

