/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.deserializer;

import jakarta.json.stream.JsonParser;
import org.eclipse.yasson.internal.DeserializationContextImpl;
import org.eclipse.yasson.internal.deserializer.ModelDeserializer;

public class NullCheckDeserializer
implements ModelDeserializer<JsonParser> {
    private final ModelDeserializer<JsonParser> nonNullDeserializer;
    private final ModelDeserializer<Object> nullDeserializer;

    public NullCheckDeserializer(ModelDeserializer<JsonParser> nonNullDeserializer, ModelDeserializer<Object> nullDeserializer) {
        this.nonNullDeserializer = nonNullDeserializer;
        this.nullDeserializer = nullDeserializer;
    }

    @Override
    public Object deserialize(JsonParser value, DeserializationContextImpl context) {
        if (context.getLastValueEvent() != JsonParser.Event.VALUE_NULL) {
            return this.nonNullDeserializer.deserialize(value, context);
        }
        return this.nullDeserializer.deserialize(null, context);
    }

    public String toString() {
        return "Null value check";
    }
}

