/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.SecureAdminHelper;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.security.SecurityUpgradeService;
import com.sun.enterprise.security.admin.cli.EnableSecureAdminCommand;
import com.sun.enterprise.security.admin.cli.SecureAdminUpgradeHelper;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.net.NetUtils;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.config.support.GrizzlyConfigSchemaMigrator;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.main.jdke.security.KeyTool;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class SecureAdminConfigUpgrade
extends SecureAdminUpgradeHelper
implements ConfigurationUpgrade,
PostConstruct {
    private static final Logger LOG = Logger.getLogger(SecureAdminConfigUpgrade.class.getName());
    private static final String ADMIN_LISTENER_NAME = "admin-listener";
    private static final String ASADMIN_LISTENER_PORT = "${ASADMIN_LISTENER_PORT}";
    private static final String ASADMIN_LISTENER_TRANSPORT = "tcp";
    private static final String ASADMIN_LISTENER_THREADPOOL = "http-thread-pool";
    private static final String ASADMIN_VS_NAME = "__asadmin";
    private static final String CERTIFICATE_DN_PREFIX = "CN=";
    private static final String CERTIFICATE_DN_SUFFIX = ",OU=GlassFish,O=Eclipse Foundation";
    private static final String INSTANCE_CN_SUFFIX = "-instance";
    @Inject
    private GrizzlyConfigSchemaMigrator grizzlyMigrator;
    @Inject
    private SecurityUpgradeService securityUpgradeService;
    @Inject
    private Configs configs;
    @Inject
    private ServerEnvironment serverEnv;
    private final Map<String, Config> writableConfigs = new HashMap<String, Config>();

    public void postConstruct() {
        String stage = null;
        try {
            stage = "adding admin-listener to non-DAS configuration";
            this.ensureNonDASConfigsHaveAdminNetworkListener();
            LOG.log(Level.INFO, "Added admin-listener network listeners to non-DAS configurations");
            stage = "upgrading config for secure DAS-to-instance admin traffic";
            this.setupNewDefaultConfig();
            if (this.requiresSecureAdmin()) {
                EnableSecureAdminCommand enableSecureAdminCommand = (EnableSecureAdminCommand)this.habitat.getService(EnableSecureAdminCommand.class, new Annotation[0]);
                stage = "upgrading secure admin set-up";
                try {
                    enableSecureAdminCommand.run();
                    LOG.log(Level.INFO, "Upgraded secure admin set-up");
                }
                catch (SecureAdminHelper.SecureAdminCommandException ex) {
                    LOG.log(Level.INFO, "Attempt to upgrade secure admin set-up failed", ex);
                    throw ex;
                }
            } else {
                LOG.log(Level.INFO, "No secure admin set-up was detected in the original configuration so no upgrade of it was needed");
            }
            this.commit();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error " + stage, ex);
            this.rollback();
        }
    }

    private void setupNewDefaultConfig() throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, ProcessManagerException, TransactionFailure {
        this.ensureKeyPairForInstanceAlias();
        this.ensureSecureAdminReady();
        this.prepareDASConfig();
    }

    private boolean requiresSecureAdmin() {
        return this.isOriginalAdminSecured() || this.securityUpgradeService.requiresSecureAdmin();
    }

    private void prepareDASConfig() throws TransactionFailure {
        Config dasConfig = this.writableConfig(this.configs.getConfigByName("server-config"));
        NetworkConfig nc = dasConfig.getNetworkConfig();
        NetworkListener nl_w = (NetworkListener)this.transaction().enroll((ConfigBeanProxy)nc.getNetworkListener(ADMIN_LISTENER_NAME));
        nl_w.setProtocol(ADMIN_LISTENER_NAME);
    }

    private void ensureConfigReady(Config c, String adminListenerProtocol) throws TransactionFailure, PropertyVetoException {
        NetworkConfig nc = c.getNetworkConfig();
        NetworkListener nl = nc.getNetworkListener(ADMIN_LISTENER_NAME);
        if (nl != null) {
            return;
        }
        Config config_w = this.writableConfig(c);
        this.createAdminNetworkListener(this.transaction(), nc, adminListenerProtocol);
        this.createAdminVirtualServer(this.transaction(), config_w);
    }

    private Config writableConfig(Config c) throws TransactionFailure {
        Config result = this.writableConfigs.get(c.getName());
        if (result == null) {
            result = (Config)this.transaction().enroll((ConfigBeanProxy)c);
            this.writableConfigs.put(c.getName(), result);
        }
        return result;
    }

    private void ensureNonDASConfigsHaveAdminNetworkListener() throws TransactionFailure, PropertyVetoException {
        for (Config c : this.configs.getConfig()) {
            if (c.getName().equals("server-config")) continue;
            this.ensureConfigReady(c, "pu-protocol");
        }
    }

    private NetworkListener createAdminNetworkListener(Transaction t, NetworkConfig nc, String adminListenerProtocolName) throws TransactionFailure {
        NetworkListeners nls_w = (NetworkListeners)t.enroll((ConfigBeanProxy)nc.getNetworkListeners());
        NetworkListener nl_w = (NetworkListener)nls_w.createChild(NetworkListener.class);
        nls_w.getNetworkListener().add(nl_w);
        nl_w.setName(ADMIN_LISTENER_NAME);
        nl_w.setProtocol(adminListenerProtocolName);
        nl_w.setPort(ASADMIN_LISTENER_PORT);
        nl_w.setTransport(ASADMIN_LISTENER_TRANSPORT);
        nl_w.setThreadPool(ASADMIN_LISTENER_THREADPOOL);
        return nl_w;
    }

    private VirtualServer createAdminVirtualServer(Transaction t, Config config_w) throws TransactionFailure, PropertyVetoException {
        HttpService hs_w = (HttpService)t.enroll((ConfigBeanProxy)config_w.getHttpService());
        VirtualServer vs_w = (VirtualServer)hs_w.createChild(VirtualServer.class);
        hs_w.getVirtualServer().add(vs_w);
        vs_w.setId(ASADMIN_VS_NAME);
        vs_w.setNetworkListeners(ADMIN_LISTENER_NAME);
        return vs_w;
    }

    private boolean isOriginalAdminSecured() {
        Config serverConfig = this.configs.getConfigByName("server-config");
        if (serverConfig == null) {
            return false;
        }
        NetworkConfig nc = serverConfig.getNetworkConfig();
        if (nc == null) {
            return false;
        }
        Protocol p = nc.findProtocol(ADMIN_LISTENER_NAME);
        if (p == null) {
            return false;
        }
        return p.getSsl() != null;
    }

    private void ensureKeyPairForInstanceAlias() throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, ProcessManagerException {
        KeyStore ks = this.sslUtils().getKeyStore();
        if (ks.containsAlias("glassfish-instance")) {
            return;
        }
        File keyStoreFile = this.serverEnv.getJKS();
        File trustStoreFile = new File(this.serverEnv.getConfigDirPath(), "cacerts.p12");
        String pw = this.masterPassword();
        KeyTool keyTool = new KeyTool(keyStoreFile, pw.toCharArray());
        keyTool.generateKeyPair("glassfish-instance", this.getCertificateDN(), "RSA", 3650);
        keyTool.copyCertificate("glassfish-instance", trustStoreFile);
        this.reload(this.sslUtils().getKeyStore(), keyStoreFile, pw);
        this.reload(this.sslUtils().getTrustStore(), this.serverEnv.getTrustStore(), pw);
    }

    private void reload(KeyStore keystore, File keystoreFile, String pw) throws FileNotFoundException, IOException, NoSuchAlgorithmException, CertificateException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(keystoreFile));){
            keystore.load(is, pw.toCharArray());
        }
    }

    private String masterPassword() throws IOException {
        String masterPWFromPWFile;
        String pwFileArg = this.startupArg("-passwordfile");
        if (pwFileArg != null && (masterPWFromPWFile = this.pwProps(pwFileArg).getProperty("AS_ADMIN_MASTERPASSWORD")) != null) {
            return masterPWFromPWFile;
        }
        return "changeit";
    }

    private Properties pwProps(String pwFilePath) throws IOException {
        Properties result = new Properties();
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(pwFilePath));){
            result.load(is);
        }
        return result;
    }

    private String getCertificateDN() {
        String cn;
        try {
            cn = NetUtils.getCanonicalHostName();
        }
        catch (Exception e) {
            cn = "localhost";
        }
        return CERTIFICATE_DN_PREFIX + cn + "-instance,OU=GlassFish,O=Eclipse Foundation";
    }
}

