/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.solaris;

import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.exceptions.BadRealmException;
import com.sun.enterprise.security.auth.realm.exceptions.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.exceptions.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.exceptions.NoSuchUserException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.jvnet.hk2.annotations.Service;

@Service
public final class SolarisRealm
extends Realm {
    public static final String AUTH_TYPE = "solaris";
    public static final String OS_ARCH = "os.arch";
    public static final String SOL_SPARC_OS_ARCH = "sparc";
    public static final String SOL_X86_OS_ARCH = "x86";
    private HashMap groupCache;
    private Vector emptyVector;
    private static String osArchType = System.getProperty("os.arch");

    @Override
    public synchronized void init(Properties props) throws BadRealmException, NoSuchRealmException {
        super.init(props);
        String jaasCtx = props.getProperty("jaas-context");
        if (jaasCtx == null) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.warning("realmconfig.noctx");
            }
            throw new BadRealmException("Solaris realm jaas-context not set.");
        }
        this.setProperty("jaas-context", jaasCtx);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("SolarisRealm : jaas-context=" + jaasCtx);
        }
        this.groupCache = new HashMap();
        this.emptyVector = new Vector();
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE;
    }

    public Enumeration getGroupNames(String username) throws InvalidOperationException, NoSuchUserException {
        Vector v = (Vector)this.groupCache.get(username);
        if (v == null) {
            v = this.loadGroupNames(username);
        }
        return v.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGroupNames(String username, String[] groups) {
        Vector<String> v = null;
        if (groups == null) {
            v = this.emptyVector;
        } else {
            v = new Vector<String>(groups.length + 1);
            for (int i = 0; i < groups.length; ++i) {
                v.add(groups[i]);
            }
        }
        SolarisRealm solarisRealm = this;
        synchronized (solarisRealm) {
            this.groupCache.put(username, v);
        }
    }

    public String[] authenticate(String username, char[] password) {
        String[] grps = SolarisRealm.nativeAuthenticate(username, new String(password));
        if (grps != null) {
            grps = this.addAssignGroups(grps);
        }
        this.setGroupNames(username, grps);
        return grps;
    }

    private Vector loadGroupNames(String username) {
        String[] grps = SolarisRealm.nativeGetGroups(username);
        if (grps == null) {
            _logger.fine("No groups returned for user: " + username);
        }
        grps = this.addAssignGroups(grps);
        this.setGroupNames(username, grps);
        return (Vector)this.groupCache.get(username);
    }

    private static native String[] nativeAuthenticate(String var0, String var1);

    private static native String[] nativeGetGroups(String var0);

    static {
        if (SOL_SPARC_OS_ARCH.equals(osArchType)) {
            System.loadLibrary("solsparcauth");
        } else if (SOL_X86_OS_ARCH.equals(osArchType)) {
            System.loadLibrary("solx86auth");
        }
    }
}

