/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.compiler;

import jakarta.servlet.ServletContext;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.glassfish.wasp.WaspException;
import org.glassfish.wasp.compiler.ErrorDispatcher;
import org.glassfish.wasp.compiler.JspUtil;
import org.glassfish.wasp.compiler.Node;
import org.glassfish.wasp.compiler.PageInfo;
import org.glassfish.wasp.compiler.tagplugin.TagPlugin;
import org.glassfish.wasp.compiler.tagplugin.TagPluginContext;
import org.glassfish.wasp.xmlparser.ParserUtils;
import org.glassfish.wasp.xmlparser.TreeNode;

public class TagPluginManager {
    private static final String TAG_PLUGINS_XML = "/WEB-INF/tagPlugins.xml";
    private static final String TAG_PLUGINS_ROOT_ELEM = "tag-plugins";
    private boolean initialized = false;
    private HashMap<String, TagPlugin> tagPlugins = null;
    private ServletContext ctxt;
    private PageInfo pageInfo;

    public TagPluginManager(ServletContext ctxt) {
        this.ctxt = ctxt;
    }

    public void apply(Node.Nodes page, ErrorDispatcher err, PageInfo pageInfo) throws WaspException {
        this.init(err);
        if (this.tagPlugins == null || this.tagPlugins.size() == 0) {
            return;
        }
        this.pageInfo = pageInfo;
        page.visit(new Node.Visitor(){

            @Override
            public void visit(Node.CustomTag n) throws WaspException {
                TagPluginManager.this.invokePlugin(n);
                this.visitBody(n);
            }
        });
    }

    private void init(ErrorDispatcher err) throws WaspException {
        if (this.initialized) {
            return;
        }
        InputStream is = this.ctxt.getResourceAsStream(TAG_PLUGINS_XML);
        if (is == null) {
            return;
        }
        boolean blockExternal = Boolean.parseBoolean(this.ctxt.getInitParameter("org.glassfish.wasp.XML_BLOCK_EXTERNAL"));
        TreeNode root = new ParserUtils(blockExternal).parseXMLDocument(TAG_PLUGINS_XML, is);
        if (root == null) {
            return;
        }
        if (!TAG_PLUGINS_ROOT_ELEM.equals(root.getName())) {
            err.jspError("jsp.error.plugin.wrongRootElement", TAG_PLUGINS_XML, TAG_PLUGINS_ROOT_ELEM);
        }
        this.tagPlugins = new HashMap();
        Iterator<TreeNode> pluginList = root.findChildren("tag-plugin");
        while (pluginList.hasNext()) {
            TreeNode pluginNode = pluginList.next();
            TreeNode tagClassNode = pluginNode.findChild("tag-class");
            if (tagClassNode == null) {
                return;
            }
            String tagClass = tagClassNode.getBody().trim();
            TreeNode pluginClassNode = pluginNode.findChild("plugin-class");
            if (pluginClassNode == null) {
                return;
            }
            String pluginClassStr = pluginClassNode.getBody();
            TagPlugin tagPlugin = null;
            try {
                Class<TagPlugin> pluginClass = Class.forName(pluginClassStr).asSubclass(TagPlugin.class);
                tagPlugin = pluginClass.newInstance();
            }
            catch (Exception e) {
                throw new WaspException(e);
            }
            if (tagPlugin == null) {
                return;
            }
            this.tagPlugins.put(tagClass, tagPlugin);
        }
        this.initialized = true;
    }

    private void invokePlugin(Node.CustomTag n) {
        TagPlugin tagPlugin = this.tagPlugins.get(n.getTagHandlerClass().getName());
        if (tagPlugin == null) {
            return;
        }
        TagPluginContextImpl tagPluginContext = new TagPluginContextImpl(n, this.pageInfo);
        n.setTagPluginContext(tagPluginContext);
        tagPlugin.doTag(tagPluginContext);
    }

    static class TagPluginContextImpl
    implements TagPluginContext {
        private Node.CustomTag node;
        private Node.Nodes curNodes;
        private PageInfo pageInfo;
        private HashMap<String, Object> pluginAttributes;

        TagPluginContextImpl(Node.CustomTag n, PageInfo pageInfo) {
            this.node = n;
            this.pageInfo = pageInfo;
            this.curNodes = new Node.Nodes();
            n.setAtETag(this.curNodes);
            this.curNodes = new Node.Nodes();
            n.setAtSTag(this.curNodes);
            n.setUseTagPlugin(true);
            this.pluginAttributes = new HashMap();
        }

        @Override
        public TagPluginContext getParentContext() {
            Node parent = this.node.getParent();
            if (!(parent instanceof Node.CustomTag)) {
                return null;
            }
            return ((Node.CustomTag)parent).getTagPluginContext();
        }

        @Override
        public void setPluginAttribute(String key, Object value) {
            this.pluginAttributes.put(key, value);
        }

        @Override
        public Object getPluginAttribute(String key) {
            return this.pluginAttributes.get(key);
        }

        @Override
        public boolean isScriptless() {
            return this.node.getChildInfo().isScriptless();
        }

        @Override
        public boolean isConstantAttribute(String attribute) {
            Node.JspAttribute attr = this.getNodeAttribute(attribute);
            if (attr == null) {
                return false;
            }
            return attr.isLiteral();
        }

        @Override
        public String getConstantAttribute(String attribute) {
            Node.JspAttribute attr = this.getNodeAttribute(attribute);
            if (attr == null) {
                return null;
            }
            return attr.getValue();
        }

        @Override
        public boolean isAttributeSpecified(String attribute) {
            return this.getNodeAttribute(attribute) != null;
        }

        @Override
        public String getTemporaryVariableName() {
            return JspUtil.nextTemporaryVariableName();
        }

        @Override
        public void generateImport(String imp) {
            this.pageInfo.addImport(imp);
        }

        @Override
        public void generateDeclaration(String id, String text) {
            if (this.pageInfo.isPluginDeclared(id)) {
                return;
            }
            this.curNodes.add(new Node.Declaration(text, this.node.getStart(), null));
        }

        @Override
        public void generateJavaSource(String sourceCode) {
            this.curNodes.add(new Node.Scriptlet(sourceCode, this.node.getStart(), null));
        }

        @Override
        public void generateAttribute(String attributeName) {
            this.curNodes.add(new Node.AttributeGenerator(this.node.getStart(), attributeName, this.node));
        }

        @Override
        public void dontUseTagPlugin() {
            this.node.setUseTagPlugin(false);
        }

        @Override
        public void generateBody() {
            this.curNodes = this.node.getAtETag();
        }

        private Node.JspAttribute getNodeAttribute(String attribute) {
            Node.JspAttribute[] attrs = this.node.getJspAttributes();
            for (int i = 0; attrs != null && i < attrs.length; ++i) {
                if (!attrs[i].getName().equals(attribute)) continue;
                return attrs[i];
            }
            return null;
        }
    }
}

