/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats;

import com.sun.enterprise.admin.monitor.stats.BoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.StatisticImpl;
import org.glassfish.j2ee.statistics.BoundedRangeStatistic;
import org.glassfish.j2ee.statistics.Statistic;

public class MutableBoundedRangeStatisticImpl
implements BoundedRangeStatistic,
MutableCountStatistic {
    private final BoundedRangeStatistic initial;
    private long current;
    private long lastSampleTime;
    private long startTime;
    private long lowWaterMark;
    private long highWaterMark;

    public MutableBoundedRangeStatisticImpl(BoundedRangeStatistic initial) {
        this.initial = initial;
        this.current = initial.getCurrent();
        this.lastSampleTime = initial.getLastSampleTime();
        this.startTime = initial.getStartTime();
        this.lowWaterMark = initial.getLowWaterMark();
        this.highWaterMark = initial.getHighWaterMark();
    }

    @Override
    public void reset() {
        this.current = this.initial.getCurrent();
        this.startTime = this.lastSampleTime = System.currentTimeMillis();
        this.highWaterMark = this.initial.getHighWaterMark();
        this.lowWaterMark = this.initial.getLowWaterMark();
    }

    @Override
    public void setCount(long current) {
        this.current = current;
        this.lastSampleTime = System.currentTimeMillis();
        this.lowWaterMark = current < this.lowWaterMark ? current : this.lowWaterMark;
        this.highWaterMark = current > this.highWaterMark ? current : this.highWaterMark;
        this.lastSampleTime = System.currentTimeMillis();
    }

    @Override
    public Statistic unmodifiableView() {
        return new BoundedRangeStatisticImpl(this.current, this.highWaterMark, this.lowWaterMark, this.initial.getUpperBound(), this.initial.getLowerBound(), this.initial.getName(), this.initial.getUnit(), this.initial.getDescription(), this.startTime, this.lastSampleTime);
    }

    @Override
    public String getDescription() {
        return this.initial.getDescription();
    }

    @Override
    public long getLastSampleTime() {
        return this.lastSampleTime;
    }

    @Override
    public String getName() {
        return this.initial.getName();
    }

    @Override
    public long getStartTime() {
        return this.initial.getStartTime();
    }

    @Override
    public String getUnit() {
        return this.initial.getUnit();
    }

    @Override
    public Statistic modifiableView() {
        return this;
    }

    @Override
    public long getCurrent() {
        return this.current;
    }

    @Override
    public long getHighWaterMark() {
        return this.highWaterMark;
    }

    @Override
    public long getLowWaterMark() {
        return this.lowWaterMark;
    }

    @Override
    public long getLowerBound() {
        return this.initial.getLowerBound();
    }

    @Override
    public long getUpperBound() {
        return this.initial.getUpperBound();
    }

    public void setDescription(String s) {
        try {
            ((StatisticImpl)((Object)this.initial)).setDescription(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

