/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.RuntimeAnnotationHandler;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public abstract class JndiHandler
implements RuntimeAnnotationHandler {
    private static final Logger LOGGER = Logger.getLogger(JndiHandler.class.getName());
    protected static final String JAVA_COMP_ENV = "java:comp/env/";

    public Object lookup(FacesContext facesContext, String name) {
        Object object;
        block3: {
            object = null;
            try {
                InitialContext context = new InitialContext();
                object = context.lookup(name);
            }
            catch (NamingException ne) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to lookup: " + name, ne);
                }
                if (!facesContext.isProjectStage(ProjectStage.Development)) break block3;
                facesContext.addMessage(null, new FacesMessage("Unable to lookup: " + name, "Unable to lookup: " + name));
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setField(FacesContext facesContext, Field field, Object instance, Object value) {
        Object object = instance;
        synchronized (object) {
            block8: {
                try {
                    boolean fieldAccessible = true;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                        fieldAccessible = false;
                    }
                    field.set(instance, value);
                    if (!fieldAccessible) {
                        field.setAccessible(false);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException iae) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "Unable to set field: " + field.getName(), iae);
                    }
                    if (!facesContext.isProjectStage(ProjectStage.Development)) break block8;
                    facesContext.addMessage(null, new FacesMessage("Unable to set field: " + field.getName(), "Unable to set field: " + field.getName()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeMethod(FacesContext facesContext, Method method, Object instance, Object value) {
        Object object = instance;
        synchronized (object) {
            block6: {
                try {
                    boolean accessible = method.isAccessible();
                    method.setAccessible(false);
                    method.invoke(instance, value);
                    method.setAccessible(accessible);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ite) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "Unable to call method: " + method.getName(), ite);
                    }
                    if (!facesContext.isProjectStage(ProjectStage.Development)) break block6;
                    facesContext.addMessage(null, new FacesMessage("Unable to call method: " + method.getName(), "Unable to call method: " + method.getName()));
                }
            }
        }
    }
}

