/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.apf.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.apf.ComponentInfo;

public class ComponentDefinition
implements ComponentInfo {
    private static final Set<String> EXCLUDED_FROM_ANNOTATION_PROCESSING = Collections.unmodifiableSet(new HashSet<String>(Set.of("jakarta.servlet.GenericServlet", "jakarta.servlet.http.HttpServlet", "org.glassfish.wasp.servlet.JspServlet", "org.apache.catalina.servlets.DefaultServlet")));
    private final Class<?> clazz;
    private final List<Constructor<?>> constructors = new ArrayList();
    private final List<Class<?>> classes = new ArrayList();
    private final List<Field> fields = new ArrayList<Field>();
    private final Map<MethodKey, Method> methodMap = new HashMap<MethodKey, Method>();

    public ComponentDefinition(Class<?> clazz) {
        this.clazz = clazz;
        this.constructClassList();
        this.initializeConstructors();
        this.initializeFields();
        this.initializeMethods();
    }

    @Override
    public Field[] getFields() {
        return (Field[])this.fields.toArray(Field[]::new);
    }

    @Override
    public Method[] getMethods() {
        return (Method[])this.methodMap.values().toArray(Method[]::new);
    }

    @Override
    public Constructor<?>[] getConstructors() {
        return (Constructor[])this.constructors.toArray(Constructor[]::new);
    }

    private void constructClassList() {
        if (!ComponentDefinition.isExcludedFromAnnotationProcessing(this.clazz)) {
            this.classes.add(this.clazz);
        }
        Class<?> parent = this.clazz;
        while ((parent = parent.getSuperclass()) != null) {
            if (ComponentDefinition.isExcludedFromAnnotationProcessing(parent)) continue;
            this.classes.add(0, parent);
        }
    }

    private void initializeConstructors() {
        for (Class<?> cl : this.classes) {
            for (Constructor<?> constr : cl.getConstructors()) {
                this.constructors.add(constr);
            }
        }
    }

    private void initializeFields() {
        for (Class<?> cl : this.classes) {
            for (Field f : cl.getDeclaredFields()) {
                this.fields.add(f);
            }
        }
    }

    private void initializeMethods() {
        for (Class<?> cl : this.classes) {
            for (Method method : cl.getDeclaredMethods()) {
                if (method.isBridge()) continue;
                this.methodMap.put(new MethodKey(method), method);
            }
        }
    }

    static boolean isExcludedFromAnnotationProcessing(Class<?> clazz) {
        if (clazz.getPackage() == null) {
            return false;
        }
        if (clazz.getPackage().getName().startsWith("java.lang")) {
            return true;
        }
        return EXCLUDED_FROM_ANNOTATION_PROCESSING.contains(clazz.getCanonicalName());
    }

    private static class MethodKey {
        private final Method m;
        private final Package classPackage;
        private final String className;
        private final int hashCode;

        private MethodKey(Method m) {
            this.m = m;
            this.className = m.getDeclaringClass().getName();
            this.classPackage = m.getDeclaringClass().getPackage();
            this.hashCode = m.getName().hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodKey)) {
                return false;
            }
            MethodKey mk2 = (MethodKey)o;
            Method m2 = mk2.m;
            if (this.m.getName().equals(m2.getName()) && Arrays.equals(this.m.getParameterTypes(), m2.getParameterTypes())) {
                int modifiers2 = m2.getModifiers();
                boolean isSamePackage = this.hasSamePackage(mk2);
                if (Modifier.isPrivate(this.m.getModifiers())) {
                    return Modifier.isPrivate(modifiers2) && isSamePackage && this.className.equals(mk2.className);
                }
                return Modifier.isPublic(modifiers2) || Modifier.isProtected(modifiers2) || MethodKey.isPackageProtected(modifiers2) && isSamePackage;
            }
            return false;
        }

        private boolean hasSamePackage(MethodKey mk2) {
            if (this.classPackage == mk2.classPackage) {
                return true;
            }
            return this.classPackage != null && mk2.classPackage != null && this.classPackage.getName().equals(mk2.classPackage.getName());
        }

        private static boolean isPackageProtected(int modifiers) {
            return !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPrivate(modifiers);
        }
    }
}

