/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.apf.impl;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.ErrorHandler;
import org.glassfish.apf.impl.AnnotationUtils;

public class DefaultErrorHandler
implements ErrorHandler {
    private final Logger logger = AnnotationUtils.getLogger();

    @Override
    public void fine(AnnotationProcessorException ape) throws AnnotationProcessorException {
        if (this.logger.isLoggable(Level.FINE)) {
            AnnotationInfo info = ape.getAnnotationInfo();
            if (info == null) {
                this.logger.fine(ape.getMessage());
            } else {
                this.logger.fine(MessageFormat.format("{2}\n symbol: {0}\n location: {1}\n\n", new Object[]{info.getElementType(), info.getAnnotatedElement(), ape.getMessage()}));
            }
        }
    }

    @Override
    public void warning(AnnotationProcessorException ape) throws AnnotationProcessorException {
        if (this.logger.isLoggable(Level.WARNING)) {
            AnnotationInfo info = ape.getAnnotationInfo();
            if (info == null) {
                this.logger.warning(ape.getMessage());
            } else {
                this.logger.warning(MessageFormat.format("{2}\n symbol: {0}\n location: {1}\n\n", new Object[]{info.getElementType(), info.getAnnotatedElement(), ape.getMessage()}));
            }
        }
    }

    @Override
    public void error(AnnotationProcessorException ape) throws AnnotationProcessorException {
        AnnotationInfo info = ape.getAnnotationInfo();
        if (info == null) {
            this.logger.severe(ape.getMessage());
        } else {
            this.logger.severe(MessageFormat.format("{2}\n symbol: {0} location: {1}\n\n", new Object[]{info.getElementType(), info.getAnnotatedElement(), ape.getMessage()}));
        }
    }
}

