/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.plugin.hwlb;

import com.sun.corba.ee.impl.misc.ORBUtility;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;

public class RetryClientRequestInterceptor
extends LocalObject
implements ORBInitializer,
ClientRequestInterceptor {
    private static final String baseMsg = RetryClientRequestInterceptor.class.getName();
    private static final String TRANSIENT_REPOSITORY_ID = "IDL:omg.org/CORBA/TRANSIENT:1.0";
    private static final String OBJECT_NOT_EXIST_REPOSITORY_ID = "IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0";
    private static final long INITIAL_BACKOFF_DEFAULT = 500L;
    private static long initialBackoff = 500L;
    private static final long TRANSIENT_RETRY_TIMEOUT_DEFAULT = 300000L;
    private static long transientRetryTimeout = 300000L;
    private static boolean debug = true;
    private ThreadLocal backoffAndStartTime = new ThreadLocal(){

        protected Object initialValue() {
            return new BackoffAndStartTime();
        }
    };

    private long getStartTime() {
        return ((BackoffAndStartTime)this.backoffAndStartTime.get()).startTime;
    }

    private void setStartTime(long x) {
        ((BackoffAndStartTime)this.backoffAndStartTime.get()).startTime = x;
    }

    private long getBackoff() {
        return ((BackoffAndStartTime)this.backoffAndStartTime.get()).backoff;
    }

    private void setBackoff(long x) {
        ((BackoffAndStartTime)this.backoffAndStartTime.get()).backoff = x;
    }

    private void doubleBackoff() {
        this.setBackoff(this.getBackoff() * 2L);
    }

    public static void setInitialBackoff(long x) {
        initialBackoff = x;
    }

    public static long getInitialBackoff() {
        return initialBackoff;
    }

    public static void setTransientRetryTimeout(long x) {
        transientRetryTimeout = x;
    }

    public static long getTransientRetryTimeout() {
        return transientRetryTimeout;
    }

    public static void setDebug(boolean x) {
        debug = x;
    }

    public String name() {
        return baseMsg;
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo ri) {
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
        this.setBackoff(initialBackoff);
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        if (!this.isTransientException(ri) && !this.isBadServerIdException(ri)) {
            this.setBackoff(initialBackoff);
            return;
        }
        String msg = ".receive_exception: " + ri.received_exception_id() + " " + ri.operation() + ": ";
        if (this.getBackoff() == initialBackoff) {
            if (debug) {
                System.out.println(msg + "initializing timer");
            }
            this.setStartTime(System.currentTimeMillis());
        } else if (System.currentTimeMillis() - this.getStartTime() >= transientRetryTimeout) {
            if (debug) {
                System.out.println(msg + "exceeded transientRetryTimeout: " + transientRetryTimeout + " - not retrying");
            }
            return;
        }
        this.doubleBackoff();
        if (debug) {
            System.out.println(msg + "sleep: " + this.getBackoff());
        }
        try {
            Thread.sleep(this.getBackoff());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (debug) {
            System.out.println(msg + "done sleeping");
        }
        if (this.isTransientException(ri)) {
            throw new ForwardRequest(ri.effective_target());
        }
        if (this.isBadServerIdException(ri)) {
            throw new ForwardRequest(ri.target());
        }
        if (debug) {
            System.out.println(msg + "unexpected: " + ri.received_exception_id());
        }
    }

    public void receive_other(ClientRequestInfo ri) {
        this.setBackoff(initialBackoff);
    }

    public void pre_init(ORBInitInfo info) {
    }

    public void post_init(ORBInitInfo info) {
        block3: {
            try {
                if (debug) {
                    System.out.println(".post_init: registering: " + this);
                }
                info.add_client_request_interceptor((ClientRequestInterceptor)this);
            }
            catch (DuplicateName e) {
                if (!debug) break block3;
                System.out.println(".post_init: exception: " + e);
            }
        }
    }

    private boolean isTransientException(ClientRequestInfo ri) {
        return ri.received_exception_id().equals(TRANSIENT_REPOSITORY_ID);
    }

    private boolean isBadServerIdException(ClientRequestInfo ri) {
        if (!ri.received_exception_id().equals(OBJECT_NOT_EXIST_REPOSITORY_ID)) {
            return false;
        }
        SystemException se = ORBUtility.extractSystemException(ri.received_exception());
        return se instanceof OBJECT_NOT_EXIST && se.minor == ORBUtilSystemException.BAD_SERVER_ID;
    }

    private static class BackoffAndStartTime {
        public long startTime;
        public long backoff = initialBackoff;

        BackoffAndStartTime() {
        }
    }
}

