/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MethodNode
extends DeploymentDescriptorNode<MethodDescriptor> {
    private MethodDescriptor descriptor;

    @Override
    public MethodDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new MethodDescriptor();
        }
        return this.descriptor;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("ejb-name", "setEjbName");
        table.put("method-intf", "setEjbClassSymbol");
        table.put("method-name", "setName");
        table.put("method-param", "addParameterClass");
        return table;
    }

    @Override
    public boolean endElement(XMLElement element) {
        MethodDescriptor desc;
        String qname = element.getQName();
        if ("method-params".equals(qname) && (desc = this.getDescriptor()).getParameterClassNames() == null) {
            desc.setEmptyParameterClassNames();
        }
        return super.endElement(element);
    }

    public Node writeDescriptor(Node parent, String nodeName, MethodDescriptor descriptor, String ejbName) {
        String methodIntfSymbol;
        Node methodNode = super.writeDescriptor(parent, nodeName, descriptor);
        MethodNode.writeLocalizedDescriptions(methodNode, descriptor);
        if (ejbName != null && !ejbName.isEmpty()) {
            MethodNode.appendTextChild(methodNode, "ejb-name", ejbName);
        }
        if ((methodIntfSymbol = descriptor.getEjbClassSymbol()) != null && !methodIntfSymbol.equals("Bean")) {
            MethodNode.appendTextChild(methodNode, "method-intf", methodIntfSymbol);
        }
        MethodNode.appendTextChild(methodNode, "method-name", descriptor.getName());
        if (descriptor.getParameterClassNames() != null) {
            Element paramsNode = MethodNode.appendChild(methodNode, "method-params");
            this.writeMethodParams(paramsNode, descriptor);
        }
        return methodNode;
    }

    public Node writeQueryMethodDescriptor(Node parent, String nodeName, MethodDescriptor descriptor) {
        Node methodNode = super.writeDescriptor(parent, nodeName, descriptor);
        MethodNode.appendTextChild(methodNode, "method-name", descriptor.getName());
        Element paramsNode = MethodNode.appendChild(methodNode, "method-params");
        this.writeMethodParams(paramsNode, descriptor);
        return methodNode;
    }

    public Node writeJavaMethodDescriptor(Node parent, String nodeName, MethodDescriptor methodDescriptor) {
        return this.writeJavaMethodDescriptor(parent, nodeName, methodDescriptor, false);
    }

    public Node writeJavaMethodDescriptor(Node parent, String nodeName, MethodDescriptor methodDescriptor, boolean writeEmptyMethodParamsElementForVoidMethods) {
        Node methodNode = super.writeDescriptor(parent, nodeName, methodDescriptor);
        MethodNode.appendTextChild(methodNode, "method-name", methodDescriptor.getName());
        if (methodDescriptor.getParameterClassNames() == null) {
            if (writeEmptyMethodParamsElementForVoidMethods) {
                MethodNode.appendChild(methodNode, "method-params");
            }
        } else {
            Element paramsNode = MethodNode.appendChild(methodNode, "method-params");
            this.writeMethodParams(paramsNode, methodDescriptor);
        }
        return methodNode;
    }

    private void writeMethodParams(Node paramsNode, MethodDescriptor descriptor) {
        String[] params = descriptor.getParameterClassNames();
        if (params == null) {
            return;
        }
        for (String param : params) {
            MethodNode.appendTextChild(paramsNode, "method-param", param);
        }
    }
}

