/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.event;

import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.util.LogUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.EventObject;
import java.util.List;

public class CommandActionListener
implements ActionListener,
Serializable {
    private static final String CAL_INSTANCE = "__jsft_CommandActionListener";
    private static final long serialVersionUID = 2L;
    public static final String COMMAND_EVENT_TYPE = "command";

    @Produces
    @ApplicationScoped
    @Named(value="lfCommand")
    public static CommandActionListener getInstance() {
        return CommandActionListener.getInstance(FacesContext.getCurrentInstance());
    }

    public static CommandActionListener getInstance(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        CommandActionListener instance = null;
        if (ctx != null) {
            instance = (CommandActionListener)ctx.getExternalContext().getApplicationMap().get(CAL_INSTANCE);
        }
        if (instance == null) {
            instance = new CommandActionListener();
            if (ctx != null) {
                ctx.getExternalContext().getApplicationMap().put(CAL_INSTANCE, instance);
            }
        }
        return instance;
    }

    public void processAction(ActionEvent event) {
        this.invokeCommandHandlers(event);
    }

    public void invokeCommandHandlers(ActionEvent event) {
        UIComponent command = (UIComponent)event.getSource();
        if (command == null) {
            throw new IllegalArgumentException("Action invoked, however, no source was given!");
        }
        FacesContext context = FacesContext.getCurrentInstance();
        LayoutElement desc = null;
        List handlers = (List)command.getAttributes().get(COMMAND_EVENT_TYPE);
        if (handlers != null && handlers.size() > 0) {
            desc = new LayoutComponent(null, command.getId(), null);
        } else {
            String viewId = CommandActionListener.getViewId(command);
            desc = CommandActionListener.findLayoutElementByClientId(context, viewId, command.getClientId(context));
            if (desc == null) {
                desc = CommandActionListener.findLayoutElementById(context, viewId, command.getId());
            }
        }
        if (desc == null) {
            throw new IllegalArgumentException("Unable to locate handlers for '" + command.getClientId(context) + "'.");
        }
        desc.dispatchHandlers(context, COMMAND_EVENT_TYPE, (EventObject)event);
    }

    public static String getViewId(UIComponent comp) {
        String result = null;
        while (comp != null && !(comp instanceof UIViewRoot)) {
            comp = comp.getParent();
        }
        if (comp != null) {
            result = ((UIViewRoot)comp).getViewId();
        }
        return result;
    }

    public static LayoutElement findLayoutElementByClientId(FacesContext ctx, String layoutDefKey, String clientId) {
        LayoutElement result;
        block2: {
            result = null;
            try {
                result = CommandActionListener.findLayoutElementByClientId(LayoutDefinitionManager.getLayoutDefinition(ctx, layoutDefKey), clientId);
            }
            catch (LayoutDefinitionException ex) {
                if (!LogUtil.configEnabled()) break block2;
                LogUtil.config("Unable to resolve client id '" + clientId + "' for LayoutDefinition key: '" + layoutDefKey + "'.", ex);
            }
        }
        return result;
    }

    public static LayoutElement findLayoutElementByClientId(LayoutDefinition def, String clientId) {
        return null;
    }

    public static LayoutElement findLayoutElementById(FacesContext ctx, String layoutDefKey, String id) {
        LayoutElement result;
        block3: {
            if (id == null) {
                return null;
            }
            result = null;
            try {
                result = CommandActionListener.findLayoutElementById(LayoutDefinitionManager.getLayoutDefinition(ctx, layoutDefKey), id);
            }
            catch (LayoutDefinitionException ex) {
                if (!LogUtil.configEnabled()) break block3;
                LogUtil.config("Unable to resolve id '" + id + "' for LayoutDefinition key: '" + layoutDefKey + "'.", ex);
            }
        }
        return result;
    }

    public static LayoutElement findLayoutElementById(LayoutElement elt, String id) {
        if (elt.getUnevaluatedId().equals(id)) {
            return elt;
        }
        LayoutElement child2 = null;
        for (LayoutElement child2 : elt.getChildLayoutElements()) {
            if (!(child2 instanceof LayoutComponent) || (child2 = CommandActionListener.findLayoutElementById(child2, id)) == null) continue;
            return child2;
        }
        return null;
    }
}

