/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Identifier;
import org.glassfish.rmic.tools.java.MemberDefinition;
import org.glassfish.rmic.tools.java.Type;

public class MethodSet {
    private final Map<Identifier, List<MemberDefinition>> lookupMap = new HashMap<Identifier, List<MemberDefinition>>();
    private int count = 0;
    private boolean frozen = false;

    public int size() {
        return this.count;
    }

    public void add(MemberDefinition method) {
        if (this.frozen) {
            throw new CompilerError("add()");
        }
        Identifier name = method.getName();
        List<MemberDefinition> methodList = this.lookupMap.get(name);
        if (methodList == null) {
            methodList = new ArrayList<MemberDefinition>();
            this.lookupMap.put(name, methodList);
        }
        int size = methodList.size();
        for (int i = 0; i < size; ++i) {
            if (!methodList.get(i).getType().equalArguments(method.getType())) continue;
            throw new CompilerError("duplicate addition");
        }
        methodList.add(method);
        ++this.count;
    }

    public void replace(MemberDefinition method) {
        if (this.frozen) {
            throw new CompilerError("replace()");
        }
        Identifier name = method.getName();
        List<MemberDefinition> methodList = this.lookupMap.get(name);
        if (methodList == null) {
            methodList = new ArrayList<MemberDefinition>();
            this.lookupMap.put(name, methodList);
        }
        int size = methodList.size();
        for (int i = 0; i < size; ++i) {
            if (!methodList.get(i).getType().equalArguments(method.getType())) continue;
            methodList.set(i, method);
            return;
        }
        methodList.add(method);
        ++this.count;
    }

    public MemberDefinition lookupSig(Identifier name, Type type) {
        Iterator<MemberDefinition> matches = this.lookupName(name);
        while (matches.hasNext()) {
            MemberDefinition candidate = matches.next();
            if (!candidate.getType().equalArguments(type)) continue;
            return candidate;
        }
        return null;
    }

    public Iterator<MemberDefinition> lookupName(Identifier name) {
        List<MemberDefinition> methodList = this.lookupMap.get(name);
        if (methodList == null) {
            return Collections.emptyIterator();
        }
        return methodList.iterator();
    }

    public Iterator<MemberDefinition> iterator() {
        class MethodIterator
        implements Iterator<MemberDefinition> {
            Iterator<List<MemberDefinition>> hashIter;
            Iterator<MemberDefinition> listIter;

            MethodIterator() {
                this.hashIter = MethodSet.this.lookupMap.values().iterator();
                this.listIter = Collections.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                if (this.listIter.hasNext()) {
                    return true;
                }
                if (this.hashIter.hasNext()) {
                    this.listIter = this.hashIter.next().iterator();
                    if (this.listIter.hasNext()) {
                        return true;
                    }
                    throw new CompilerError("iterator() in MethodSet");
                }
                return false;
            }

            @Override
            public MemberDefinition next() {
                return this.listIter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new MethodIterator();
    }

    public void freeze() {
        this.frozen = true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public String toString() {
        int len = this.size();
        StringBuilder sb = new StringBuilder();
        Iterator<MemberDefinition> all = this.iterator();
        sb.append("{");
        while (all.hasNext()) {
            sb.append(all.next().toString());
            if (--len <= 0) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

