/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.gf.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.tyrus.core.ComponentProvider;

public class CdiComponentProvider
extends ComponentProvider {
    private final BeanManager beanManager;
    private static final Logger LOGGER = Logger.getLogger(CdiComponentProvider.class.getName());
    private final boolean managerRetrieved;
    private static final Map<Object, CdiInjectionContext> cdiBeanToContext = new ConcurrentHashMap<Object, CdiInjectionContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CdiComponentProvider() throws NamingException {
        InitialContext ic = new InitialContext();
        BeanManager manager = null;
        try {
            this.beanManager = manager = (BeanManager)ic.lookup("java:comp/BeanManager");
            this.managerRetrieved = this.beanManager != null;
        }
        catch (Exception e) {
            try {
                LOGGER.fine(e.getMessage());
                this.beanManager = manager;
                this.managerRetrieved = this.beanManager != null;
            }
            catch (Throwable throwable) {
                this.beanManager = manager;
                this.managerRetrieved = this.beanManager != null;
                throw throwable;
            }
        }
    }

    public boolean isApplicable(Class<?> c) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = c.getAnnotations()) {
            String annotationClassName = annotation.annotationType().getCanonicalName();
            if (!annotationClassName.equals("jakarta.ejb.Singleton") && !annotationClassName.equals("jakarta.ejb.Stateful") && !annotationClassName.equals("jakarta.ejb.Stateless")) continue;
            return false;
        }
        return this.managerRetrieved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Object create(Class<T> c) {
        if (this.managerRetrieved) {
            BeanManager beanManager = this.beanManager;
            synchronized (beanManager) {
                AnnotatedType annotatedType = this.beanManager.createAnnotatedType(c);
                InjectionTargetFactory injectionTargetFactory = this.beanManager.getInjectionTargetFactory(annotatedType);
                InjectionTarget it = injectionTargetFactory.createInjectionTarget(null);
                CreationalContext cc = this.beanManager.createCreationalContext(null);
                Object managedObject = it.produce(cc);
                it.inject(managedObject, cc);
                it.postConstruct(managedObject);
                cdiBeanToContext.put(managedObject, new CdiInjectionContext(it, cc));
                return managedObject;
            }
        }
        return null;
    }

    public boolean destroy(Object o) {
        if (cdiBeanToContext.containsKey(o)) {
            cdiBeanToContext.get(o).cleanup(o);
            cdiBeanToContext.remove(o);
            return true;
        }
        return false;
    }

    private static class CdiInjectionContext {
        final InjectionTarget it;
        final CreationalContext cc;

        CdiInjectionContext(InjectionTarget it, CreationalContext cc) {
            this.it = it;
            this.cc = cc;
        }

        public void cleanup(Object instance) {
            this.it.preDestroy(instance);
            this.it.dispose(instance);
            this.cc.release();
        }
    }
}

