/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.security;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.krazo.security.CsrfToken;
import org.eclipse.krazo.security.CsrfTokenStrategy;
import org.eclipse.krazo.util.HttpUtil;

public class SessionCsrfTokenStrategy
implements CsrfTokenStrategy {
    private static final String SESSION_KEY = SessionCsrfTokenStrategy.class.getName() + ".TOKEN";
    private final String headerName;
    private final String paramName;

    private SessionCsrfTokenStrategy(Builder builder) {
        this.headerName = builder.headerName;
        this.paramName = builder.paramName;
    }

    @Override
    public Optional<CsrfToken> getToken(HttpServletRequest request, HttpServletResponse response, boolean create) {
        Object value;
        HttpServletRequest originalRequest = HttpUtil.unwrapOriginalRequest(request);
        HttpSession session = originalRequest.getSession(false);
        if (session != null && (value = session.getAttribute(SESSION_KEY)) instanceof CsrfToken) {
            return Optional.of((CsrfToken)value);
        }
        if (create) {
            CsrfToken token = new CsrfToken(this.headerName, this.paramName, UUID.randomUUID().toString());
            originalRequest.getSession(true).setAttribute(SESSION_KEY, (Object)token);
            return Optional.of(token);
        }
        return Optional.empty();
    }

    public static final class Builder {
        private String headerName = "X-CSRF-TOKEN";
        private String paramName = "_csrf";

        public Builder headerName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public Builder paramName(String paramName) {
            this.paramName = paramName;
            return this;
        }

        public SessionCsrfTokenStrategy build() {
            return new SessionCsrfTokenStrategy(this);
        }
    }
}

