/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.commands.CLIUtil;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-threadpools")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.threadpools")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.CLUSTERED_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=ThreadPools.class, opType=RestEndpoint.OpType.GET, path="list-threadpools", description="list-threadpools")})
public class ListThreadpools
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Param(name="target", primary=true, defaultValue="server")
    String target;
    @Inject
    ServiceLocator habitat;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListThreadpools.class);
    @AccessRequired.To(value={"read"})
    private ThreadPools threadPools;

    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.updateConfigIfNeeded(this.config, this.target, this.habitat);
        this.threadPools = this.config.getThreadPools();
        return true;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            List poolList = this.threadPools.getThreadPool();
            for (ThreadPool pool : poolList) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(pool.getName());
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            String str = e.getMessage();
            report.setMessage(localStrings.getLocalString("list.thread.pools.failed", "List Thread Pools failed because of: " + str));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

