/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.inject.Provider;
import java.lang.reflect.Type;
import java.util.Set;
import org.jboss.weld.bean.builtin.AbstractFacadeBean;
import org.jboss.weld.bean.builtin.InstanceImpl;
import org.jboss.weld.inject.WeldInstance;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.reflection.Reflections;

public class InstanceBean
extends AbstractFacadeBean<Instance<?>> {
    private static final Type INSTANCE_TYPE = new TypeLiteral<Instance<Object>>(){
        private static final long serialVersionUID = -1246199714407637856L;
    }.getType();
    private static final Type PROVIDER_TYPE = new TypeLiteral<Provider<Object>>(){
        private static final long serialVersionUID = -5256050387550468441L;
    }.getType();
    private static final Type WELD_INSTANCE_TYPE = new TypeLiteral<WeldInstance<Object>>(){
        private static final long serialVersionUID = -1246199714407637856L;
    }.getType();
    private static final Set<Type> DEFAULT_TYPES = Arrays2.asSet(INSTANCE_TYPE, WELD_INSTANCE_TYPE, PROVIDER_TYPE, Object.class);

    public InstanceBean(BeanManagerImpl manager) {
        super(manager, (Class)Reflections.cast(Instance.class));
    }

    @Override
    public Class<?> getBeanClass() {
        return InstanceImpl.class;
    }

    @Override
    public Set<Type> getTypes() {
        return DEFAULT_TYPES;
    }

    @Override
    protected Instance<?> newInstance(InjectionPoint injectionPoint, CreationalContext<Instance<?>> creationalContext) {
        return InstanceImpl.of(injectionPoint, creationalContext, this.getBeanManager());
    }

    @Override
    public String toString() {
        return "Implicit Bean [jakarta.enterprise.inject.Instance] with qualifiers [@Default]";
    }

    @Override
    protected Type getDefaultType() {
        return INSTANCE_TYPE;
    }

    @Override
    public boolean isDependentContextOptimizationAllowed() {
        return false;
    }
}

