/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.contexts;

import java.util.Collection;
import java.util.HashSet;
import org.jboss.weld.context.BoundContext;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.contexts.AbstractManagedContext;
import org.jboss.weld.contexts.beanstore.BoundBeanStore;
import org.jboss.weld.contexts.beanstore.LockedBean;
import org.jboss.weld.contexts.cache.RequestScopedCache;
import org.jboss.weld.serialization.spi.BeanIdentifier;

public abstract class AbstractBoundContext<S>
extends AbstractManagedContext
implements BoundContext<S> {
    private final ThreadLocal<BoundBeanStore> beanStore = new ThreadLocal();

    public AbstractBoundContext(String contextId, boolean multithreaded) {
        super(contextId, multithreaded);
    }

    @Override
    protected BoundBeanStore getBeanStore() {
        return this.beanStore.get();
    }

    protected void setBeanStore(BoundBeanStore beanStore) {
        if (beanStore == null) {
            this.beanStore.remove();
        } else {
            this.beanStore.set(beanStore);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.beanStore.remove();
    }

    @Override
    public void activate() {
        super.activate();
        this.getBeanStore().attach();
    }

    @Override
    public void deactivate() {
        this.getBeanStore().detach();
        super.deactivate();
    }

    @Override
    public boolean dissociate(S storage) {
        if (this.getBeanStore() != null) {
            try {
                this.setBeanStore(null);
                boolean bl = true;
                return bl;
            }
            finally {
                this.cleanup();
            }
        }
        return false;
    }

    @Override
    public Collection<ContextualInstance<?>> getAllContextualInstances() {
        HashSet result = new HashSet();
        BoundBeanStore beanStore = this.getBeanStore();
        if (beanStore != null) {
            this.getBeanStore().iterator().forEachRemaining(beanId -> result.add(this.getBeanStore().get((BeanIdentifier)beanId)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAndSet(Collection<ContextualInstance<?>> setOfInstances) {
        BoundBeanStore boundBeanStore = this.getBeanStore();
        if (boundBeanStore != null) {
            boundBeanStore.clear();
            RequestScopedCache.invalidate();
            for (ContextualInstance<?> contextualInstance : setOfInstances) {
                BeanIdentifier id = this.getId(contextualInstance.getContextual());
                LockedBean lock = null;
                try {
                    if (this.isMultithreaded()) {
                        lock = boundBeanStore.lock(id);
                    }
                    this.getBeanStore().put(this.getId(contextualInstance.getContextual()), contextualInstance);
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

