/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.concurrent;

import jakarta.annotation.Priority;
import jakarta.enterprise.concurrent.Asynchronous;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.enterprise.concurrent.internal.ManagedCompletableFuture;

@Interceptor
@Asynchronous
@Priority(value=5)
public class AsynchronousInterceptor {
    static final Logger log = Logger.getLogger(AsynchronousInterceptor.class.getName());

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        ManagedExecutorService mes;
        String executor = context.getMethod().getAnnotation(Asynchronous.class).executor();
        executor = executor != null ? executor : "java:comp/DefaultManagedExecutorService";
        log.log(Level.FINE, "AsynchronousInterceptor.intercept around asynchronous method {0}, executor=''{1}''", new Object[]{context.getMethod(), executor});
        try {
            Object lookupMes = new InitialContext().lookup(executor);
            if (lookupMes == null) {
                throw new RejectedExecutionException("ManagedExecutorService with jndi '" + executor + "' not found!");
            }
            if (!(lookupMes instanceof ManagedExecutorService)) {
                throw new RejectedExecutionException("ManagedExecutorService with jndi '" + executor + "' must be of type jakarta.enterprise.concurrent.ManagedExecutorService, found " + lookupMes.getClass().getName());
            }
            mes = (ManagedExecutorService)lookupMes;
        }
        catch (NamingException ex) {
            throw new RejectedExecutionException("ManagedExecutorService with jndi '" + executor + "' not found as requested by asynchronous method " + String.valueOf(context.getMethod()));
        }
        ManagedCompletableFuture resultFuture = new ManagedCompletableFuture(mes);
        mes.submit(() -> {
            Asynchronous.Result.setFuture((CompletableFuture)resultFuture);
            CompletableFuture returnedFuture = resultFuture;
            try {
                returnedFuture = (CompletableFuture)context.proceed();
            }
            catch (Exception ex) {
                resultFuture.completeExceptionally(ex);
            }
            finally {
                if (!returnedFuture.isDone()) {
                    log.log(Level.SEVERE, "Method annotated with @Asynchronous did not call Asynchronous.Result.complete() at its end: {0}", context.getMethod().toString());
                    Asynchronous.Result.getFuture().cancel(true);
                }
                if (returnedFuture != Asynchronous.Result.getFuture()) {
                    try {
                        resultFuture.complete(returnedFuture.get());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        resultFuture.completeExceptionally(e);
                    }
                }
                Asynchronous.Result.setFuture(null);
            }
        });
        return resultFuture;
    }
}

