/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.LinkedList;

final class BundleQueue<E> {
    private final LinkedList<Record<E>> internalQueue = new LinkedList();
    private int lastElementAbsoluteDistance;

    BundleQueue() {
    }

    public void add(int bundle, E element) {
        if (this.lastElementAbsoluteDistance > bundle) {
            throw new IllegalStateException("New element must have greater absolute distance than the last element in the queue");
        }
        this.internalQueue.addLast(new Record<E>(element, bundle - this.lastElementAbsoluteDistance));
        this.lastElementAbsoluteDistance = bundle;
    }

    public boolean hasNext() {
        return !this.internalQueue.isEmpty() && this.internalQueue.getFirst().distance == 0;
    }

    public E next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("There is no next element available");
        }
        return this.internalQueue.removeFirst().value;
    }

    public boolean nextBundle() {
        if (this.internalQueue.isEmpty()) {
            return false;
        }
        while (this.internalQueue.getFirst().distance == 0) {
            this.internalQueue.removeFirst();
            if (!this.internalQueue.isEmpty()) continue;
            return false;
        }
        --this.lastElementAbsoluteDistance;
        return --this.internalQueue.getFirst().distance == 0;
    }

    private static final class Record<E> {
        private final E value;
        private int distance;

        public Record(E value, int distance) {
            this.value = value;
            this.distance = distance;
        }
    }
}

