/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http2.Http2Session;
import org.glassfish.grizzly.http2.frames.ContinuationFrame;
import org.glassfish.grizzly.http2.frames.DataFrame;
import org.glassfish.grizzly.http2.frames.GoAwayFrame;
import org.glassfish.grizzly.http2.frames.HeadersFrame;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.http2.frames.PingFrame;
import org.glassfish.grizzly.http2.frames.PriorityFrame;
import org.glassfish.grizzly.http2.frames.PushPromiseFrame;
import org.glassfish.grizzly.http2.frames.RstStreamFrame;
import org.glassfish.grizzly.http2.frames.SettingsFrame;
import org.glassfish.grizzly.http2.frames.UnknownFrame;
import org.glassfish.grizzly.http2.frames.WindowUpdateFrame;

final class NetLogger {
    private static final Logger LOGGER = Grizzly.logger(NetLogger.class);
    private static final Level LEVEL = Level.FINE;
    private static final String CLOSE_FMT = "'{' \"session\":\"{0}\", \"event\":\"SESSION_CLOSE\" '}'";
    private static final String DATA = "DATA";
    private static final String DATA_FMT = "'{' \"session\":\"{0}\", \"event\":\"{1}\", \"stream\":\"{2}\", \"fin\":\"{3}\", \"len\":\"{4}\" '}'";
    private static final String CONTINUATION = "CONTINUATION";
    private static final String CONTINUATION_FMT = "'{' \"session\":\"{0}\", \"event\":\"{1}\", \"stream\":\"{2}\", \"len\":\"{3}\" '}'";
    private static final String GOAWAY = "GOAWAY";
    private static final String GOAWAY_FMT = "'{' \"session\":\"{0}\", \"event\":\"{1}\", \"stream\":\"{2}\", \"last-stream\":\"{3}\", \"error-code\":\"{4}\", \"detail\":\"{5}\" '}'";
    private static final String HEADERS = "HEADERS";
    private static final String HEADERS_FMT = "'{' \"session\":\"{0}\", \"event\":\"{1}\", \"stream\":\"{2}\", \"parent-stream\":\"{3}\", \"prioritized\":\"{4}\", \"exclusive\":\"{5}\", \"weight\":\"{6}\", \"fin\":\"{7}\", \"len\":\"{8}\", \"headers\":{9} '}'";
    private static final String OPEN_FMT = "'{' \"session\":\"{0}\", \"event\":\"SESSION_OPEN\" '}'";
    private static final String PING = "PING";
    private static final String PING_FMT = "'{' session=\"{0}\", event=\"{1}\", is-ack=\"{2}\", opaque-data=\"{3}\" '}'";
    private static final String PRIORITY = "PRIORITY";
    private static final String PRIORITY_FMT = "'{' \"session\":\"{0}\", \"event\":\"{1}\", \"stream\":\"{2}\", \"parent-stream\":\"{3}\", \"exclusive\":\"{4}\", \"weight\":\"{5}\" '}'";
    private static final String PUSH_PROMISE = "PUSH_PROMISE";
    private static final String PUSH_PROMISE_FMT = "'{' \"session\":\"{0}\", \"event\":\"{1}\", \"stream\":\"{2}\", \"promised-stream\":\"{3}\", \"len\":\"{4}\", \"headers\":{5} '}'";
    private static final String RST = "RST";
    private static final String RST_FMT = "'{' \"session\":\"{0}\", \"event\":\"{1}\", \"stream\":\"{2}\", \"error-code\":\"{3}\" '}'";
    private static final String SETTINGS = "SETTINGS";
    private static final String SETTINGS_FMT = "'{' \"session\":\"{0}\", \"event\":\"{1}\", \"settings\":'{'{2}'}' '}'";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String UNKNOWN_FMT = "'{' \"session\":\"{0}\", \"event\":\"{1}\", \"frame-type\":\"{2}\", \"len\":\"{3}\" '}'";
    private static final String WINDOW_UPDATE = "WINDOW_UPDATE";
    private static final String WINDOW_UPDATE_FMT = "'{' \"session\":\"{0}\", \"event\":\"{1}\", \"delta\":\"{2}\" '}'";
    private static final String NOT_AVAILABLE = "None Available";

    NetLogger() {
    }

    static boolean isActive() {
        return LOGGER.isLoggable(LEVEL);
    }

    static void log(Context ctx, Http2Session c, Http2Frame frame) {
        switch (frame.getType()) {
            case 9: {
                NetLogger.log(ctx, c, (ContinuationFrame)frame);
                break;
            }
            case 0: {
                NetLogger.log(ctx, c, (DataFrame)frame);
                break;
            }
            case 7: {
                NetLogger.log(ctx, c, (GoAwayFrame)frame);
                break;
            }
            case 1: {
                break;
            }
            case 6: {
                NetLogger.log(ctx, c, (PingFrame)frame);
                break;
            }
            case 2: {
                NetLogger.log(ctx, c, (PriorityFrame)frame);
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                NetLogger.log(ctx, c, (RstStreamFrame)frame);
                break;
            }
            case 4: {
                NetLogger.log(ctx, c, (SettingsFrame)frame);
                break;
            }
            case 8: {
                NetLogger.log(ctx, c, (WindowUpdateFrame)frame);
                break;
            }
            default: {
                NetLogger.log(ctx, c, (UnknownFrame)frame);
            }
        }
    }

    static void log(Context ctx, Http2Session c, ContinuationFrame frame) {
        NetLogger.validateParams(ctx, c, frame);
        if (NetLogger.isActive()) {
            LOGGER.log(LEVEL, CONTINUATION_FMT, new Object[]{NetLogger.escape(c.getConnection().toString()), ctx.getPrefix() + CONTINUATION, frame.getStreamId(), frame.getLength()});
        }
    }

    static void log(Context ctx, Http2Session c, DataFrame frame) {
        NetLogger.validateParams(ctx, c, frame);
        if (NetLogger.isActive()) {
            LOGGER.log(LEVEL, DATA_FMT, new Object[]{NetLogger.escape(c.getConnection().toString()), ctx.getPrefix() + DATA, frame.getStreamId(), frame.isEndStream(), frame.getData().remaining()});
        }
    }

    static void log(Context ctx, Http2Session c, GoAwayFrame frame) {
        NetLogger.validateParams(ctx, c, frame);
        if (NetLogger.isActive()) {
            Buffer b = frame.getAdditionalDebugData();
            String details = b != null ? b.toStringContent() : NOT_AVAILABLE;
            LOGGER.log(LEVEL, GOAWAY_FMT, new Object[]{NetLogger.escape(c.getConnection().toString()), ctx.getPrefix() + GOAWAY, frame.getStreamId(), frame.getLastStreamId(), frame.getErrorCode().getCode(), NetLogger.escape(details)});
        }
    }

    static void log(Context ctx, Http2Session c, HeadersFrame frame, Map<String, String> headers) {
        NetLogger.validateParams(ctx, c, frame);
        if (NetLogger.isActive()) {
            LOGGER.log(LEVEL, HEADERS_FMT, new Object[]{NetLogger.escape(c.getConnection().toString()), ctx.getPrefix() + HEADERS, frame.getStreamId(), frame.getStreamDependency(), frame.isPrioritized(), frame.isExclusive(), frame.getWeight(), frame.isEndStream(), frame.getLength(), NetLogger.toJSON(headers)});
        }
    }

    static void log(Context ctx, Http2Session c, PingFrame frame) {
        NetLogger.validateParams(ctx, c, frame);
        if (NetLogger.isActive()) {
            LOGGER.log(LEVEL, PING_FMT, new Object[]{NetLogger.escape(c.getConnection().toString()), ctx.getPrefix() + PING, frame.isAckSet(), frame.getOpaqueData()});
        }
    }

    static void log(Context ctx, Http2Session c, PriorityFrame frame) {
        NetLogger.validateParams(ctx, c, frame);
        if (NetLogger.isActive()) {
            LOGGER.log(LEVEL, PRIORITY_FMT, new Object[]{NetLogger.escape(c.getConnection().toString()), ctx.getPrefix() + PRIORITY, frame.getStreamId(), frame.getStreamDependency(), frame.isExclusive(), frame.getWeight()});
        }
    }

    static void log(Context ctx, Http2Session c, PushPromiseFrame frame, Map<String, String> headers) {
        NetLogger.validateParams(ctx, c, frame);
        if (NetLogger.isActive()) {
            LOGGER.log(LEVEL, PUSH_PROMISE_FMT, new Object[]{NetLogger.escape(c.getConnection().toString()), ctx.getPrefix() + PUSH_PROMISE, frame.getStreamId(), frame.getPromisedStreamId(), frame.getLength(), NetLogger.toJSON(headers)});
        }
    }

    static void log(Context ctx, Http2Session c, RstStreamFrame frame) {
        NetLogger.validateParams(ctx, c, frame);
        if (NetLogger.isActive()) {
            LOGGER.log(LEVEL, RST_FMT, new Object[]{NetLogger.escape(c.getConnection().toString()), ctx.getPrefix() + RST, frame.getStreamId(), frame.getErrorCode().getCode()});
        }
    }

    static void log(Context ctx, Http2Session c, SettingsFrame frame) {
        NetLogger.validateParams(ctx, c, frame);
        if (NetLogger.isActive()) {
            int numSettings = frame.getNumberOfSettings();
            StringBuilder sb = new StringBuilder();
            if (numSettings > 0) {
                for (int i = 0; i < numSettings; ++i) {
                    SettingsFrame.Setting setting = frame.getSettingByIndex(i);
                    sb.append('\"').append(frame.getSettingNameById(setting.getId())).append('\"');
                    sb.append(": ");
                    sb.append('\"').append(setting.getValue()).append('\"');
                    if (i + 1 >= numSettings) continue;
                    sb.append(", ");
                }
            }
            LOGGER.log(LEVEL, SETTINGS_FMT, new Object[]{NetLogger.escape(c.getConnection().toString()), ctx.getPrefix() + SETTINGS, sb.toString()});
        }
    }

    static void log(Context ctx, Http2Session c, WindowUpdateFrame frame) {
        NetLogger.validateParams(ctx, c, frame);
        if (NetLogger.isActive()) {
            LOGGER.log(LEVEL, WINDOW_UPDATE_FMT, new Object[]{NetLogger.escape(c.getConnection().toString()), ctx.getPrefix() + WINDOW_UPDATE, frame.getWindowSizeIncrement()});
        }
    }

    static void log(Context ctx, Http2Session c, UnknownFrame frame) {
        NetLogger.validateParams(ctx, c, frame);
        if (NetLogger.isActive()) {
            LOGGER.log(LEVEL, UNKNOWN_FMT, new Object[]{NetLogger.escape(c.getConnection().toString()), ctx.getPrefix() + UNKNOWN, frame.getType(), frame.getLength()});
        }
    }

    static void logClose(Http2Session c) {
        NetLogger.logSessionEvent(CLOSE_FMT, c);
    }

    static void logOpen(Http2Session c) {
        NetLogger.logSessionEvent(OPEN_FMT, c);
    }

    private static void logSessionEvent(String msg, Http2Session c) {
        if (c == null) {
            throw new NullPointerException("Http2Session cannot be null");
        }
        if (NetLogger.isActive()) {
            LOGGER.log(LEVEL, msg, new Object[]{NetLogger.escape(c.getConnection().toString())});
        }
    }

    private static StringBuilder toJSON(Map<String, String> headers) {
        StringBuilder result = new StringBuilder(64);
        result.append("{ ");
        Iterator<Map.Entry<String, String>> i = headers.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            result.append('\"').append(entry.getKey()).append("\":\"").append(entry.getValue()).append('\"');
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        result.append(" }");
        return result;
    }

    private static void validateParams(Context ctx, Http2Session c, Http2Frame frame) {
        if (ctx == null) {
            throw new NullPointerException("Context cannot be null.");
        }
        if (c == null) {
            throw new NullPointerException("Http2Session cannot be null.");
        }
        if (frame == null) {
            throw new NullPointerException("Http2Frame cannot be null.");
        }
    }

    private static String escape(String s) {
        StringBuilder sb = new StringBuilder(s.length() + 20);
        int len = s.length();
        block5: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    sb.append("'");
                    continue block5;
                }
                case '\"': {
                    sb.append("\"");
                    continue block5;
                }
                case '\\': {
                    sb.append("\\");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static enum Context {
        TX("SEND_"),
        RX("RECV_");

        final String prefix;

        private Context(String prefix) {
            this.prefix = prefix;
        }

        String getPrefix() {
            return this.prefix;
        }
    }
}

