/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.ListManager;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.component.WebuiInput;
import com.sun.webui.jsf.model.list.ListItem;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.jsf.util.ValueType;
import com.sun.webui.jsf.util.ValueTypeEvaluator;
import com.sun.webui.theme.Theme;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.ConverterException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class OrderableList
extends WebuiInput
implements ListManager,
NamingContainer {
    public static final String MOVEUP_BUTTON_ID = "_moveUpButton";
    public static final String MOVEUP_BUTTON_FACET = "moveUpButton";
    public static final String MOVEUP_TEXT_KEY = "OrderableList.moveUp";
    public static final String MOVEDOWN_BUTTON_ID = "_moveDownButton";
    public static final String MOVEDOWN_BUTTON_FACET = "moveDownButton";
    public static final String MOVEDOWN_TEXT_KEY = "OrderableList.moveDown";
    public static final String MOVETOP_BUTTON_ID = "_moveTopButton";
    public static final String MOVETOP_BUTTON_FACET = "moveTopButton";
    public static final String MOVETOP_TEXT_KEY = "OrderableList.moveTop";
    public static final String MOVEBOTTOM_BUTTON_ID = "_moveBottomButton";
    public static final String MOVEBOTTOM_BUTTON_FACET = "moveBottomButton";
    public static final String MOVEBOTTOM_TEXT_KEY = "OrderableList.moveBottom";
    public static final String LABEL_ID = "_label";
    public static final String LABEL_FACET = "label";
    public static final String LABEL_TEXT_KEY = "OrderableList.defaultListLabel";
    public static final String READ_ONLY_ID = "_readOnly";
    public static final String READ_ONLY_FACET = "readOnly";
    public static final String FOOTER_FACET = "footer";
    public static final String RETURN = "return false;";
    public static final String MOVEUP_FUNCTION = ".moveUp(); ";
    public static final String MOVEDOWN_FUNCTION = ".moveDown();";
    public static final String MOVETOP_FUNCTION = ".moveTop(); ";
    public static final String MOVEBOTTOM_FUNCTION = ".moveBottom();";
    public static final String UPDATEBUTTONS_FUNCTION = ".updateButtons(); ";
    public static final String ONCHANGE_FUNCTION = ".onChange(); ";
    private static final String READ_ONLY_SEPARATOR = ", ";
    private ValueTypeEvaluator valueTypeEvaluator = null;
    private ArrayList<Object> listItems = null;
    private transient Theme theme = null;
    private static final boolean DEBUG = false;
    private boolean disabled = false;
    private boolean disabledSet = false;
    private String label = null;
    private int labelLevel = Integer.MIN_VALUE;
    private boolean labelLevelSet = false;
    private boolean labelOnTop = false;
    private boolean labelOnTopSet = false;
    private boolean moveTopBottom = false;
    private boolean moveTopBottomSet = false;
    private boolean multiple = false;
    private boolean multipleSet = false;
    private boolean readOnly = false;
    private boolean readOnlySet = false;
    private int rows = Integer.MIN_VALUE;
    private boolean rowsSet = false;
    private String style = null;
    private String styleClass = null;
    private int tabIndex = Integer.MIN_VALUE;
    private boolean tabIndexSet = false;
    private String toolTip = null;
    private boolean visible = false;
    private boolean visibleSet = false;

    public OrderableList() {
        this.valueTypeEvaluator = new ValueTypeEvaluator((UIComponent)this);
        this.setRendererType("com.sun.webui.jsf.OrderableList");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.OrderableList";
    }

    public UIComponent getMoveUpButtonComponent(FacesContext context) {
        return this.getButtonFacet(MOVEUP_BUTTON_FACET, false, this.getTheme().getMessage(MOVEUP_TEXT_KEY), MOVEUP_FUNCTION);
    }

    public UIComponent getMoveDownButtonComponent(FacesContext context) {
        return this.getButtonFacet(MOVEDOWN_BUTTON_FACET, false, this.getTheme().getMessage(MOVEDOWN_TEXT_KEY), MOVEDOWN_FUNCTION);
    }

    public UIComponent getMoveTopButtonComponent(FacesContext context) {
        return this.getButtonFacet(MOVETOP_BUTTON_FACET, false, this.getTheme().getMessage(MOVETOP_TEXT_KEY), MOVETOP_FUNCTION);
    }

    public UIComponent getMoveBottomButtonComponent(FacesContext context) {
        return this.getButtonFacet(MOVEBOTTOM_BUTTON_FACET, false, this.getTheme().getMessage(MOVEBOTTOM_TEXT_KEY), MOVEBOTTOM_FUNCTION);
    }

    private UIComponent getButtonFacet(String facetName, boolean primary, String text, String onclickFunction) {
        UIComponent buttonComponent = this.getFacet(facetName);
        if (buttonComponent != null) {
            return buttonComponent;
        }
        Button button = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (button == null) {
            button = new Button();
            button.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
        }
        this.initButtonFacet(button, primary, text, onclickFunction);
        ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)button);
        return button;
    }

    private void initButtonFacet(Button button, boolean primary, String text, String onclickFunction) {
        button.setPrimary(primary);
        button.setText(text);
        int tindex = this.getTabIndex();
        if (tindex > 0) {
            button.setTabIndex(tindex);
        }
        StringBuilder buff = new StringBuilder();
        buff.append("document.getElementById('").append(this.getClientId(this.getFacesContext())).append("')").append(onclickFunction).append(RETURN);
        button.setOnClick(buff.toString());
        button.setDisabled(this.isDisabled());
    }

    public UIComponent getHeaderComponent() {
        String labelString = this.getLabel();
        if (labelString == null || labelString.length() == 0) {
            labelString = this.getTheme().getMessage(LABEL_TEXT_KEY);
        }
        return this.getLabelFacet(LABEL_FACET, labelString, (UIComponent)this);
    }

    private UIComponent getLabelFacet(String facetName, String text, UIComponent forComponent) {
        UIComponent labelComponent = this.getFacet(facetName);
        if (labelComponent != null) {
            return labelComponent;
        }
        Label listLabel = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (listLabel == null) {
            listLabel = new Label();
            listLabel.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
        }
        this.initLabelFacet(listLabel, text, forComponent.getClientId(this.getFacesContext()));
        ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)listLabel);
        return listLabel;
    }

    private void initLabelFacet(Label labelComp, String labelText, String forComponentId) {
        if (labelText == null || labelText.length() < 1) {
            labelComp.setText("");
        } else {
            labelComp.setText(labelText);
        }
        labelComp.setLabelLevel(this.getLabelLevel());
        labelComp.setFor(forComponentId);
    }

    @Override
    public String getPrimaryElementID(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    @Override
    public String getLabeledElementId(FacesContext context) {
        return this.getClientId(context).concat("_list");
    }

    @Override
    public String getFocusElementId(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    @Override
    public Iterator getListItems(FacesContext context, boolean ruler) throws FacesException {
        this.listItems = new ArrayList();
        Object submittedValue = this.getSubmittedValue();
        if (submittedValue != null && submittedValue instanceof String[]) {
            String[] values = (String[])submittedValue;
            for (int counter = 0; counter < values.length; ++counter) {
                ListItem listItem = new ListItem(values[counter], values[counter]);
                listItem.setValue(values[counter]);
                this.listItems.add(listItem);
            }
            return this.listItems.iterator();
        }
        Object listItemsObject = this.getList();
        if (listItemsObject != null) {
            if (this.valueTypeEvaluator.getValueType() == ValueType.LIST) {
                for (Object item : (List)listItemsObject) {
                    this.listItems.add(this.createListItem((UIComponent)this, item));
                }
            } else if (this.valueTypeEvaluator.getValueType() == ValueType.ARRAY) {
                Object[] listObjects = (Object[])listItemsObject;
                for (int counter = 0; counter < listObjects.length; ++counter) {
                    this.listItems.add(this.createListItem((UIComponent)this, listObjects[counter]));
                }
            } else {
                String msg = this.getTheme().getMessage("OrderableList.invalidListType");
                throw new FacesException(msg);
            }
        }
        return this.listItems.iterator();
    }

    private ListItem createListItem(UIComponent comp, Object value) {
        if (value == null) {
            throw new NullPointerException("OrderableList ListItems cannot have null values");
        }
        String listLabel = ConversionUtilities.convertValueToString(comp, value);
        ListItem listItem = new ListItem(value, listLabel);
        listItem.setValue(listLabel);
        return listItem;
    }

    @Override
    public String[] getValueAsStringArray(FacesContext context) {
        Iterator iterator = this.getListItems(context, false);
        int numItems = this.listItems.size();
        String[] values = new String[numItems];
        for (int counter = 0; counter < numItems; ++counter) {
            values[counter] = ((ListItem)iterator.next()).getValue();
        }
        return values;
    }

    public Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        if (!(submittedValue instanceof String[])) {
            throw new ConverterException("Submitted value must be a String array");
        }
        String[] rawValues = (String[])submittedValue;
        if (rawValues.length == 0 && ConversionUtilities.renderedNull((UIComponent)this)) {
            return null;
        }
        Object cValue = null;
        try {
            if (this.valueTypeEvaluator.getValueType() == ValueType.ARRAY) {
                cValue = ConversionUtilities.convertValueToArray((UIComponent)this, rawValues, context);
            } else if (this.valueTypeEvaluator.getValueType() == ValueType.LIST) {
                throw new FacesException("List is not a supported value.");
            }
        }
        catch (FacesException facesException) {
            // empty catch block
        }
        return cValue;
    }

    protected String getValueAsReadOnly(FacesContext context) throws FacesException {
        StringBuilder valueBuffer = new StringBuilder();
        Iterator iterator = this.getListItems(context, false);
        while (iterator.hasNext()) {
            String string = ((ListItem)iterator.next()).getLabel();
            if (string.contains("nbsp")) continue;
            valueBuffer.append(string);
            if (!iterator.hasNext()) continue;
            valueBuffer.append(READ_ONLY_SEPARATOR);
        }
        return valueBuffer.toString();
    }

    @Override
    public UIComponent getReadOnlyValueComponent() {
        UIComponent textComponent = this.getFacet(READ_ONLY_FACET);
        if (textComponent != null) {
            return textComponent;
        }
        StaticText text = new StaticText();
        text.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, READ_ONLY_FACET));
        text.setParent((UIComponent)this);
        FacesContext context = FacesContext.getCurrentInstance();
        String readOnlyString = this.getValueAsReadOnly(context);
        if (readOnlyString == null || readOnlyString.length() < 1) {
            readOnlyString = new String();
        }
        text.setText(readOnlyString);
        return text;
    }

    private void log(String msg) {
        LogUtil.finest(OrderableList.class.getName() + "::" + msg);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    @Override
    public int getRows() {
        int listRows = this.doGetRows();
        if (listRows < 1) {
            listRows = 12;
            this.setRows(12);
        }
        return listRows;
    }

    @Override
    public String getOnChange() {
        return null;
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null || value == null) {
            return super.compareValues(previous, value);
        }
        if (value instanceof Object[]) {
            int length = Array.getLength(value);
            if (Array.getLength(previous) != length) {
                return true;
            }
            for (int i = 0; i < length; ++i) {
                Object newValue = Array.get(value, i);
                Object prevValue = Array.get(previous, i);
                if (newValue == null) {
                    if (prevValue == null) continue;
                    return true;
                }
                if (prevValue == null) {
                    return true;
                }
                if (prevValue.equals(newValue)) continue;
                return true;
            }
            return false;
        }
        return super.compareValues(previous, value);
    }

    @Override
    public boolean mainListSubmits() {
        return false;
    }

    public ValueExpression getValueExpression(String name) {
        if (name.equals("list")) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name.equals("list")) {
            super.setValueExpression("value", binding);
            return;
        }
        super.setValueExpression(name, binding);
    }

    public Object getValue() {
        return super.getValue();
    }

    @Override
    public boolean isDisabled() {
        if (this.disabledSet) {
            return this.disabled;
        }
        ValueExpression vb = this.getValueExpression("disabled");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setDisabled(boolean newDisabled) {
        this.disabled = newDisabled;
        this.disabledSet = true;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        ValueExpression vb = this.getValueExpression(LABEL_FACET);
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
    }

    public int getLabelLevel() {
        if (this.labelLevelSet) {
            return this.labelLevel;
        }
        ValueExpression vb = this.getValueExpression("labelLevel");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return 2;
    }

    public void setLabelLevel(int newLabelLevel) {
        this.labelLevel = newLabelLevel;
        this.labelLevelSet = true;
    }

    public boolean isLabelOnTop() {
        if (this.labelOnTopSet) {
            return this.labelOnTop;
        }
        ValueExpression vb = this.getValueExpression("labelOnTop");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setLabelOnTop(boolean newLabelOnTop) {
        this.labelOnTop = newLabelOnTop;
        this.labelOnTopSet = true;
    }

    public Object getList() {
        return this.getValue();
    }

    public void setList(Object newList) {
        this.setValue(newList);
    }

    public boolean isMoveTopBottom() {
        if (this.moveTopBottomSet) {
            return this.moveTopBottom;
        }
        ValueExpression vb = this.getValueExpression("moveTopBottom");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setMoveTopBottom(boolean newMoveTopBottom) {
        this.moveTopBottom = newMoveTopBottom;
        this.moveTopBottomSet = true;
    }

    @Override
    public boolean isMultiple() {
        if (this.multipleSet) {
            return this.multiple;
        }
        ValueExpression vb = this.getValueExpression("multiple");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setMultiple(boolean newMultiple) {
        this.multiple = newMultiple;
        this.multipleSet = true;
    }

    @Override
    public boolean isReadOnly() {
        if (this.readOnlySet) {
            return this.readOnly;
        }
        ValueExpression vb = this.getValueExpression(READ_ONLY_FACET);
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setReadOnly(boolean newReadOnly) {
        this.readOnly = newReadOnly;
        this.readOnlySet = true;
    }

    private int doGetRows() {
        if (this.rowsSet) {
            return this.rows;
        }
        ValueExpression vb = this.getValueExpression("rows");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return 12;
    }

    public void setRows(int newRows) {
        this.rows = newRows;
        this.rowsSet = true;
    }

    @Override
    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    @Override
    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    @Override
    public int getTabIndex() {
        if (this.tabIndexSet) {
            return this.tabIndex;
        }
        ValueExpression vb = this.getValueExpression("tabIndex");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setTabIndex(int newTabIndex) {
        this.tabIndex = newTabIndex;
        this.tabIndexSet = true;
    }

    @Override
    public String getToolTip() {
        if (this.toolTip != null) {
            return this.toolTip;
        }
        ValueExpression vb = this.getValueExpression("toolTip");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setToolTip(String newToolTip) {
        this.toolTip = newToolTip;
    }

    @Override
    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.disabled = (Boolean)values[1];
        this.disabledSet = (Boolean)values[2];
        this.label = (String)values[3];
        this.labelLevel = (Integer)values[4];
        this.labelLevelSet = (Boolean)values[5];
        this.labelOnTop = (Boolean)values[6];
        this.labelOnTopSet = (Boolean)values[7];
        this.moveTopBottom = (Boolean)values[8];
        this.moveTopBottomSet = (Boolean)values[9];
        this.multiple = (Boolean)values[10];
        this.multipleSet = (Boolean)values[11];
        this.readOnly = (Boolean)values[12];
        this.readOnlySet = (Boolean)values[13];
        this.rows = (Integer)values[14];
        this.rowsSet = (Boolean)values[15];
        this.style = (String)values[16];
        this.styleClass = (String)values[17];
        this.tabIndex = (Integer)values[18];
        this.tabIndexSet = (Boolean)values[19];
        this.toolTip = (String)values[20];
        this.visible = (Boolean)values[21];
        this.visibleSet = (Boolean)values[22];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.disabled ? Boolean.TRUE : Boolean.FALSE, this.disabledSet ? Boolean.TRUE : Boolean.FALSE, this.label, this.labelLevel, this.labelLevelSet ? Boolean.TRUE : Boolean.FALSE, this.labelOnTop ? Boolean.TRUE : Boolean.FALSE, this.labelOnTopSet ? Boolean.TRUE : Boolean.FALSE, this.moveTopBottom ? Boolean.TRUE : Boolean.FALSE, this.moveTopBottomSet ? Boolean.TRUE : Boolean.FALSE, this.multiple ? Boolean.TRUE : Boolean.FALSE, this.multipleSet ? Boolean.TRUE : Boolean.FALSE, this.readOnly ? Boolean.TRUE : Boolean.FALSE, this.readOnlySet ? Boolean.TRUE : Boolean.FALSE, this.rows, this.rowsSet ? Boolean.TRUE : Boolean.FALSE, this.style, this.styleClass, this.tabIndex, this.rowsSet ? Boolean.TRUE : Boolean.FALSE, this.toolTip, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }
}

