/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.model;

import com.sun.webui.jsf.model.scheduler.RepeatInterval;
import com.sun.webui.jsf.model.scheduler.RepeatUnit;
import com.sun.webui.jsf.util.LogUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

public final class ScheduledEvent
implements Serializable {
    private static final long serialVersionUID = 3470068141211045713L;
    private Date startTime = null;
    private Date endTime = null;
    private ArrayList<Object> dateList = null;
    private boolean repeatingEvent = false;
    private RepeatInterval frequency = null;
    private RepeatUnit durationUnit = null;
    private Integer duration = null;
    private static final boolean DEBUG = false;

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date newStartTime) {
        this.dateList = null;
        this.startTime = newStartTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date newEndTime) {
        this.endTime = newEndTime;
        this.dateList = null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getName());
        if (this.startTime != null) {
            buffer.append(": Start time: ");
            buffer.append(this.startTime.toString());
        } else {
            buffer.append(": No start time.");
        }
        if (this.endTime != null) {
            buffer.append("\tEnd time: ");
            buffer.append(this.endTime.toString());
            buffer.append(" ");
        } else {
            buffer.append("\tNo end time. ");
        }
        if (this.isRepeatingEvent()) {
            buffer.append("\tThis is a repeating event. ");
            buffer.append("\t Repeat frequency (Calendar.field): ");
            buffer.append(String.valueOf(this.frequency));
            if (this.duration != null) {
                buffer.append("\tLimited duration of repeats.");
                buffer.append("\tDuration is ");
                buffer.append(String.valueOf(this.duration));
                buffer.append(" of unit (in Calendar.field) ");
                buffer.append(String.valueOf(this.durationUnit));
            }
        } else {
            buffer.append("\tThis is not a repeating event. ");
        }
        return buffer.toString();
    }

    public boolean isRepeatingEvent() {
        return this.repeatingEvent;
    }

    public void setRepeatingEvent(boolean newRepeatingEvent) {
        this.repeatingEvent = newRepeatingEvent;
    }

    public RepeatInterval getRepeatInterval() {
        return this.frequency;
    }

    public void setRepeatInterval(RepeatInterval newFrequency) {
        this.frequency = newFrequency;
        this.dateList = null;
    }

    public RepeatUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(RepeatUnit newDurationUnit) {
        this.durationUnit = newDurationUnit;
        this.dateList = null;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer newDuration) {
        this.duration = newDuration;
        this.dateList = null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ScheduledEvent)) {
            return false;
        }
        ScheduledEvent event = (ScheduledEvent)object;
        if (this.getStartTime() == null ? event.getStartTime() != null : !this.getStartTime().equals(event.getStartTime())) {
            return false;
        }
        if (this.getEndTime() == null ? event.getEndTime() != null : !this.getEndTime().equals(event.getEndTime())) {
            return false;
        }
        if (this.getDuration() == null ? event.getDuration() != null : !this.getDuration().equals(event.getDuration())) {
            return false;
        }
        if (this.getDurationUnit() == null ? event.getDurationUnit() != null : !this.getDurationUnit().equals(event.getDurationUnit())) {
            return false;
        }
        return !(this.getRepeatInterval() == null ? event.getRepeatInterval() != null : !this.getRepeatInterval().equals(event.getRepeatInterval()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash;
        if (this.startTime != null) {
            hash += this.startTime.hashCode();
        }
        hash = 23 * hash;
        if (this.endTime != null) {
            hash += this.endTime.hashCode();
        }
        hash = 23 * hash;
        if (this.dateList != null) {
            hash += this.dateList.hashCode();
        }
        hash = 23 * hash;
        if (this.repeatingEvent) {
            ++hash;
        }
        hash = 23 * hash;
        if (this.frequency != null) {
            hash += this.frequency.hashCode();
        }
        hash = 23 * hash;
        if (this.durationUnit != null) {
            hash += this.durationUnit.hashCode();
        }
        hash = 23 * hash;
        if (this.duration != null) {
            hash += this.duration.hashCode();
        }
        return hash;
    }

    public Iterator getDates(Calendar untilDate) {
        return this.getDates(null, untilDate);
    }

    public Iterator getDates(Calendar fromDate, Calendar untilDate) {
        if (this.dateList != null) {
            return this.dateList.iterator();
        }
        this.dateList = new ArrayList();
        Date date = this.getStartTime();
        Date from = null;
        if (fromDate != null) {
            from = fromDate.getTime();
        }
        if (date != null && date.before(untilDate.getTime())) {
            int interval;
            Calendar startDate = (Calendar)untilDate.clone();
            startDate.setTime(date);
            this.dateList.add((Calendar)startDate.clone());
            if (this.isRepeatingEvent() && (interval = this.getRepeatInterval().getCalendarField().intValue()) > -1) {
                Calendar endCalendar = (Calendar)untilDate.clone();
                Integer dur = this.getDuration();
                RepeatUnit repeatUnit = this.getDurationUnit();
                Integer durUnit = null;
                if (repeatUnit != null) {
                    durUnit = repeatUnit.getCalendarField();
                }
                if (dur != null && durUnit != null) {
                    int durationValue = dur;
                    int durationField = durUnit;
                    if (durationValue > 0) {
                        endCalendar = (Calendar)startDate.clone();
                        endCalendar.add(durationField, durationValue);
                        endCalendar.set(interval, endCalendar.get(interval) - 1);
                        endCalendar.getTime();
                    }
                }
                Date end = endCalendar.getTime();
                Date current = startDate.getTime();
                while (current.before(end)) {
                    startDate.add(interval, 1);
                    current = startDate.getTime();
                    if (from != null) {
                        if (!current.after(from)) continue;
                        this.dateList.add(startDate.clone());
                        continue;
                    }
                    this.dateList.add(startDate.clone());
                }
            }
        }
        return this.dateList.iterator();
    }

    private static void log(String msg) {
        LogUtil.finest(ScheduledEvent.class.getName() + "::" + msg);
    }
}

