/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.data.provider.SortCriteria;
import com.sun.webui.jsf.component.TableColumn;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.util.Iterator;

public final class TableColumnRenderer
extends Renderer {
    private static final String[] STRING_ATTRIBUTES = new String[]{"abbr", "axis", "bgColor", "char", "charOff", "dir", "headers", "height", "lang", "onClick", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "style", "valign", "width"};

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            TableColumnRenderer.log("encodeBegin", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            TableColumnRenderer.log("encodeBegin", "Component not rendered, nothing to display");
            return;
        }
        TableColumn col = (TableColumn)component;
        Iterator<TableColumn> kids = col.getTableColumnChildren();
        if (!kids.hasNext()) {
            ResponseWriter writer = context.getResponseWriter();
            this.renderEnclosingTagStart(context, col, writer);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            TableColumnRenderer.log("encodeChildren", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            TableColumnRenderer.log("encodeChildren", "Component not rendered, nothing to display");
            return;
        }
        TableColumn col = (TableColumn)component;
        Iterator<TableColumn> kids = col.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn kid = kids.next();
                if (!kid.isRendered()) {
                    TableColumnRenderer.log("encodeChildren", "TableColumn not rendered, nothing to display");
                    continue;
                }
                RenderingUtilities.renderComponent((UIComponent)kid, context);
            }
        } else if (col.isEmptyCell()) {
            RenderingUtilities.renderComponent(col.getEmptyCellIcon(), context);
        } else {
            kids = col.getChildren().iterator();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                if (!kid.isRendered()) {
                    TableColumnRenderer.log("encodeChildren", "TableColumn child not rendered, nothing to display");
                    continue;
                }
                RenderingUtilities.renderComponent(kid, context);
                if (!kids.hasNext() || !col.isEmbeddedActions()) continue;
                RenderingUtilities.renderComponent(col.getEmbeddedActionSeparatorIcon(), context);
                ResponseWriter writer = context.getResponseWriter();
                writer.writeText((Object)" ", null);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            TableColumnRenderer.log("encodeEnd", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            TableColumnRenderer.log("encodeEnd", "Component not rendered, nothing to display");
            return;
        }
        TableColumn col = (TableColumn)component;
        Iterator<TableColumn> kids = col.getTableColumnChildren();
        if (!kids.hasNext()) {
            ResponseWriter writer = context.getResponseWriter();
            this.renderEnclosingTagEnd(context, col, writer);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderEnclosingTagStart(FacesContext context, TableColumn component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TableColumnRenderer.log("renderEnclosingTagStart", "Cannot render enclosing tag, UIComponent is null");
            return;
        }
        boolean isRowHeader = component.isRowHeader() && component.getSelectId() == null;
        writer.writeText((Object)"\n", null);
        if (isRowHeader) {
            writer.startElement("th", (UIComponent)component);
        } else {
            writer.startElement("td", (UIComponent)component);
        }
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)component, this.getStyleClass(component));
        if (component.getAlign() != null) {
            writer.writeAttribute("align", (Object)component.getAlign(), null);
        }
        if (isRowHeader) {
            writer.writeAttribute("scope", (Object)"row", null);
        } else if (component.getScope() != null) {
            writer.writeAttribute("scope", (Object)component.getScope(), null);
        }
        if (component.getColSpan() > -1) {
            writer.writeAttribute("colspan", (Object)Integer.toString(component.getColSpan()), null);
        }
        if (component.getRowSpan() > -1) {
            writer.writeAttribute("rowspan", (Object)Integer.toString(component.getRowSpan()), null);
        }
        if (component.isNoWrap()) {
            writer.writeAttribute("nowrap", (Object)"nowrap", null);
        }
        if (component.getToolTip() != null) {
            writer.writeAttribute("title", (Object)component.getToolTip(), "toolTip");
        }
        RenderingUtilities.writeStringAttributes((UIComponent)component, writer, STRING_ATTRIBUTES);
    }

    protected void renderEnclosingTagEnd(FacesContext context, TableColumn component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TableColumnRenderer.log("renderEnclosingTagEnd", "Cannot render enclosing tag, UIComponent is null");
            return;
        }
        if (component.isRowHeader() && component.getSelectId() == null) {
            writer.endElement("th");
        } else {
            writer.endElement("td");
        }
    }

    private String getStyleClass(TableColumn component) {
        String styleClass = null;
        if (component == null) {
            TableColumnRenderer.log("getStyleClass", "Cannot obtain style class, TableColumn is null");
            return styleClass;
        }
        TableRowGroup group = component.getTableRowGroupAncestor();
        SortCriteria criteria = component.getSortCriteria();
        int level = group != null ? group.getSortLevel(criteria) : -1;
        styleClass = component.isSpacerColumn() ? "TABLE_TD_SPACER" : (component.getSeverity() != null && !component.getSeverity().equals("ok") ? "TABLE_TD_ALARM" : (level == 1 ? (component.getSelectId() != null ? "TABLE_TD_SELECTCOL_SORT" : "TABLE_TD_SORT") : (component.getSelectId() != null ? "TABLE_TD_SELECTCOL" : "TABLE_TD_LAYOUT")));
        return this.getTheme().getStyleClass(styleClass);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private static void log(String method, String msg) {
        Class<TableColumnRenderer> clazz = TableColumnRenderer.class;
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + msg);
        }
    }
}

