/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Upload;
import com.sun.webui.jsf.renderkit.html.FieldRenderer;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.FacesException;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.fileupload.FileUploadBase;

public final class UploadRenderer
extends FieldRenderer {
    private static final boolean DEBUG = false;

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (component == null) {
            return;
        }
        Upload upload = (Upload)component;
        String id = component.getClientId(context).concat("_com.sun.webui.jsf.upload");
        Map map = context.getExternalContext().getRequestMap();
        if (map.containsKey(id)) {
            upload.setSubmittedValue(id);
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (component == null) {
            return;
        }
        if (!(component instanceof Upload)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Upload.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Upload.renderer", params);
            throw new FacesException(message);
        }
        Theme theme = ThemeUtilities.getTheme(context);
        Map map = context.getExternalContext().getRequestMap();
        Object error = map.get("upload_error_key");
        if (error != null && error instanceof Throwable) {
            if (error instanceof FileUploadBase.SizeLimitExceededException) {
                String maxSize = (String)map.get("file_size_key");
                Object[] detailArgs = new String[]{maxSize};
                String summaryMsg = theme.getMessage("FileUpload.noFile");
                String detailMsg = theme.getMessage("Upload.error", detailArgs);
                FacesMessage fmsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, summaryMsg, detailMsg);
                context.addMessage(((Upload)component).getClientId(context), fmsg);
            } else {
                String summaryMsg = theme.getMessage("FileUpload.noFile");
                throw new FacesException(summaryMsg, (Throwable)error);
            }
        }
        boolean spanRendered = super.renderField(context, (Upload)component, "file", this.getStyles(context));
        String id = component.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        JavaScriptUtilities.renderScripTag(writer, JavaScriptUtilities.renderCall("upload_set_encoding_type", id));
        if (!spanRendered) {
            String param = id.concat("_com.sun.webui.jsf.uploadParam");
            RenderingUtilities.renderHiddenField(component, writer, param, id);
        }
    }

    private static void log(String msg) {
        LogUtil.finest(UploadRenderer.class.getName() + "::" + msg);
    }
}

