/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.beans;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterAssociation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resources.api.JavaEEResource;
import org.glassfish.resources.api.JavaEEResourceBase;
import org.glassfish.resources.naming.SerializableObjectRefAddr;

public class AdministeredObjectResource
extends JavaEEResourceBase {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = LogDomains.getLogger(AdministeredObjectResource.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private String resadapter_;
    private String adminObjectClass_;
    private String adminObjectType_;
    private Set<ConnectorConfigProperty> configProperties_;

    public AdministeredObjectResource(ResourceInfo resourceInfo) {
        super(resourceInfo);
    }

    protected JavaEEResource doClone(ResourceInfo resourceInfo) {
        AdministeredObjectResource clone = new AdministeredObjectResource(resourceInfo);
        clone.setResourceAdapter(this.getResourceAdapter());
        clone.setAdminObjectType(this.getAdminObjectType());
        return clone;
    }

    public int getType() {
        return 0;
    }

    public void initialize(AdminObject desc) {
        this.configProperties_ = new HashSet<ConnectorConfigProperty>();
        this.adminObjectClass_ = desc.getAdminObjectClass();
        this.adminObjectType_ = desc.getAdminObjectInterface();
    }

    public String getResourceAdapter() {
        return this.resadapter_;
    }

    public void setResourceAdapter(String resadapter) {
        this.resadapter_ = resadapter;
    }

    public String getAdminObjectType() {
        return this.adminObjectType_;
    }

    public void setAdminObjectType(String adminObjectType) {
        this.adminObjectType_ = adminObjectType;
    }

    public void setAdminObjectClass(String name) {
        this.adminObjectClass_ = name;
    }

    public String getAdminObjectClass() {
        return this.adminObjectClass_;
    }

    public void addConfigProperty(ConnectorConfigProperty configProperty) {
        this.configProperties_.add(configProperty);
    }

    public void removeConfigProperty(ConnectorConfigProperty configProperty) {
        this.configProperties_.remove(configProperty);
    }

    public Reference createAdminObjectReference() {
        return new Reference(this.getAdminObjectType(), (RefAddr)new SerializableObjectRefAddr("jndiName", (Object)this), "com.sun.enterprise.resource.naming.AdministeredObjectFactory", null);
    }

    public Object createAdministeredObject(ClassLoader jcl) throws PoolingException {
        try {
            if (jcl == null) {
                PrivilegedAction<ClassLoader> action = () -> Thread.currentThread().getContextClassLoader();
                jcl = AccessController.doPrivileged(action);
            }
            Object adminObject = jcl.loadClass(this.adminObjectClass_).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            AccessController.doPrivileged(new SetMethodAction<ConnectorConfigProperty>(adminObject, this.configProperties_));
            if (adminObject instanceof ResourceAdapterAssociation) {
                try {
                    ResourceAdapter ra = ConnectorRegistry.getInstance().getActiveResourceAdapter(this.resadapter_).getResourceAdapter();
                    ((ResourceAdapterAssociation)adminObject).setResourceAdapter(ra);
                }
                catch (ResourceException ex) {
                    _logger.log(Level.SEVERE, "rardeployment.assoc_failed", ex);
                }
            }
            ConnectorRuntime.getRuntime().getConnectorBeanValidator().validateJavaBean(adminObject, this.resadapter_);
            return adminObject;
        }
        catch (PrivilegedActionException ex) {
            throw new PoolingException((Exception)ex);
        }
        catch (Exception ex) {
            throw new PoolingException(ex);
        }
    }

    public String toString() {
        return "< Administered Object : " + String.valueOf(this.getResourceInfo()) + " , " + this.getResourceAdapter() + " , " + this.getAdminObjectType() + " >";
    }
}

