/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class ObjectFieldKeySupport {
    private static final Object[] EMPTY = new Object[0];
    private Class clazz = null;
    private Map fields = null;
    private boolean includeFields = false;
    private Map keys = null;
    private Map props = null;

    public ObjectFieldKeySupport(Class clazz, boolean includeFields) {
        this.clazz = clazz;
        this.includeFields = includeFields;
        this.introspect();
    }

    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        return (FieldKey)this.keys.get(fieldId);
    }

    public FieldKey[] getFieldKeys() throws DataProviderException {
        return this.keys.values().toArray(new FieldKey[this.keys.size()]);
    }

    public Class getType(FieldKey fieldKey) throws DataProviderException {
        Field f;
        PropertyDescriptor pd = (PropertyDescriptor)this.props.get(fieldKey.getFieldId());
        if (pd != null) {
            return pd.getPropertyType();
        }
        if (this.includeFields && (f = (Field)this.fields.get(fieldKey.getFieldId())) != null) {
            return f.getType();
        }
        return null;
    }

    public Object getValue(FieldKey fieldKey, Object base) throws DataProviderException {
        Field f;
        if (base == null) {
            return null;
        }
        PropertyDescriptor pd = (PropertyDescriptor)this.props.get(fieldKey.getFieldId());
        if (pd != null && pd.getReadMethod() != null) {
            try {
                return pd.getReadMethod().invoke(base, EMPTY);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (this.includeFields && (f = (Field)this.fields.get(fieldKey.getFieldId())) != null) {
            try {
                return f.get(base);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public boolean isAssignable(FieldKey fieldKey, Object value) throws DataProviderException {
        Class type = this.getType(fieldKey);
        if (value == null) {
            return !type.isPrimitive();
        }
        Class<?> clazz = value.getClass();
        if (type.isAssignableFrom(clazz)) {
            return true;
        }
        return type.equals(Boolean.TYPE) && clazz.equals(Boolean.class) || type.equals(Integer.TYPE) && clazz.equals(Integer.class) || type.equals(Long.TYPE) && clazz.equals(Long.class) || type.equals(Double.TYPE) && clazz.equals(Double.class) || type.equals(Character.TYPE) && clazz.equals(Character.class) || type.equals(Byte.TYPE) && clazz.equals(Byte.class) || type.equals(Short.TYPE) && clazz.equals(Short.class) || type.equals(Float.TYPE) && clazz.equals(Float.class);
    }

    public boolean isReadOnly(FieldKey fieldKey) throws DataProviderException {
        Field f;
        PropertyDescriptor pd = (PropertyDescriptor)this.props.get(fieldKey.getFieldId());
        if (pd != null) {
            return pd.getWriteMethod() == null;
        }
        return !this.includeFields || (f = (Field)this.fields.get(fieldKey.getFieldId())) == null;
    }

    public void setValue(FieldKey fieldKey, Object base, Object value) throws DataProviderException {
        Field f;
        PropertyDescriptor pd = (PropertyDescriptor)this.props.get(fieldKey.getFieldId());
        if (pd != null) {
            if (pd.getWriteMethod() == null) {
                throw new IllegalStateException("" + fieldKey);
            }
            try {
                pd.getWriteMethod().invoke(base, value);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.includeFields && (f = (Field)this.fields.get(fieldKey.getFieldId())) != null) {
            try {
                f.set(base, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void introspect() {
        String name;
        this.props = new HashMap();
        if (this.includeFields) {
            this.fields = new HashMap();
        }
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.clazz);
            PropertyDescriptor[] props = bi.getPropertyDescriptors();
            for (int i = 0; i < props.length; ++i) {
                this.props.put(props[i].getName(), props[i]);
            }
            if (this.includeFields) {
                Field[] fields = this.clazz.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    if ((fields[i].getModifiers() & 1) == 0 || this.props.containsKey(fields[i].getName())) continue;
                    this.fields.put(fields[i].getName(), fields[i]);
                }
            }
        }
        catch (IntrospectionException ix) {
            ix.printStackTrace();
        }
        this.keys = new TreeMap();
        Iterator names = this.props.keySet().iterator();
        while (names.hasNext()) {
            name = (String)names.next();
            this.keys.put(name, new FieldKey(name));
        }
        if (this.includeFields) {
            names = this.fields.keySet().iterator();
            while (names.hasNext()) {
                name = (String)names.next();
                this.keys.put(name, new FieldKey(name));
            }
        }
    }
}

