/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansNestedException;
import org.netbeans.modules.schema2beansdev.DataListRestriction;
import org.netbeans.modules.schema2beansdev.DocDefHandler;
import org.netbeans.modules.schema2beansdev.GenBeans;
import org.netbeans.modules.schema2beansdev.GeneralParser;
import org.netbeans.modules.schema2beansdev.HasAnnotation;
import org.netbeans.modules.schema2beansdev.SchemaParser;
import org.netbeans.modules.schema2beansdev.SchemaRep;
import org.netbeans.modules.schema2beansdev.beangraph.BeanGraph;
import org.netbeans.modules.schema2beansdev.beangraph.SchemaTypeMappingType;
import org.netbeans.modules.schema2beansdev.gen.XMLWriter;
import org.netbeans.modules.schema2beansdev.metadd.MetaDD;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLSchemaParser
extends GeneralParser
implements SchemaParser {
    public static final String JAVA_TYPE_NS = "http://schema2beans.netbeans.org/javaTypes";
    private DocDefHandler handler;
    private boolean debug;
    private GenBeans.Config config = null;
    private Stack parentTypes = new Stack();
    private Stack parentUniqueNames = new Stack();
    private String lastDefinedType = null;
    private boolean lastDefinedExternalType = true;
    private List perAttributeExtraData = new LinkedList();
    private String targetNamespace;
    private Map elementsAlreadyDefined = new IdentityHashMap();
    SchemaRep schema;

    public XMLSchemaParser(GenBeans.Config config, DocDefHandler handler) {
        this.config = config;
        this.filename = config.getFilename();
        this.schemaIn = config.getFileIn();
        this.handler = handler;
        this.debug = config.isTraceParse();
        this.schema = new SchemaRep();
        SchemaRep.debug = this.debug;
        handler.setPrefixGuesser(this.schema);
    }

    @Override
    public void process() throws IOException, Schema2BeansException {
        this.startupReader();
        try {
            MetaDD mdd = this.config.getMetaDD();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlSchema = db.parse(new InputSource(this.reader));
            this.schema.setCurrentParsedURI(this.getReaderURI());
            if (this.config.isForME()) {
                this.schema.setSchemaTypesForME(true);
            }
            this.overrideSchemaTypes();
            this.schema.readDocument(xmlSchema);
        }
        catch (ParserConfigurationException e) {
            throw new Schema2BeansNestedException(Common.getMessage("MSG_FailedToParse", this.filename), e);
        }
        catch (SAXException e) {
            throw new Schema2BeansNestedException(Common.getMessage("MSG_FailedToParse", this.filename), e);
        }
        finally {
            this.shutdownReader();
        }
        if (this.debug) {
            PrintWriter pw = new PrintWriter(this.config.messageOut);
            this.schema.writeXMLSchemaStandalone(pw);
            pw.flush();
        }
        this.schema.optimize();
        this.handler.startDocument(this.config.getDocRoot());
        this.process(this.schema.getRootElement());
        this.handler.endDocument();
    }

    protected void overrideSchemaTypes() {
        String xsdNS = this.schema.getNamespaceURI("xsd");
        String xmlNS = this.schema.getNamespaceURI("xml");
        Iterator it = this.config.readBeanGraphs();
        while (it.hasNext()) {
            BeanGraph bg = (BeanGraph)it.next();
            for (int i = 0; i < bg.sizeSchemaTypeMapping(); ++i) {
                SchemaTypeMappingType stm = bg.getSchemaTypeMapping(i);
                if (!xsdNS.equals(stm.getSchemaTypeNamespace()) && !xmlNS.equals(stm.getSchemaTypeNamespace())) continue;
                this.setSchemaType(stm);
            }
        }
    }

    public void setSchemaType(BeanGraph bg) {
        for (int i = 0; i < bg.sizeSchemaTypeMapping(); ++i) {
            this.setSchemaType(bg.getSchemaTypeMapping(i));
        }
    }

    public void setSchemaType(SchemaTypeMappingType stm) {
        this.schema.setSchemaTypeMapping(stm.getSchemaTypeNamespace(), stm.getSchemaTypeName(), stm.getJavaType());
    }

    protected void process(SchemaRep.ElementExpr ee) throws Schema2BeansException {
        if (ee instanceof SchemaRep.Element) {
            this.processElement((SchemaRep.Element)ee);
        } else if (ee instanceof SchemaRep.ComplexType) {
            this.processComplexType((SchemaRep.ComplexType)ee);
        } else if (ee instanceof SchemaRep.UnionType) {
            this.processUnionType((SchemaRep.UnionType)ee);
        } else if (ee instanceof SchemaRep.SimpleType) {
            this.processSimpleType((SchemaRep.SimpleType)ee);
        } else if (ee instanceof SchemaRep.Restriction) {
            this.processRestriction((SchemaRep.Restriction)ee);
        } else if (ee instanceof SchemaRep.SchemaNode) {
            this.processSchemaNode((SchemaRep.SchemaNode)ee);
        } else if (ee instanceof SchemaRep.ElementInformationItem) {
            if (!this.parentTypes.empty()) {
                this.handler.addExtraDataNode((String)this.parentUniqueNames.peek(), (String)this.parentTypes.peek(), ee);
            }
        } else if (!(ee instanceof SchemaRep.RestrictionType)) {
            if (ee instanceof SchemaRep.ModelGroup) {
                this.processModelGroup((SchemaRep.ModelGroup)ee);
            } else if (ee instanceof SchemaRep.Annotation) {
                this.processAnnotation((SchemaRep.Annotation)ee);
            } else if (ee instanceof SchemaRep.Extension) {
                this.processExtension((SchemaRep.Extension)ee);
            } else if (ee instanceof SchemaRep.ContainsSubElements) {
                this.processContainsSubElements((SchemaRep.ContainsSubElements)ee);
            } else {
                this.config.messageOut.println("XMLSchemaPraser.process: Hit unknown ElementExpr: " + ee);
            }
        }
    }

    protected void processContainsSubElements(SchemaRep.ContainsSubElements cse) throws Schema2BeansException {
        Iterator it = cse.subElementsIterator();
        while (it.hasNext()) {
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            this.process(childee);
        }
    }

    protected void processContainsSubElementsAndAttributes(SchemaRep.ContainsSubElements cse, String elementName) throws Schema2BeansException {
        Iterator it = cse.subElementsIterator();
        while (it.hasNext()) {
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            if (childee instanceof SchemaRep.Attribute) {
                this.processAttribute(elementName, (SchemaRep.Attribute)childee);
                continue;
            }
            this.process(childee);
        }
    }

    protected void processElement(SchemaRep.Element el) throws Schema2BeansException {
        String javaType;
        SchemaRep.ElementExpr schemaTypeDef;
        boolean definedInSubElements;
        String schemaType;
        boolean alreadyDefined = false;
        if (this.elementsAlreadyDefined.containsKey(el)) {
            alreadyDefined = true;
        } else {
            this.elementsAlreadyDefined.put(el, el);
        }
        this.setLastDefined(this.config.getDefaultElementType(), true);
        this.perAttributeExtraData.clear();
        String name = el.getElementName();
        SchemaRep.Restriction[] restrict = null;
        boolean externalType = false;
        String namespace = this.targetNamespace;
        if (el.getRef() == null) {
            schemaType = el.getXMLSchemaType();
            namespace = el.getElementNamespace();
        } else {
            String ns;
            SchemaRep.Element referredElement = el.getRefElement();
            if (referredElement == null) {
                this.config.messageOut.println("referredElement is null for " + el);
                throw new IllegalStateException("referredElement is null for " + el);
            }
            if (this.elementsAlreadyDefined.containsKey(referredElement)) {
                alreadyDefined = true;
            } else {
                this.elementsAlreadyDefined.put(referredElement, el);
            }
            name = referredElement.getElementName();
            schemaType = referredElement.getXMLSchemaType();
            if (schemaType == null) {
                schemaType = name;
            }
            if ((ns = SchemaRep.prefixOf(name)) != null) {
                name = SchemaRep.removePrefix(name);
            }
            namespace = referredElement.getElementNamespace();
        }
        if (this.debug) {
            this.config.messageOut.println("processElement (start: elementName=" + name + " namespace=" + namespace);
        }
        if (name == null) {
            this.config.messageOut.println("WARNING: elementName is null.");
        }
        if (schemaType == null) {
            definedInSubElements = true;
            schemaType = name;
        } else {
            definedInSubElements = false;
        }
        String fullSchemaType = this.schema.resolveNamespaceDefault(schemaType, namespace);
        String defaultValue = el.getDefault();
        if (this.debug) {
            this.config.messageOut.println("processElement: name=" + name + " schemaType=" + schemaType + " fullSchemaType=" + fullSchemaType + " definedInSubElements=" + definedInSubElements);
        }
        if (!definedInSubElements) {
            SchemaRep.ContainsSubElements cse;
            String foundDefault;
            schemaTypeDef = this.schema.getSchemaTypeDef(schemaType);
            if (schemaTypeDef instanceof SchemaRep.ContainsSubElements && this.hasUnionType((SchemaRep.ContainsSubElements)schemaTypeDef)) {
                this.handler.setUnion(el.getFullContentName(), fullSchemaType, true);
            }
            if (schemaTypeDef instanceof SchemaRep.ContainsSubElements && (foundDefault = this.lookForDefault(restrict = this.lookForRestriction(cse = (SchemaRep.ContainsSubElements)schemaTypeDef))) != null) {
                defaultValue = foundDefault;
            }
            javaType = null;
            if (schemaTypeDef instanceof SchemaRep.HasJavaTypeName) {
                javaType = ((SchemaRep.HasJavaTypeName)((Object)schemaTypeDef)).getJavaTypeName();
            } else {
                String ns = SchemaRep.prefixOf(schemaType);
                String nsURI = this.schema.getNamespaceURI(ns);
                if (JAVA_TYPE_NS.equals(nsURI)) {
                    javaType = SchemaRep.removePrefix(schemaType);
                }
            }
            this.handler.element(el.getFullContentName(), fullSchemaType, name, namespace, XMLSchemaParser.getInstanceValue(el.getMinOccurs(), el.getMaxOccurs()), externalType, defaultValue);
            this.addExtraDataForType(el.getFullContentName(), fullSchemaType, schemaTypeDef);
            if (javaType != null) {
                this.handler.javaType(el.getFullContentName(), fullSchemaType, javaType);
                if (this.parentTypes.isEmpty()) {
                    String mySchemaType = this.schema.resolveNamespaceDefault(name, namespace);
                    this.handler.javaType(el.getFullContentName(), mySchemaType, javaType);
                }
            }
            this.handler.nillable(el.isNillable());
        } else {
            boolean existsAlready;
            restrict = this.lookForRestriction(el);
            while (!alreadyDefined && (existsAlready = this.handler.doesElementExist(fullSchemaType))) {
                int curlyBracePos;
                if (this.debug) {
                    this.config.messageOut.println("existsAlready: " + existsAlready + ",  " + el);
                }
                String contextName = null;
                if (!this.parentTypes.isEmpty() && (curlyBracePos = (contextName = (String)this.parentTypes.peek()).lastIndexOf(125)) >= 0) {
                    contextName = contextName.substring(curlyBracePos + 1);
                }
                if (contextName == null) {
                    contextName = "other";
                }
                fullSchemaType = fullSchemaType + '-' + contextName;
                if (!this.debug) continue;
                this.config.messageOut.println("New name: " + fullSchemaType);
            }
        }
        this.parentTypes.push(fullSchemaType);
        this.parentUniqueNames.push(el.getFullContentName());
        this.processContainsSubElements(el);
        this.parentUniqueNames.pop();
        this.parentTypes.pop();
        if (definedInSubElements) {
            if (!this.parentTypes.isEmpty()) {
                String foundDefault;
                if (restrict != null && (foundDefault = this.lookForDefault(restrict)) != null) {
                    defaultValue = foundDefault;
                }
                this.handler.element(el.getFullContentName(), this.lastDefinedType, name, namespace, XMLSchemaParser.getInstanceValue(el.getMinOccurs(), el.getMaxOccurs()), this.lastDefinedExternalType, defaultValue);
                this.handler.nillable(el.isNillable());
            }
            if ((schemaTypeDef = this.schema.getSchemaTypeDefResolvedNamespace(this.lastDefinedType)) instanceof SchemaRep.HasJavaTypeName && (javaType = ((SchemaRep.HasJavaTypeName)((Object)schemaTypeDef)).getJavaTypeName()) != null) {
                this.handler.javaType(el.getFullContentName(), this.lastDefinedType, javaType);
            }
        }
        if (restrict != null) {
            this.addExtraDataCurLink(restrict);
        }
        if (!"1".equals(el.getMaxOccurs()) && !"unbounded".equals(el.getMaxOccurs())) {
            this.handler.addExtraDataCurLink(new MaxOccursRestriction(el.getMaxOccurs()));
        }
        if (!"1".equals(el.getMinOccurs()) && !"0".equals(el.getMinOccurs())) {
            this.handler.addExtraDataCurLink(new MinOccursRestriction(el.getMinOccurs()));
        }
        if (this.perAttributeExtraData.size() > 0) {
            Iterator it = this.perAttributeExtraData.iterator();
            while (it.hasNext()) {
                this.handler.addExtraDataCurLink(it.next());
            }
        }
        if (this.debug) {
            this.config.messageOut.println("processElement finish): elementName=" + name);
        }
    }

    protected boolean hasUnionType(SchemaRep.ContainsSubElements schemaTypeDef) {
        if (schemaTypeDef instanceof SchemaRep.UnionType) {
            return true;
        }
        Iterator itr = schemaTypeDef.subElementsIterator();
        while (itr.hasNext()) {
            SchemaRep.ElementExpr ee = (SchemaRep.ElementExpr)itr.next();
            if (!(ee instanceof SchemaRep.ContainsSubElements) || !this.hasUnionType((SchemaRep.ContainsSubElements)ee)) continue;
            return true;
        }
        return false;
    }

    protected SchemaRep.Restriction[] lookForRestriction(SchemaRep.ContainsSubElements schemaTypeDef) {
        if (schemaTypeDef instanceof SchemaRep.UnionType) {
            ArrayList<SchemaRep.Restriction> restrictions = new ArrayList<SchemaRep.Restriction>();
            SchemaRep.Restriction[] restricts = null;
            SchemaRep.ElementExpr[] eeList = ((SchemaRep.UnionType)schemaTypeDef).getMemberTypeElements();
            if (eeList != null) {
                for (int i = 0; i < eeList.length; ++i) {
                    restricts = null;
                    if (eeList[i] instanceof SchemaRep.ContainsSubElements) {
                        restricts = this.lookForRestriction((SchemaRep.ContainsSubElements)eeList[i]);
                    }
                    if (restricts == null) continue;
                    for (int j = 0; j < restricts.length; ++j) {
                        restrictions.add(restricts[j]);
                    }
                }
            }
            Iterator itr = schemaTypeDef.subElementsIterator();
            while (itr.hasNext()) {
                restricts = null;
                SchemaRep.ElementExpr ee = (SchemaRep.ElementExpr)itr.next();
                if (!(ee instanceof SchemaRep.ContainsSubElements) || (restricts = this.lookForRestriction((SchemaRep.ContainsSubElements)ee)) == null) continue;
                for (int i = 0; i < restricts.length; ++i) {
                    restrictions.add(restricts[i]);
                }
            }
            if (restrictions.size() == 0) {
                return null;
            }
            restricts = new SchemaRep.Restriction[restrictions.size()];
            return restrictions.toArray(restricts);
        }
        if (schemaTypeDef instanceof SchemaRep.SimpleType) {
            SchemaRep.ContainsSubElements sube = (SchemaRep.ContainsSubElements)schemaTypeDef.findSubElement(SchemaRep.UnionType.class);
            if (sube != null) {
                return this.lookForRestriction(sube);
            }
            SchemaRep.Restriction restrict = (SchemaRep.Restriction)schemaTypeDef.findSubElement(SchemaRep.Restriction.class);
            if (restrict == null) {
                return null;
            }
            ArrayList<SchemaRep.Restriction> restrictions = new ArrayList<SchemaRep.Restriction>();
            restrictions.add(restrict);
            if (restrict.getBase() != null) {
                SchemaRep.ElementExpr baseee;
                SchemaRep.Restriction[] baseRestrictions;
                String unprefixedTypeName = SchemaRep.removePrefix(restrict.getBase());
                if (!this.schema.isPredefinedType(unprefixedTypeName) && (baseRestrictions = this.lookForRestriction((SchemaRep.ContainsSubElements)(baseee = this.schema.getSchemaTypeDef(restrict.getBase())))) != null) {
                    List<SchemaRep.Restriction> rList = Arrays.asList(baseRestrictions);
                    restrictions.addAll(rList);
                }
            }
            if (restrictions.size() == 0) {
                return null;
            }
            SchemaRep.Restriction[] restrictArray = new SchemaRep.Restriction[restrictions.size()];
            return restrictions.toArray(restrictArray);
        }
        if (schemaTypeDef instanceof SchemaRep.SimpleContent) {
            SchemaRep.Restriction restrict = (SchemaRep.Restriction)schemaTypeDef.findSubElement(SchemaRep.Restriction.class);
            if (restrict == null) {
                return null;
            }
            return new SchemaRep.Restriction[]{restrict};
        }
        if (schemaTypeDef instanceof SchemaRep.Element) {
            return this.lookForRestriction((SchemaRep.ContainsSubElements)schemaTypeDef.findSubElement(SchemaRep.SimpleType.class));
        }
        if (schemaTypeDef instanceof SchemaRep.ComplexType) {
            return this.lookForRestriction((SchemaRep.ContainsSubElements)schemaTypeDef.findSubElement(SchemaRep.SimpleContent.class));
        }
        return null;
    }

    protected void processComplexType(SchemaRep.ComplexType el) throws Schema2BeansException {
        this.setLastDefined(null, true);
        String name = el.getTypeName();
        if (this.debug) {
            this.config.messageOut.println("processComplexType: el=" + el);
        }
        if (name == null) {
            if (this.debug) {
                this.config.messageOut.println("Found unnamed complexType.");
            }
            if (!this.parentTypes.isEmpty()) {
                name = (String)this.parentTypes.peek();
            }
            if (name == null) {
                name = el.getFullContentName();
            }
        } else {
            name = this.schema.resolveNamespace(name);
        }
        this.parentTypes.push(name);
        this.parentUniqueNames.push(el.getFullContentName());
        this.handler.startElement(el.getFullContentName(), name, 2);
        this.handler.setAbstract(el.getFullContentName(), name, el.isAbstract());
        Iterator it = el.subElementsIterator();
        while (it.hasNext()) {
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            if (childee instanceof SchemaRep.ModelGroup) {
                this.processModelGroup((SchemaRep.ModelGroup)childee);
                continue;
            }
            if (childee instanceof SchemaRep.Attribute) {
                this.processAttribute(name, (SchemaRep.Attribute)childee);
                continue;
            }
            if (childee instanceof SchemaRep.AttributeGroup) {
                this.processAttributeGroup(name, (SchemaRep.AttributeGroup)childee);
                continue;
            }
            if (childee instanceof SchemaRep.SimpleContent) {
                this.processSimpleContent((SchemaRep.SimpleContent)childee);
                continue;
            }
            if (childee instanceof SchemaRep.Annotation) {
                this.processAnnotation((SchemaRep.Annotation)childee);
                continue;
            }
            if (childee instanceof SchemaRep.ComplexContent) {
                this.processComplexContent((SchemaRep.ComplexContent)childee);
                continue;
            }
            this.config.messageOut.println("processComplexType: Unfamiliar subelement: " + childee);
        }
        this.handler.endElement();
        this.parentUniqueNames.pop();
        this.parentTypes.pop();
        this.setLastDefined(name, false);
    }

    protected void processComplexContent(SchemaRep.ComplexContent el) throws Schema2BeansException {
        Iterator it = el.subElementsIterator();
        while (it.hasNext()) {
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            if (childee instanceof SchemaRep.Extension) {
                this.processExtension((SchemaRep.Extension)childee);
                continue;
            }
            if (childee instanceof SchemaRep.Restriction) {
                this.processRestriction((SchemaRep.Restriction)childee);
                continue;
            }
            if (childee instanceof SchemaRep.Annotation) {
                this.processAnnotation((SchemaRep.Annotation)childee);
                continue;
            }
            this.config.messageOut.println("processComplexContent: Unfamiliar subelement: " + childee);
        }
    }

    protected void processSimpleContent(SchemaRep.SimpleContent el) throws Schema2BeansException {
        this.processContainsSubElements(el);
        if (this.lastDefinedType == null) {
            return;
        }
        SchemaRep.ElementExpr schemaTypeDef = this.schema.getSchemaTypeDefResolvedNamespace(this.lastDefinedType);
        if (schemaTypeDef == null) {
            return;
        }
        String javaType = null;
        if (schemaTypeDef instanceof SchemaRep.HasJavaTypeName) {
            javaType = ((SchemaRep.HasJavaTypeName)((Object)schemaTypeDef)).getJavaTypeName();
        }
        this.addExtraDataForType((String)this.parentUniqueNames.peek(), (String)this.parentTypes.peek(), schemaTypeDef);
        if (javaType != null) {
            this.handler.javaType((String)this.parentUniqueNames.peek(), (String)this.parentTypes.peek(), javaType);
        }
    }

    protected void processExtension(SchemaRep.Extension el) throws Schema2BeansException {
        String javaType;
        if (this.debug) {
            this.config.messageOut.println("extension el=" + el);
        }
        String uniqueName = (String)this.parentUniqueNames.peek();
        String name = (String)this.parentTypes.peek();
        String base = el.getBase();
        SchemaRep.ElementExpr baseDef = this.schema.getSchemaTypeDef(base);
        SchemaRep.Restriction[] restrict = null;
        if (baseDef instanceof SchemaRep.ContainsSubElements) {
            restrict = this.lookForRestriction((SchemaRep.ContainsSubElements)baseDef);
            if (!this.config.isRespectExtension()) {
                this.processContainsSubElementsAndAttributes((SchemaRep.ContainsSubElements)baseDef, name);
            }
        }
        this.addExtraDataForType(uniqueName, name, baseDef);
        if (baseDef instanceof SchemaRep.ComplexType) {
            SchemaRep.ComplexType complexType = (SchemaRep.ComplexType)baseDef;
            String resolvedExtendsName = this.schema.resolveNamespace(complexType.getTypeName());
            this.handler.setExtension(uniqueName, name, resolvedExtendsName);
        }
        if ((javaType = el.getJavaTypeName()) != null) {
            if (this.debug) {
                this.config.messageOut.println("Setting javatype of " + name + " to " + javaType);
            }
            this.handler.javaType(uniqueName, name, javaType);
            if (restrict != null) {
                this.addExtraDataNode(uniqueName, name, restrict);
            }
        }
        this.processContainsSubElementsAndAttributes(el, name);
    }

    protected void addExtraDataForType(String uniqueName, String name, SchemaRep.ElementExpr schemaTypeDef) throws Schema2BeansException {
        SchemaRep.Restriction[] restrict;
        if (schemaTypeDef instanceof SchemaRep.Base64Binary || schemaTypeDef instanceof SchemaRep.HexBinary) {
            this.handler.addExtraDataNode(uniqueName, name, schemaTypeDef);
        } else if (schemaTypeDef instanceof SchemaRep.ContainsSubElements && (restrict = this.lookForRestriction((SchemaRep.ContainsSubElements)schemaTypeDef)) != null) {
            for (int i = 0; i < restrict.length; ++i) {
                this.addExtraDataForType(uniqueName, name, this.schema.getSchemaTypeDef(restrict[i].getBase()));
            }
        }
    }

    protected void processModelGroup(SchemaRep.ModelGroup group) throws Schema2BeansException {
        if (this.debug) {
            this.config.messageOut.println("processModelGroup: group=" + group);
        }
        if (group instanceof SchemaRep.Group) {
            SchemaRep.Group grp = (SchemaRep.Group)group;
            if (grp.getRef() == null) {
                return;
            }
            SchemaRep.Group referredGroup = grp.getRefGroup();
            if (referredGroup == null) {
                this.config.messageOut.println(Common.getMessage("MSG_UnableToFind", "group", grp.getRef()));
            } else {
                this.processContainsSubElements(referredGroup);
            }
            return;
        }
        char separator = ' ';
        if (group instanceof SchemaRep.Sequence) {
            separator = ',';
        } else if (group instanceof SchemaRep.Choice) {
            separator = '|';
        }
        int groupInstance = XMLSchemaParser.getInstanceValue(group.getMinOccurs(), group.getMaxOccurs());
        this.handler.startGroupElements();
        boolean first = true;
        Iterator it = group.subElementsIterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                this.handler.character(separator);
            }
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            if (childee instanceof SchemaRep.Element) {
                this.processElement((SchemaRep.Element)childee);
                continue;
            }
            if (childee instanceof SchemaRep.ModelGroup) {
                this.processModelGroup((SchemaRep.ModelGroup)childee);
                continue;
            }
            if (childee instanceof SchemaRep.Annotation) continue;
            if (childee instanceof SchemaRep.Any) {
                this.processAny((SchemaRep.Any)childee);
                continue;
            }
            this.config.messageOut.println("processModelGroup: Unfamiliar subelement: " + childee);
        }
        this.handler.endGroupElements(groupInstance);
    }

    protected void processSimpleType(SchemaRep.SimpleType el) throws Schema2BeansException {
        if (this.debug) {
            this.config.messageOut.println("processSimpleType: el=" + el);
        }
        this.processContainsSubElements(el);
    }

    protected void processUnionType(SchemaRep.UnionType el) throws Schema2BeansException {
        if (this.debug) {
            this.config.messageOut.println("processUnionType: el=" + el);
        }
        this.processContainsSubElements(el);
    }

    protected void processRestriction(SchemaRep.Restriction el) throws Schema2BeansException {
        this.setLastDefined(this.schema.resolveNamespace(el.getBase()), false);
        this.processContainsSubElements(el);
    }

    protected void processAny(SchemaRep.Any el) throws Schema2BeansException {
        String namespace;
        if (this.debug) {
            this.config.messageOut.println("Found " + el);
        }
        if ((namespace = el.getNamespace()) != null && namespace.startsWith("##")) {
            namespace = null;
        }
        this.handler.element(el.getFullContentName(), "any", "any", namespace, XMLSchemaParser.getInstanceValue(el.getMinOccurs(), el.getMaxOccurs()), true, null);
        this.handler.javaType("any", "any", "org.w3c.dom.Element");
        this.handler.addExtraDataCurLink(el);
    }

    protected void processSchemaNode(SchemaRep.SchemaNode sn) throws Schema2BeansException {
        this.targetNamespace = sn.getTargetNamespace();
        if (this.targetNamespace != null && !"".equals(this.targetNamespace)) {
            this.handler.setDefaultNamespace(this.targetNamespace);
        }
        this.processContainsSubElements(sn);
    }

    protected void setLastDefined(String typeName) {
        this.lastDefinedType = typeName;
        this.lastDefinedExternalType = false;
    }

    protected void setLastDefined(String typeName, boolean externalType) {
        this.lastDefinedType = typeName;
        this.lastDefinedExternalType = externalType;
    }

    protected void addTopAttributes(SchemaRep.Element parentElement, SchemaRep.Element el) {
        Iterator it = el.subElementsIterator();
        while (it.hasNext()) {
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            if (childee instanceof SchemaRep.Attribute || childee instanceof SchemaRep.AttributeGroup || !(childee instanceof SchemaRep.ComplexType)) continue;
            this.addTopAttributes(parentElement, (SchemaRep.ComplexType)childee);
        }
    }

    protected void addTopAttributes(SchemaRep.Element parentElement, SchemaRep.ComplexType el) {
        Iterator it = el.subElementsIterator();
        while (it.hasNext()) {
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            if (!(childee instanceof SchemaRep.Attribute) && !(childee instanceof SchemaRep.AttributeGroup)) continue;
        }
    }

    protected void processAttribute(String parentElement, SchemaRep.Attribute attr) throws Schema2BeansException {
        if (this.debug) {
            this.config.messageOut.println("processAttribute to " + parentElement + " attr=" + attr);
        }
        if (attr.getRef() != null) {
            SchemaRep.Attribute referredAttr = attr.getRefAttribute();
            if (referredAttr == null) {
                this.config.messageOut.println(Common.getMessage("MSG_UnableToFind", "attribute", attr.getRef()));
            } else {
                this.processAttribute(parentElement, referredAttr);
            }
            return;
        }
        String attributeName = attr.getAttributeName();
        boolean externalType = true;
        String attrType = attr.getJavaType();
        String schemaType = attr.getType();
        String defaultValue = attr.getDefaultValue();
        SchemaRep.Restriction[] restrict = null;
        SchemaRep.ElementExpr ee = null;
        if (schemaType != null && defaultValue == null) {
            ee = this.schema.getSchemaTypeDef(schemaType);
            if (ee instanceof SchemaRep.SimpleType) {
                String foundDefault;
                SchemaRep.SimpleType st = (SchemaRep.SimpleType)ee;
                SchemaRep.Restriction r = (SchemaRep.Restriction)st.findSubElement("restriction");
                if (r != null) {
                    restrict = new SchemaRep.Restriction[]{r};
                }
                if ((foundDefault = this.lookForDefault(restrict)) != null) {
                    defaultValue = foundDefault;
                }
            } else {
                this.config.messageOut.println("Type for attribute " + attributeName + " is not simple enough: " + ee);
            }
        }
        int instance = defaultValue != null || attr.getFixed() != null || attr.isRequired() ? 32 : 16;
        this.handler.startElement(attr.getFullContentName(), parentElement, 3);
        this.handler.element(attr.getFullContentName(), attrType, attributeName, attr.getAttributeNamespace(), instance, externalType, defaultValue);
        this.handler.element("CDATA", "CDATA", instance);
        if (attr.getFixed() != null) {
            this.handler.element("#FIXED", "#FIXED", instance);
            this.handler.element(attr.getFullContentName(), attrType, attr.getFixed(), null, instance, externalType, defaultValue);
        } else if (attr.isRequired()) {
            this.handler.element("#REQUIRED", "#REQUIRED", instance);
        } else {
            this.handler.element("#IMPLIED", "#IMPLIED", instance);
        }
        this.handler.javaType(attr.getFullContentName(), attr.getAttributeName(), attrType);
        if (ee != null) {
            this.addExtraDataForType(attr.getFullContentName(), attr.getAttributeName(), ee);
        }
        if (restrict != null) {
            this.addExtraDataCurLink(restrict);
        }
        this.handler.endElement();
    }

    protected void addExtraDataCurLink(SchemaRep.Restriction[] restrict) {
        for (int i = 0; i < restrict.length; ++i) {
            if (!restrict[i].subElementsIterator().hasNext()) continue;
            this.handler.addExtraDataCurLink(restrict[i]);
        }
    }

    protected void addExtraDataNode(String uniqueName, String name, SchemaRep.Restriction[] restrict) throws Schema2BeansException {
        for (int i = 0; i < restrict.length; ++i) {
            if (!restrict[i].subElementsIterator().hasNext()) continue;
            this.handler.addExtraDataNode(uniqueName, name, restrict[i]);
        }
    }

    protected String lookForDefault(SchemaRep.Restriction[] restrict) {
        if (this.config.isMakeDefaults() && restrict != null) {
            for (int i = 0; i < restrict.length; ++i) {
                Iterator subelements = restrict[i].subElementsIterator();
                while (subelements.hasNext()) {
                    Object rt = subelements.next();
                    if (!(rt instanceof SchemaRep.Enumeration)) continue;
                    String defaultValue = ((SchemaRep.Enumeration)rt).getValue();
                    return defaultValue;
                }
            }
        }
        return null;
    }

    protected void processAttributeGroup(String parentElement, SchemaRep.AttributeGroup attrGroup) throws Schema2BeansException {
        SchemaRep.AttributeGroup schemaTypeDef = (SchemaRep.AttributeGroup)this.schema.getSchemaTypeDef(attrGroup.getRef());
        if (this.debug) {
            this.config.messageOut.println("processAttributeGroup schemaTypeDef=" + schemaTypeDef);
        }
        if (schemaTypeDef == null) {
            throw new IllegalStateException("attributeGroup ref has reference to unknown name: " + attrGroup.getRef());
        }
        Iterator it = schemaTypeDef.subElementsIterator();
        while (it.hasNext()) {
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            if (childee instanceof SchemaRep.Attribute) {
                this.processAttribute(parentElement, (SchemaRep.Attribute)childee);
                continue;
            }
            if (!(childee instanceof SchemaRep.AttributeGroup)) continue;
            this.processAttributeGroup(parentElement, (SchemaRep.AttributeGroup)childee);
        }
    }

    protected void processAnnotation(SchemaRep.Annotation ann) throws Schema2BeansException {
        SchemaRep.AppInfo appInfo;
        SchemaRep.Documentation doc = (SchemaRep.Documentation)ann.findSubElement(SchemaRep.Documentation.class);
        String name = null;
        if (!this.parentTypes.isEmpty()) {
            name = (String)this.parentTypes.peek();
        }
        if (name == null) {
            return;
        }
        String uniqueName = (String)this.parentUniqueNames.peek();
        if (doc != null) {
            StringBuffer comment = new StringBuffer();
            Iterator subelements = doc.subElementsIterator();
            while (subelements.hasNext()) {
                SchemaRep.ElementExpr el = (SchemaRep.ElementExpr)subelements.next();
                if (el instanceof SchemaRep.TextNode) {
                    comment.append(((SchemaRep.TextNode)el).getText());
                    continue;
                }
                if (!(el instanceof SchemaRep.AnyNode)) continue;
                try {
                    XMLWriter xw = new XMLWriter(false);
                    ((SchemaRep.AnyNode)el).writeXMLSchema(xw);
                    xw.writeTo(comment);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.handler.setExtendedProperty(uniqueName, name, "comment", comment.toString());
        }
        if ((appInfo = (SchemaRep.AppInfo)ann.findSubElement(SchemaRep.AppInfo.class)) != null) {
            String switchName = null;
            String switchHelp = null;
            boolean switchMandatory = false;
            Iterator subelements = appInfo.subElementsIterator();
            while (subelements.hasNext()) {
                SchemaRep.TextNode value;
                SchemaRep.AnyNode anyNode;
                String anyNodeName;
                SchemaRep.ElementExpr el = (SchemaRep.ElementExpr)subelements.next();
                if (!(el instanceof SchemaRep.AnyNode) || (anyNodeName = (anyNode = (SchemaRep.AnyNode)el).getContentName()) == null) continue;
                if ("extends" == (anyNodeName = anyNodeName.intern())) {
                    value = (SchemaRep.TextNode)anyNode.findSubElement(SchemaRep.TextNode.class);
                    if (value == null) continue;
                    this.handler.setExtendedProperty(uniqueName, name, "extends", value.getText());
                    continue;
                }
                if ("implements" == anyNodeName) {
                    value = (SchemaRep.TextNode)anyNode.findSubElement(SchemaRep.TextNode.class);
                    if (value == null) continue;
                    this.handler.setExtendedProperty(uniqueName, name, "implements", value.getText());
                    continue;
                }
                if ("switch" == anyNodeName) {
                    value = (SchemaRep.TextNode)anyNode.findSubElement(SchemaRep.TextNode.class);
                    if (value == null) continue;
                    switchName = value.getText();
                    continue;
                }
                if ("switchHelp" == anyNodeName) {
                    value = (SchemaRep.TextNode)anyNode.findSubElement(SchemaRep.TextNode.class);
                    if (value == null) continue;
                    switchHelp = value.getText();
                    continue;
                }
                if ("switchMandatory" != anyNodeName || (value = (SchemaRep.TextNode)anyNode.findSubElement(SchemaRep.TextNode.class)) == null) continue;
                switchMandatory = "true".equalsIgnoreCase(value.getText());
            }
            if (switchName != null) {
                this.perAttributeExtraData.add(new SwitchData(switchName, switchHelp, switchMandatory));
            }
        }
    }

    protected static int getInstanceValue(String minOccurs, String maxOccurs) {
        if (minOccurs == null) {
            minOccurs = "1";
        }
        if (maxOccurs == null) {
            maxOccurs = "1";
        }
        if (minOccurs.equals("0")) {
            if (maxOccurs.equals("1")) {
                return 16;
            }
            return 48;
        }
        if (maxOccurs.equals("1")) {
            return 32;
        }
        return 64;
    }

    public static class SwitchData {
        private String switchName;
        private String switchHelp;
        private boolean mandatory;

        public SwitchData(String switchName) {
            this.switchName = switchName;
        }

        public SwitchData(String switchName, String switchHelp) {
            this.switchName = switchName;
            this.switchHelp = switchHelp;
        }

        public SwitchData(String switchName, String switchHelp, boolean mandatory) {
            this.switchName = switchName;
            this.switchHelp = switchHelp;
            this.mandatory = mandatory;
        }

        public String getName() {
            return this.switchName;
        }

        public String getHelp() {
            return this.switchHelp;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public String toString() {
            return "Switch";
        }
    }

    public static class GeneralAnnotation
    implements HasAnnotation {
        private String annotation;

        public GeneralAnnotation(String annotation) {
            this.annotation = annotation;
        }

        @Override
        public String genAnnotation() {
            return this.annotation;
        }
    }

    public static class MinOccursRestriction
    implements DataListRestriction {
        private String minOccurs;

        public MinOccursRestriction(String minOccurs) {
            this.minOccurs = minOccurs;
        }

        @Override
        public void genRestriction(Writer out, String sizeExpr, String readMethod, String type, String failVar, boolean passCheck) throws IOException {
            if (!passCheck) {
                out.write("if (" + sizeExpr + " < " + this.minOccurs + ") {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            } else {
                out.write("if (" + sizeExpr + " >= " + this.minOccurs + ") {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            }
        }

        public int getMinOccurs() {
            return Integer.parseInt(this.minOccurs);
        }

        public String toString() {
            return "minOccurs (" + this.minOccurs + ")";
        }

        public String genAnnotation() {
            return "MinOccurs(" + this.minOccurs + ")";
        }
    }

    public static class MaxOccursRestriction
    implements DataListRestriction {
        private String maxOccurs;

        public MaxOccursRestriction(String maxOccurs) {
            this.maxOccurs = maxOccurs;
        }

        @Override
        public void genRestriction(Writer out, String sizeExpr, String readMethod, String type, String failVar, boolean passCheck) throws IOException {
            if (!passCheck) {
                out.write("if (" + sizeExpr + " > " + this.maxOccurs + ") {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            } else {
                out.write("if (" + sizeExpr + " <= " + this.maxOccurs + ") {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            }
        }

        public int getMaxOccurs() {
            if ("unbounded".equalsIgnoreCase(this.maxOccurs)) {
                return Integer.MAX_VALUE;
            }
            return Integer.parseInt(this.maxOccurs);
        }

        public String toString() {
            return "maxOccurs (" + this.maxOccurs + ")";
        }

        public String genAnnotation() {
            return "MaxOccurs(" + this.maxOccurs + ")";
        }
    }
}

