/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import jakarta.inject.Provider;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Configuration;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.glassfish.jersey.innate.inject.Bindings;
import org.glassfish.jersey.innate.inject.InjectionIds;
import org.glassfish.jersey.innate.inject.InstanceBinding;
import org.glassfish.jersey.internal.BootstrapBag;
import org.glassfish.jersey.internal.BootstrapConfigurator;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.server.AsyncContext;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ServerBootstrapBag;
import org.glassfish.jersey.server.Uri;
import org.glassfish.jersey.server.internal.inject.AsyncResponseValueParamProvider;
import org.glassfish.jersey.server.internal.inject.BeanParamValueParamProvider;
import org.glassfish.jersey.server.internal.inject.CookieParamValueParamProvider;
import org.glassfish.jersey.server.internal.inject.DelegatedInjectionValueParamProvider;
import org.glassfish.jersey.server.internal.inject.EntityParamValueParamProvider;
import org.glassfish.jersey.server.internal.inject.FormParamValueParamProvider;
import org.glassfish.jersey.server.internal.inject.HeaderParamValueParamProvider;
import org.glassfish.jersey.server.internal.inject.MatrixParamValueParamProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.internal.inject.PathParamValueParamProvider;
import org.glassfish.jersey.server.internal.inject.QueryParamValueParamProvider;
import org.glassfish.jersey.server.internal.inject.WebTargetValueParamProvider;
import org.glassfish.jersey.server.internal.process.RequestProcessingContextReference;
import org.glassfish.jersey.server.spi.internal.ValueParamProvider;

public class ValueParamProviderConfigurator
implements BootstrapConfigurator {
    public void init(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
        ServerBootstrapBag serverBag = (ServerBootstrapBag)bootstrapBag;
        Provider asyncContextProvider = () -> {
            RequestProcessingContextReference reference = (RequestProcessingContextReference)injectionManager.getInstance(RequestProcessingContextReference.class);
            return reference.get().asyncContext();
        };
        LazyValue lazyContextResolver = Values.lazy(() -> (ContextInjectionResolver)injectionManager.getInstance(ContextInjectionResolver.class));
        Supplier<Configuration> configuration = () -> ((ServerBootstrapBag)serverBag).getConfiguration();
        Provider paramExtractor = serverBag::getMultivaluedParameterExtractorProvider;
        ArrayList<ValueParamProvider> suppliers = new ArrayList<ValueParamProvider>();
        AsyncResponseValueParamProvider asyncProvider = new AsyncResponseValueParamProvider((Provider<AsyncContext>)asyncContextProvider);
        suppliers.add(asyncProvider);
        CookieParamValueParamProvider cookieProvider = new CookieParamValueParamProvider((Provider<MultivaluedParameterExtractorProvider>)paramExtractor);
        suppliers.add(cookieProvider);
        EntityParamValueParamProvider entityProvider = new EntityParamValueParamProvider((Provider<MultivaluedParameterExtractorProvider>)paramExtractor);
        suppliers.add(entityProvider);
        FormParamValueParamProvider formProvider = new FormParamValueParamProvider((Provider<MultivaluedParameterExtractorProvider>)paramExtractor, injectionManager);
        suppliers.add(formProvider);
        HeaderParamValueParamProvider headerProvider = new HeaderParamValueParamProvider((Provider<MultivaluedParameterExtractorProvider>)paramExtractor);
        suppliers.add(headerProvider);
        MatrixParamValueParamProvider matrixProvider = new MatrixParamValueParamProvider((Provider<MultivaluedParameterExtractorProvider>)paramExtractor);
        suppliers.add(matrixProvider);
        PathParamValueParamProvider pathProvider = new PathParamValueParamProvider((Provider<MultivaluedParameterExtractorProvider>)paramExtractor);
        suppliers.add(pathProvider);
        QueryParamValueParamProvider queryProvider = new QueryParamValueParamProvider((Provider<MultivaluedParameterExtractorProvider>)paramExtractor);
        suppliers.add(queryProvider);
        BeanParamValueParamProvider beanProvider = new BeanParamValueParamProvider((Provider<MultivaluedParameterExtractorProvider>)paramExtractor, injectionManager);
        suppliers.add(beanProvider);
        WebTargetValueParamProvider webTargetProvider = new WebTargetValueParamProvider(configuration, clientConfigClass -> (Configuration)Injections.getOrCreate((InjectionManager)injectionManager, (Class)clientConfigClass));
        suppliers.add(webTargetProvider);
        DelegatedInjectionValueParamProvider contextProvider = new DelegatedInjectionValueParamProvider((LazyValue<ContextInjectionResolver>)lazyContextResolver, arg_0 -> ((InjectionManager)injectionManager).createForeignDescriptor(arg_0));
        suppliers.add(contextProvider);
        serverBag.setValueParamProviders(Collections.unmodifiableCollection(suppliers));
        injectionManager.register((Binding)((InstanceBinding)Bindings.service((Object)asyncProvider).to(ValueParamProvider.class)).id((long)InjectionIds.SERVER_ASYNC_RESPONSE_VALUE_PARAM_PROVIDER.id()));
        injectionManager.register((Binding)((InstanceBinding)Bindings.service((Object)cookieProvider).to(ValueParamProvider.class)).id((long)InjectionIds.SERVER_COOKIE_VALUE_PARAM_PROVIDER.id()));
        injectionManager.register((Binding)((InstanceBinding)Bindings.service((Object)formProvider).to(ValueParamProvider.class)).id((long)InjectionIds.SERVER_FORM_VALUE_PARAM_PROVIDER.id()));
        injectionManager.register((Binding)((InstanceBinding)Bindings.service((Object)headerProvider).to(ValueParamProvider.class)).id((long)InjectionIds.SERVER_HEADER_VALUE_PARAM_PROVIDER.id()));
        injectionManager.register((Binding)((InstanceBinding)Bindings.service((Object)matrixProvider).to(ValueParamProvider.class)).id((long)InjectionIds.SERVER_MATRIX_VALUE_PARAM_PROVIDER.id()));
        injectionManager.register((Binding)((InstanceBinding)Bindings.service((Object)pathProvider).to(ValueParamProvider.class)).id((long)InjectionIds.SERVER_PATH_VALUE_PARAM_PROVIDER.id()));
        injectionManager.register((Binding)((InstanceBinding)Bindings.service((Object)queryProvider).to(ValueParamProvider.class)).id((long)InjectionIds.SERVER_QUERY_VALUE_PARAM_PROVIDER.id()));
        injectionManager.register((Binding)((InstanceBinding)Bindings.service((Object)webTargetProvider).to(ValueParamProvider.class)).id((long)InjectionIds.SERVER_WEB_TARGET_VALUE_PARAM_PROVIDER.id()));
        injectionManager.register((Binding)((InstanceBinding)Bindings.service((Object)beanProvider).to(ValueParamProvider.class)).id((long)InjectionIds.SERVER_BEAN_VALUE_PARAM_PROVIDER.id()));
        injectionManager.register((Binding)((InstanceBinding)Bindings.service((Object)entityProvider).to(ValueParamProvider.class)).id((long)InjectionIds.SERVER_ENTITY_VALUE_PARAM_PROVIDER.id()));
        injectionManager.register((Binding)((InstanceBinding)Bindings.service((Object)contextProvider).to(ValueParamProvider.class)).id((long)InjectionIds.SERVER_CONTEXT_VALUE_PARAM_PROVIDER.id()));
        Provider request = () -> {
            RequestProcessingContextReference reference = (RequestProcessingContextReference)injectionManager.getInstance(RequestProcessingContextReference.class);
            return reference.get().request();
        };
        this.registerResolver(injectionManager, asyncProvider, Suspended.class, (Provider<ContainerRequest>)request, InjectionIds.SERVER_ASYNC_RESOLVER.id());
        this.registerResolver(injectionManager, cookieProvider, CookieParam.class, (Provider<ContainerRequest>)request, InjectionIds.SERVER_COOKIE_RESOLVER.id());
        this.registerResolver(injectionManager, formProvider, FormParam.class, (Provider<ContainerRequest>)request, InjectionIds.SERVER_FORM_RESOLVER.id());
        this.registerResolver(injectionManager, headerProvider, HeaderParam.class, (Provider<ContainerRequest>)request, InjectionIds.SERVER_HEADER_RESOLVER.id());
        this.registerResolver(injectionManager, matrixProvider, MatrixParam.class, (Provider<ContainerRequest>)request, InjectionIds.SERVER_MATRIX_RESOLVER.id());
        this.registerResolver(injectionManager, pathProvider, PathParam.class, (Provider<ContainerRequest>)request, InjectionIds.SERVER_PATH_RESOLVER.id());
        this.registerResolver(injectionManager, queryProvider, QueryParam.class, (Provider<ContainerRequest>)request, InjectionIds.SERVER_QUERY_RESOLVER.id());
        this.registerResolver(injectionManager, webTargetProvider, Uri.class, (Provider<ContainerRequest>)request, InjectionIds.SERVER_WEB_TARGET_RESOLVER.id());
        this.registerResolver(injectionManager, beanProvider, BeanParam.class, (Provider<ContainerRequest>)request, InjectionIds.SERVER_BEAN_RESOLVER.id());
    }

    private void registerResolver(InjectionManager im, ValueParamProvider vfp, Class<? extends Annotation> annotation, Provider<ContainerRequest> request, long id) {
        im.register((Binding)Bindings.injectionResolver(new ParamInjectionResolver<Annotation>(vfp, annotation, request)).id(id));
    }

    public void postInit(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
        List addedInstances = injectionManager.getAllInstances(ValueParamProvider.class);
        if (!addedInstances.isEmpty()) {
            ServerBootstrapBag serverBag = (ServerBootstrapBag)bootstrapBag;
            addedInstances.addAll(serverBag.getValueParamProviders());
            serverBag.setValueParamProviders(Collections.unmodifiableCollection(addedInstances));
        }
    }
}

