/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.embeddable;

import java.io.File;
import java.net.URI;
import java.util.Properties;
import java.util.Set;

public class GlassFishProperties {
    public static final String INSTANCE_ROOT_PROP_NAME = "com.sun.aas.instanceRoot";
    public static final String CONFIG_FILE_URI_PROP_NAME = "org.glassfish.embeddable.configFileURI";
    public static final String CONFIG_FILE_READ_ONLY = "org.glassfish.embeddable.configFileReadOnly";
    private static final String NETWORK_LISTENER_KEY = "embedded-glassfish-config.server.network-config.network-listeners.network-listener.%s";
    private final Properties gfProperties;

    public GlassFishProperties() {
        this.gfProperties = new Properties();
    }

    public GlassFishProperties(Properties props) {
        this.gfProperties = props;
    }

    public Properties getProperties() {
        return this.gfProperties;
    }

    public Set<String> getPropertyNames() {
        return this.gfProperties.stringPropertyNames();
    }

    public String getProperty(String name) {
        return this.gfProperties.getProperty(name);
    }

    public void setProperty(String key, String value) {
        this.gfProperties.setProperty(key, value);
    }

    public void setInstanceRoot(String instanceRoot) {
        this.gfProperties.setProperty(INSTANCE_ROOT_PROP_NAME, instanceRoot);
    }

    public String getInstanceRoot() {
        return this.gfProperties.getProperty(INSTANCE_ROOT_PROP_NAME);
    }

    @Deprecated(forRemoval=true, since="7.0.20")
    public void setConfigFileURI(String configFileURI) {
        if (configFileURI == null) {
            this.gfProperties.remove(CONFIG_FILE_URI_PROP_NAME);
            return;
        }
        if (configFileURI.startsWith("file:")) {
            this.setConfigFile(URI.create(configFileURI));
        } else {
            this.setConfigFile(new File(configFileURI).toURI());
        }
    }

    public void setConfigFile(File configFile) {
        if (configFile == null) {
            this.gfProperties.remove(CONFIG_FILE_URI_PROP_NAME);
            return;
        }
        this.setConfigFile(configFile.toURI());
    }

    public void setConfigFile(URI configFileURI) {
        if (configFileURI == null) {
            this.gfProperties.remove(CONFIG_FILE_URI_PROP_NAME);
            return;
        }
        if (configFileURI.isAbsolute()) {
            this.gfProperties.setProperty(CONFIG_FILE_URI_PROP_NAME, configFileURI.toString());
            return;
        }
        throw new IllegalArgumentException("The URI is not absolute: " + String.valueOf(configFileURI));
    }

    public URI getConfigFileURI() {
        String uri = this.gfProperties.getProperty(CONFIG_FILE_URI_PROP_NAME);
        return uri == null ? null : URI.create(uri);
    }

    public boolean isConfigFileReadOnly() {
        return Boolean.parseBoolean(this.gfProperties.getProperty(CONFIG_FILE_READ_ONLY, "true"));
    }

    public void setConfigFileReadOnly(boolean readOnly) {
        this.gfProperties.setProperty(CONFIG_FILE_READ_ONLY, Boolean.toString(readOnly));
    }

    public void setPort(String networkListener, int port) {
        String key;
        if (networkListener != null && (key = String.format(NETWORK_LISTENER_KEY, networkListener)) != null) {
            if (port <= 0) {
                this.gfProperties.setProperty(key + ".enabled", "false");
            } else {
                this.gfProperties.setProperty(key + ".port", Integer.toString(port));
                this.gfProperties.setProperty(key + ".enabled", "true");
            }
        }
    }

    public int getPort(String networkListener) {
        String key;
        int port = -1;
        if (networkListener != null && (key = String.format(NETWORK_LISTENER_KEY, networkListener)) != null) {
            String portStr = this.gfProperties.getProperty(key + ".port");
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return port;
    }
}

